/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.UevActivity;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class JourUEV
extends MainElement {
    public static final String table = "t_jour_uev";
    private int id = 0;
    private int vehicleId = 0;
    private int userId = 0;
    private java.util.Date day = null;
    private int km = 0;
    private int dailyKm = 0;
    private int total = 0;
    private String comment = null;
    private Vector<UevActivity> activities = null;

    public JourUEV(int id, int vehicleId, int userId, java.util.Date day, int km, int dailyKm, int total, String comment, Vector<UevActivity> activities) {
        this.id = id;
        this.vehicleId = vehicleId;
        this.day = day;
        this.km = km;
        this.dailyKm = dailyKm;
        this.total = total;
        this.comment = comment;
        this.activities = activities;
    }

    public JourUEV() {
    }

    public void setDay(int id, int vehicleId, int userId, java.util.Date day, int km, int dailyKm, int total, String comment, Vector<UevActivity> activities) {
        this.id = id;
        this.vehicleId = vehicleId;
        this.day = day;
        this.dailyKm = dailyKm;
        this.km = km;
        this.total = total;
        this.comment = comment;
        this.activities = activities;
    }

    public void print() {
        String detail = "";
        for (UevActivity a : this.activities) {
            detail = String.valueOf(detail) + "(" + a.getHeureDebut() + "/" + a.getCleType() + ")";
        }
        TimsLogger.debug("#JourUEV.print# " + this.vehicleId + " " + this.day + " " + this.km + " " + this.dailyKm + ", C = " + this.comment + ", T = " + this.activities.size() + " activit\u00e9s : " + detail);
    }

    public boolean insert() {
        boolean retour;
        block22: {
            retour = false;
            try {
                String sql = "";
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO t_jour_uev(ID, VEHICLE_ID, DATE_USE, USER_ID, KM, DAILY_KM, TOTAL, DAY_COMMENT, ACTIVITIES) VALUES (GEN_t_jour_uev.nextval,?,?,?,?,?,?,?,?";
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO t_jour_uev(VEHICLE_ID, DATE_USE, USER_ID, KM, DAILY_KM, TOTAL, DAY_COMMENT, ACTIVITIES) VALUES (?,?,?,?,?,?,?,?)";
                }
                this.statement = JourUEV.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.vehicleId, 12);
                this.statement.setDate(2, new Date(this.day.getTime()));
                this.statement.setObject(3, (Object)ConnexionSettings.getInstance().getUserCle(), 4);
                this.statement.setObject(4, (Object)this.km, 4);
                this.statement.setObject(5, (Object)this.dailyKm, 4);
                this.statement.setObject(6, (Object)this.total, 4);
                this.statement.setObject(7, (Object)this.comment, 12);
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    byte[] act = UevActivity.toCondensed(this.activities, "");
                    this.statement.setBinaryStream(8, (InputStream)new BufferedInputStream(new ByteArrayInputStream(act)), act.length);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    this.statement.setObject(8, (Object)UevActivity.toCondensed(this.activities, ""), 2004);
                }
                this.statement.executeUpdate();
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    break block22;
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                break block22;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("#Jour.insert# insertion d'une journ\u00e9e (retourne " + retour + ")");
        return retour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update() {
        TimsLogger.debug("#Jour.update# mise \u00e0 jour d'une journ\u00e9e");
        boolean toReturn = false;
        this.print();
        String sql = "UPDATE t_jour_uev SET VEHICLE_ID  = ?,DATE_USE = ?, KM = ?, DAILY_KM = ?, TOTAL = ?, DAY_COMMENT = ? ,ACTIVITIES = ? WHERE ID=?";
        try {
            try {
                this.statement = JourUEV.getConnection().prepareStatement(sql);
                this.statement = JourUEV.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.vehicleId, 4);
                this.statement.setDate(2, new Date(this.day.getTime()));
                this.statement.setObject(3, (Object)this.km, 4);
                this.statement.setObject(4, (Object)this.dailyKm, 4);
                this.statement.setObject(5, (Object)this.total, 4);
                this.statement.setObject(6, (Object)this.comment, 12);
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    byte[] act = UevActivity.toCondensed(this.activities, "");
                    this.statement.setBinaryStream(7, (InputStream)new BufferedInputStream(new ByteArrayInputStream(act)), act.length);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    this.statement.setObject(7, (Object)UevActivity.toCondensed(this.activities, ""), 2004);
                }
                int idx = 8;
                this.statement.setObject(idx, (Object)this.id, 4);
                TimsLogger.debug("#JourUEV.update# sql = " + sql);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void updateActivities() {
        this.setActivities(UevActivity.load(this.getVehicleId(), ConversionTime.dateToStringDb(this.getDay()), null));
        this.update();
    }

    public String getSQLInsert() {
        return String.valueOf(this.vehicleId) + "\t" + this.userId + "\t" + ConversionTime.dateToString(this.day, "yyyy-MM-dd") + "\t" + this.km + "\t" + this.dailyKm + "\t" + this.total + "\t" + this.comment + "\t" + Fonctions.parseHexAscii(UevActivity.toCondensed(this.activities, ""), 0, -1);
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public java.util.Date getDay() {
        return this.day;
    }

    public void setDay(java.util.Date day) {
        this.day = day;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    public int getDailyKm() {
        return this.dailyKm;
    }

    public void setDailyKm(int dailyKm) {
        this.dailyKm = dailyKm;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Vector<UevActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Vector<UevActivity> activities) {
        this.activities = activities;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int cleUser) {
        this.userId = cleUser;
    }

    public byte[] write(OutputStream out) {
        this.print();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#Jour.write# " + ex);
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 18) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
    }

    public static Vector<JourUEV> getJourUEV(java.util.Date begin, java.util.Date end, int agencyId, int vehicleId, boolean withActivities) {
        String sBegin = ConversionTime.dateToString(begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(end, "yyyy-MM-dd");
        return JourUEV.getJourUEV(sBegin, sEnd, agencyId, vehicleId, withActivities);
    }

    public static Vector<JourUEV> getJourUEV(String sBegin, String sEnd, int agencyId, int vehicleId, boolean withActivities) {
        String sql = "";
        Vector<JourUEV> result = new Vector<JourUEV>();
        try {
            sql = "SELECT ID, VEHICLE_ID, USER_ID, DATE_USE, KM, a.DAILY_KM, TOTAL, DAY_COMMENT";
            if (withActivities) {
                sql = String.valueOf(sql) + ", ACTIVITIES";
            }
            sql = String.valueOf(sql) + " FROM t_jour_uev";
            sql = String.valueOf(sql) + " a JOIN t_vehicule v ON a.vehicle_id = v.cle_vehicule";
            sql = String.valueOf(sql) + " WHERE DATE_USE BETWEEN " + BddTransport.getDateStringToSGBDR(sBegin, false) + " AND " + BddTransport.getDateStringToSGBDR(sEnd, false);
            if (agencyId != 0) {
                sql = String.valueOf(sql) + " AND v.CLE_AGENCE = " + agencyId;
            }
            if (vehicleId != 0) {
                sql = String.valueOf(sql) + " AND VEHICLE_ID = " + vehicleId;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_USE";
            Statement stm = JourUEV.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            TimsLogger.debug(sql);
            while (rs.next()) {
                JourUEV toAdd = new JourUEV(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getInt("USER_ID"), rs.getDate("DATE_USE"), rs.getInt("KM"), rs.getInt("DAILY_KM"), rs.getInt("TOTAL"), rs.getString("DAY_COMMENT"), null);
                if (withActivities) {
                    Blob blobActivities = rs.getBlob("ACTIVITIES");
                    if (blobActivities == null) {
                        TimsLogger.error("#JourUEV.getJourUEV# No condensed activities on " + toAdd.getDay());
                        toAdd.updateActivities();
                    } else {
                        toAdd.setActivities(UevActivity.fromCondensed(blobActivities.getBytes(1L, (int)blobActivities.length()), toAdd));
                    }
                }
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#JourUEV.getJourUEV()# Erreur sql = " + sql);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean delete(int vehicleId, java.util.Date date) {
        boolean toReturn = false;
        String sql = "DELETE FROM t_jour_uev WHERE VEHICLE_ID  = ? AND DATE_USE = ?";
        PreparedStatement stm = null;
        try {
            try {
                stm = JourUEV.getConnection().prepareStatement(sql);
                stm = JourUEV.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)vehicleId, 4);
                stm.setDate(2, new Date(date.getTime()));
                TimsLogger.debug("#JourUEV.delete# sql = " + sql);
                stm.executeUpdate();
                stm.close();
                toReturn = true;
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static JourUEV load(int vehicleId, java.util.Date day) {
        String sql = "";
        JourUEV result = null;
        try {
            sql = "SELECT ID, VEHICLE_ID, USER_ID, DATE_USE, KM, DAILY_KM, TOTAL, DAY_COMMENT, ACTIVITIES";
            sql = String.valueOf(sql) + " FROM t_jour_uev";
            sql = String.valueOf(sql) + " WHERE DATE_USE = " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(day, "yyyy-MM-dd"), false);
            if (vehicleId != 0) {
                sql = String.valueOf(sql) + " AND VEHICLE_ID = " + vehicleId;
            }
            Statement stm = JourUEV.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            TimsLogger.debug(sql);
            while (rs.next()) {
                result = new JourUEV(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getInt("USER_ID"), rs.getDate("DATE_USE"), rs.getInt("KM"), rs.getInt("DAILY_KM"), rs.getInt("TOTAL"), rs.getString("DAY_COMMENT"), null);
                Blob blobActivities = rs.getBlob("ACTIVITIES");
                if (blobActivities == null) {
                    result.updateActivities();
                    continue;
                }
                result.setActivities(UevActivity.fromCondensed(blobActivities.getBytes(1L, (int)blobActivities.length()), result));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#JourUEV.getJourUEV()# Erreur sql = " + sql);
        }
        return result;
    }
}

