/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class LoadUnload
extends MainElement {
    public static final String table = "DRIVER_LOAD";
    public static final int OUT_BEGIN = 1;
    public static final int OUT_END = 2;
    public static final int FERRY = 3;
    private int id = 0;
    private int driverId = 0;
    private Date timestamp = null;
    private int operationType = 0;
    private int gnssAccuracy = 0;
    private float longitude = 0.0f;
    private float latitude = 0.0f;
    private int authenticationStatus = 0;
    private int odometerValue = 0;

    public LoadUnload(int id, int driverId, Date timestamp, int operationType, int gnssAccuracy, String hexCoordinate, int authenticationStatus, int odometerValue) {
        this.id = id;
        this.driverId = driverId;
        this.timestamp = timestamp;
        this.operationType = operationType;
        this.gnssAccuracy = gnssAccuracy;
        this.longitude = Fonctions.getLongitudeFromHex(hexCoordinate);
        this.latitude = Fonctions.getLatitudeFromHex(hexCoordinate);
        this.authenticationStatus = authenticationStatus;
        this.odometerValue = odometerValue;
    }

    public LoadUnload(int id, int driverId, Date timestamp, int operationType, int gnssAccuracy, float longitude, float latitude, int authenticationStatus, int odometerValue) {
        this.id = id;
        this.driverId = driverId;
        this.timestamp = timestamp;
        this.operationType = operationType;
        this.gnssAccuracy = gnssAccuracy;
        this.longitude = longitude;
        this.latitude = latitude;
        this.authenticationStatus = authenticationStatus;
        this.odometerValue = odometerValue;
    }

    public int getId() {
        return this.id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public int getGnssAccuracy() {
        return this.gnssAccuracy;
    }

    public void setGnssAccuracy(int gnssAccuracy) {
        this.gnssAccuracy = gnssAccuracy;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(float longitude) {
        this.longitude = longitude;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(float latitude) {
        this.latitude = latitude;
    }

    public int getAuthenticationStatus() {
        return this.authenticationStatus;
    }

    public void setAuthenticationStatus(int authenticationStatus) {
        this.authenticationStatus = authenticationStatus;
    }

    public int getOdometerValue() {
        return this.odometerValue;
    }

    public void setOdometerValue(int odometerValue) {
        this.odometerValue = odometerValue;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#SpecificCondition.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO DRIVER_LOAD (" + LoadUnload.getAllFields() + ")" + " VALUES (GEN_SPECIFIC_CONDITION.nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO DRIVER_LOAD (" + LoadUnload.getAllFields().substring(LoadUnload.getAllFields().indexOf(",")) + ")" + " VALUES (?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = LoadUnload.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.timestamp.getTime()));
            this.statement.setObject(3, (Object)this.operationType, 4);
            this.statement.setObject(4, (Object)this.gnssAccuracy, 4);
            this.statement.setObject(5, (Object)Float.valueOf(this.longitude), 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.latitude), 4);
            this.statement.setObject(7, (Object)this.authenticationStatus, 4);
            this.statement.setObject(8, (Object)this.odometerValue, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM DRIVER_LOAD WHERE ID = ?";
        try {
            try {
                this.statement = LoadUnload.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public String getSqlString() {
        SimpleDateFormat dateFormatBddHeure = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatBddHeure.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        return String.valueOf(this.getDriverId()) + "\t" + dateFormatBddHeure.format(this.getTimestamp()) + "\t" + this.getOperationType();
    }

    private static String getAllFields() {
        return "ID, DRIVER_ID, SPECIFIC_TIMESTAMP, SPECIFIC_TYPE";
    }

    public static Vector<LoadUnload> loadList(int driverId, Date begin, Date end) {
        String sql = "";
        Vector<LoadUnload> result = new Vector<LoadUnload>();
        try {
            String res = "";
            if (driverId != 0) {
                res = String.valueOf(res) + " AND DRIVER_ID = ?";
            }
            if (begin != null) {
                res = end != null ? String.valueOf(res) + " AND TIMESTAMP BETWEEN ? AND ?" : String.valueOf(res) + " AND TIMESTAMP = ?";
            }
            sql = "SELECT " + LoadUnload.getAllFields() + " FROM " + table;
            if (!res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY ID";
            PreparedStatement stm = LoadUnload.getConnection().prepareStatement(sql);
            int ind = 1;
            if (driverId != 0) {
                stm.setObject(ind, (Object)driverId, 4);
                ++ind;
            }
            if (begin != null) {
                stm.setTimestamp(ind, new Timestamp(begin.getTime()));
                ++ind;
            }
            if (end != null) {
                stm.setTimestamp(ind, new Timestamp(end.getTime()));
            }
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                result.add(new LoadUnload(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getTimestamp("TIMESTAMP"), rs.getInt("OPERATION_TYPE"), rs.getInt("GNSS_ACCURACY"), rs.getFloat("LONGITUDE"), rs.getFloat("LATITUDE"), rs.getInt("AUTHENTICATION_STATUTS"), rs.getInt("ODOMETER")));
            }
            TimsLogger.verbose("#LoadUnload.loadList# sql = " + sql + " return " + result.size() + " results");
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#SpecificCondition.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }
}

