/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Vehicule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Vector;
import transpo.system.ui.resources.Fmresources;

public abstract class MainElement {
    protected PreparedStatement statement = null;
    protected static final Fmresources res = new Fmresources();

    public static String getDateFromSGBD(String date) {
        if (date == null || date.startsWith("0001-01-01") || date.startsWith("1970-01-01")) {
            return "";
        }
        return date;
    }

    public static String getDateToSGBD(String date) {
        if (date == null || date.equals("")) {
            return "1970-01-01";
        }
        if (date.length() > 10) {
            date = date.substring(0, 10);
        }
        return date;
    }

    public static String getTimestampToSGBD(String date) {
        if (date == null || date.equals("")) {
            return "1970-01-01 00:00:00.0";
        }
        if (date.length() == 10) {
            date = String.valueOf(date) + " 00:00:00.0";
        }
        return date;
    }

    protected static String buildAgencyFilters(Vector<Agence> agencies, String field) {
        if (agencies == null || agencies.size() == 0) {
            return "";
        }
        String filters = String.valueOf(field) + " IN (%)";
        String sAgencies = "";
        for (Agence agency : agencies) {
            sAgencies = String.valueOf(sAgencies) + "," + agency.getCleAgence();
        }
        return filters.replace("%", sAgencies.substring(1));
    }

    protected static String buildDriverFilters(Vector<Conducteur> drivers, String field) {
        if (drivers == null || drivers.size() == 0) {
            return "";
        }
        String filters = String.valueOf(field) + " IN (%)";
        String sConducteur = "";
        for (Conducteur conducteur : drivers) {
            sConducteur = String.valueOf(sConducteur) + "," + conducteur.getCleConducteur();
        }
        return filters.replace("%", sConducteur.substring(1));
    }

    protected static String buildVehicleFilters(Vector<Vehicule> vehicles, String field) {
        if (vehicles == null || vehicles.size() == 0) {
            return "";
        }
        String filters = String.valueOf(field) + " IN (%)";
        String sVehicle = "";
        for (Vehicule vehicle : vehicles) {
            sVehicle = String.valueOf(sVehicle) + "," + vehicle.getCleVehicule();
        }
        return filters.replace("%", sVehicle.substring(1));
    }

    protected static Connection getConnection() {
        return BddTransport.getInstance().getConnection();
    }
}

