/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class Offence
extends MainElement {
    public static int OFFSET = 119;
    public static final String table = "offence";
    public static final int INFORMATION = 0;
    public static final int MINOR = 1;
    public static final int SERIOUS = 2;
    public static final int VERY_SERIOUS = 3;
    private int id = 0;
    private int driverId = 0;
    private java.util.Date date = null;
    private int time = 0;
    private int offencePartId = 0;
    private int threshold = 0;
    private boolean raw = false;
    private int type = 1;
    private int cost = 0;

    public Offence() {
    }

    public Offence(int driverId, java.util.Date date, int time, int offencePartId, int threshold, boolean raw, int type, int cost) {
        this.driverId = driverId;
        this.date = date;
        this.time = time;
        this.offencePartId = offencePartId;
        this.threshold = threshold;
        this.raw = raw;
        this.type = type;
        this.cost = cost;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public java.util.Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getOffencePartId() {
        return this.offencePartId;
    }

    public void setOffencePartId(int offencePartId) {
        this.offencePartId = offencePartId;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDesignation() {
        OffencePart part = OffencePart.getOffencePart(this.getOffencePartId());
        if (part == null) {
            return LanguageTranslator.getString("generics.unknown");
        }
        OffenceType type = OffenceType.getOffenceType(part.getOffenceTypeId());
        if (type == null) {
            return LanguageTranslator.getString("generics.unknown");
        }
        return String.valueOf(LanguageTranslator.getString(type.getName())) + " (" + LanguageTranslator.getString(part.getName()) + ")";
    }

    public void affiche() {
        TimsLogger.info("Cle conducteur : " + this.getDriverId() + "\tCle infraction : " + this.offencePartId + ", jour infraction : " + this.getDate() + ", heure infraction : " + this.getTime() + ", seuil infraction : " + this.getThreshold());
    }

    public String getSQLInsert() {
        String sBrut = this.isRaw() ? "1" : "0";
        String sql = String.valueOf(this.getDriverId()) + "\t" + ConversionTime.dateToString(this.getDate(), "yyyy-MM-dd") + "\t" + this.getTime() + "\t" + this.offencePartId + "\t" + this.getThreshold() + "\t" + sBrut + "\t" + this.type + "\t" + this.cost;
        return sql;
    }

    public void insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO offence (ID, DRIVER_ID, DAY, HOUR, OFFENCE_PART_ID, THRESHOLD, ON_UPDATED, TYPE, COST) VALUES (GEN_T_INFRACTIONS.nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO offence (DRIVER_ID, DAY, HOUR, OFFENCE_PART_ID, THRESHOLD, ON_UPDATED, TYPE, COST) VALUES (?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Offence.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                this.statement.setObject(3, (Object)this.time, 4);
                this.statement.setObject(4, (Object)this.offencePartId, 4);
                this.statement.setObject(5, (Object)this.threshold, 4);
                this.statement.setObject(6, (Object)(this.raw ? 1 : 0), 4);
                this.statement.setObject(7, (Object)this.type, 4);
                this.statement.setObject(8, (Object)this.cost, 4);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean loadByOffence(Offence offence) {
        boolean toReturn = false;
        ResultSet rs = null;
        PreparedStatement stm = null;
        String sql = "SELECT * FROM offence WHERE DRIVER_ID =? AND DAY=? AND HOUR=? AND ON_UPDATED=? AND OFFENCE_PART_ID=?";
        try {
            try {
                stm = Offence.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)offence.getDriverId(), 4);
                stm.setDate(2, new Date(offence.getDate().getTime()));
                stm.setObject(3, (Object)offence.getTime(), 4);
                stm.setObject(4, (Object)offence.isRaw(), 4);
                stm.setObject(5, (Object)offence.getOffencePartId(), 4);
                rs = stm.executeQuery();
                while (rs.next()) {
                    this.setId(rs.getInt("ID"));
                    this.setDriverId(rs.getInt("DRIVER_ID"));
                    this.setDate(rs.getDate("DAY"));
                    this.setTime(rs.getInt("HOUR"));
                    this.setOffencePartId(rs.getInt("OFFENCE_PART_ID"));
                    this.setThreshold(rs.getInt("THRESHOLD"));
                    this.setRaw(rs.getBoolean("ON_UPDATED"));
                    this.setType(rs.getInt("TYPE"));
                    toReturn = true;
                }
                TimsLogger.debug("#Offence.exist# " + this.date + " " + offence.getTime() + " " + this.offencePartId + " " + offence.getOffencePartId() + " " + (offence.getType() == 1) + " => " + (toReturn ? "exist" : "does not exist"));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Offence.load() # : " + ex);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM offence WHERE ID =?";
        PreparedStatement statement = null;
        try {
            try {
                statement = Offence.getConnection().prepareStatement(sql);
                statement.setObject(1, this.id);
                statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public byte[] write(OutputStream out) {
        return null;
    }

    public void read(byte[] fileBuffer) {
    }

    public static Vector<Offence> loadList(Vector<Agence> agencies, Vector<Conducteur> drivers, String begin, String end, boolean raw, boolean includeArchived) {
        String restriction = "";
        if (drivers == null || drivers.size() == 0) {
            String agencyFilter = Offence.buildAgencyFilters(agencies, "CLE_AGENCE");
            restriction = String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ")";
        } else {
            restriction = String.valueOf(restriction) + " AND " + Offence.buildDriverFilters(drivers, "DRIVER_ID");
        }
        String restrict = BddTransport.addNewRestriction(null, true, table, false);
        if (restrict != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if (begin != null) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(begin, false) + " AND " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(restriction) + " AND DAY =" + BddTransport.getDateStringToSGBDR(begin, false);
        }
        restriction = String.valueOf(restriction) + " AND ON_UPDATED = " + (raw ? "1" : "0");
        if (drivers == null || drivers.size() == 0) {
            restriction = String.valueOf(restriction) + " AND c.ARCHIVAGE = 0";
        }
        return Offence.loadList(restriction);
    }

    public static Vector<Offence> loadList(int agencyId, int driverId, String begin, String end, boolean raw, boolean includeArchived) {
        String restrict;
        String restriction = "";
        if (agencyId != 0 && driverId == 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (driverId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
        }
        if ((restrict = BddTransport.addNewRestriction(null, true, table, true)) != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if (begin != null) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(begin, false) + " AND " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(restriction) + " AND DAY =" + BddTransport.getDateStringToSGBDR(begin, false);
        }
        restriction = String.valueOf(restriction) + " AND ON_UPDATED = " + (raw ? "1" : "0");
        if (!includeArchived && driverId == 0) {
            restriction = String.valueOf(restriction) + " AND c.ARCHIVAGE = 0";
        }
        return Offence.loadList(restriction);
    }

    public static Vector<Offence> loadList(String filters) {
        Vector<Offence> list = new Vector<Offence>();
        String sql = "SELECT ID, DRIVER_ID, DAY, HOUR, OFFENCE_PART_ID, THRESHOLD, ON_UPDATED, TYPE, COST, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR FROM offence JOIN t_conducteur c ON c.CLE_CHAUFFEUR = DRIVER_ID" + (filters.equals("") ? "" : " WHERE " + (filters.startsWith(" AND") ? filters.substring(5) : filters)) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, DAY, OFFENCE_PART_ID, TYPE";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = Offence.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                Offence toAdd = new Offence(rs.getInt("DRIVER_ID"), rs.getDate("DAY"), rs.getInt("HOUR"), rs.getInt("OFFENCE_PART_ID"), rs.getInt("THRESHOLD"), rs.getBoolean("ON_UPDATED"), rs.getInt("TYPE"), rs.getInt("COST"));
                list.add(toAdd);
            }
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate infraction", "#Offence.loadList() => %s# sql = " + sql, 1);
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Offence.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return list;
    }

    public static boolean delete(int agencyId, int driverId, java.util.Date begin, java.util.Date end, boolean onRaw) {
        return Offence.delete(agencyId, driverId, ConversionTime.dateToString(begin, "yyyy-MM-dd"), ConversionTime.dateToString(end, "yyyy-MM-dd"), onRaw);
    }

    public static boolean delete(int agencyId, int driverId, String begin, String end, boolean onRaw) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement stm = null;
        String sql = "DELETE FROM offence";
        String restriction = "";
        restriction = agencyId != 0 ? String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")" : (driverId != 0 ? String.valueOf(restriction) + " AND DRIVER_ID = " + driverId : String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + ")");
        if (begin != null) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(begin, false) + " AND " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(restriction) + " AND DAY =" + BddTransport.getDateStringToSGBDR(begin, false);
        }
        if (!(restriction = String.valueOf(restriction) + " AND ON_UPDATED = " + (onRaw ? "1" : "0")).equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        try {
            try {
                TimsLogger.debug("#Offence.delete# sql = " + sql);
                stm = Offence.getConnection().createStatement();
                stm.executeUpdate(sql);
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Offence.delete() # : " + ex);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

