/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class OffenceThreshold
extends MainElement {
    public static String table = "offence_threshold";
    private static Vector<OffenceThreshold> list = null;
    private int id = 0;
    private int offencePartId = 0;
    private String name = null;
    private int threshold = 0;
    private int infrigement = 0;
    private int infrigementClass = 0;
    private String reference = null;

    public OffenceThreshold() {
    }

    public OffenceThreshold(int id, int offencePartId, String name, int threshold, int infrigement, int infrigementClass, String reference) {
        this.id = id;
        this.offencePartId = offencePartId;
        this.name = name;
        this.threshold = threshold;
        this.infrigement = infrigement;
        this.infrigementClass = infrigementClass;
        this.reference = reference;
    }

    public Object clone() {
        return new OffenceThreshold(this.id, this.offencePartId, this.name, this.threshold, this.infrigement, this.infrigementClass, this.reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (ID, OFFENCE_PART_ID, NAME, THRESHOLD)" + " VALUES (GEN_OFFENCE_TYPE.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (OFFENCE_PART_ID, NAME, THRESHOLD) VALUES (?,?,?)";
        }
        try {
            try {
                this.statement = OffenceThreshold.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.offencePartId, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setObject(3, (Object)this.threshold, 4);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                String tracer = String.valueOf(LanguageTranslator.getString("generics.offenceThreshold")) + " (" + this.getName() + ") \n";
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean update() {
        if (this.id != 0) {
            return this.updateValue();
        }
        return this.insert();
    }

    public boolean compareAndUpdate(int offencePartId, String name, int threshold) {
        String tracer = "offence.threshold n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (offencePartId != this.offencePartId) {
            tracer = String.valueOf(tracer) + "offence.part.id '" + this.offencePartId + "' => '" + offencePartId + "'\n";
            this.setOffencePartId(offencePartId);
        }
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + "generics.designation '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (threshold != this.threshold) {
            tracer = String.valueOf(tracer) + "offence.threshold '" + this.threshold + "' => '" + threshold + "'\n";
            this.setThreshold(threshold);
        }
        if (!tracer.equals("offence.threshold n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            TimsLogger.debug("#OffenceThreshold# " + name + " => update changes");
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#OffenceThreshold# " + name + " => no changes");
        return true;
    }

    public void affiche() {
        TimsLogger.info("#OffenceThreshold# " + this.id + ", " + this.name + ", " + this.threshold);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateValue() {
        boolean toReturn = false;
        this.affiche();
        String sql = "UPDATE " + table + " SET " + " OFFENCE_PART_ID=? ," + " NAME=? ," + " THRESHOLD=?" + " WHERE ID=?";
        try {
            try {
                this.statement = OffenceThreshold.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.offencePartId, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setObject(3, (Object)this.threshold, 4);
                this.statement.setObject(4, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getOffencePartId() {
        return this.offencePartId;
    }

    public void setOffencePartId(int offencePartId) {
        this.offencePartId = offencePartId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getInfrigement() {
        return this.infrigement;
    }

    public void setInfrigement(int infrigment) {
        this.infrigement = infrigment;
    }

    public int getInfrigementClass() {
        return this.infrigementClass;
    }

    public void setInfrigementClass(int infrigmentClass) {
        this.infrigementClass = infrigmentClass;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public static Vector<OffenceThreshold> getList() {
        if (list == null) {
            list = OffenceThreshold.loadList();
        }
        return list;
    }

    public static void setList(Vector<OffenceThreshold> list) {
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#OffenceThreshold.setList# define a new list");
        }
        OffenceThreshold.list = list;
    }

    public static OffenceThreshold getOffenceThreshold(int offenceThresholdId) {
        for (OffenceThreshold tmp : OffenceThreshold.getList()) {
            if (tmp.getId() != offenceThresholdId) continue;
            return tmp;
        }
        TimsLogger.warn("#OffenceType.getOffenceType# not found : " + offenceThresholdId);
        return null;
    }

    private static Vector<OffenceThreshold> loadList() {
        Vector<OffenceThreshold> toReturn;
        block4: {
            toReturn = new Vector<OffenceThreshold>();
            String sql = "SELECT ID, OFFENCE_PART_ID, NAME, THRESHOLD, INFRINGEMENT, INFRINGEMENT_CLASS, REFERENCE FROM " + table;
            try {
                Statement stm = OffenceThreshold.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new OffenceThreshold(rs.getInt("ID"), rs.getInt("OFFENCE_PART_ID"), rs.getString("NAME"), rs.getInt("THRESHOLD"), rs.getInt("INFRINGEMENT"), rs.getInt("INFRINGEMENT_CLASS"), rs.getString("REFERENCE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (SQLException ex) {
                TimsLogger.warn("#OffenceThreshold.loadList()# " + ex);
                TimsLogger.debug(sql);
                if (Transport.debug < 1) break block4;
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Vector<OffenceThreshold> getOffencePartList(int offencePartId) {
        Vector<OffenceThreshold> toReturn = new Vector<OffenceThreshold>();
        for (OffenceThreshold part : OffenceThreshold.getList()) {
            if (part.getOffencePartId() != offencePartId) continue;
            toReturn.add(part);
        }
        return toReturn;
    }
}

