/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class OffenceType
extends MainElement {
    public static final int VOYAGEUR = 1;
    public static final int MERCHANDISING = 2;
    public static String table = "offence_type";
    private static Vector<OffenceType> list = null;
    private int id = 0;
    private String name = null;
    private String classToLoad = null;
    private int memberState = 0;
    private int companyType = 0;
    private Vector<OffencePart> parts = null;

    public OffenceType() {
    }

    public OffenceType(int id, String name, String classToLoad, int memberState, int companyType, Vector<OffencePart> parts) {
        this.id = id;
        this.name = name;
        this.classToLoad = classToLoad;
        this.memberState = memberState;
        this.companyType = companyType;
        this.parts = parts;
    }

    public Object clone() {
        return new OffenceType(this.id, this.name, this.classToLoad, this.memberState, this.companyType, this.parts);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof OffenceType && ((OffenceType)obj).getId() == this.id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (ID, NAME, MEMBER_STATE, COMPANY_TYPE)" + " VALUES (GEN_OFFENCE_TYPE.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (NAME MEMBER_STATE, COMPANY_TYPE) VALUES (?,?,?)";
        }
        try {
            try {
                this.statement = OffenceType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.name, 12);
                this.statement.setObject(2, (Object)this.memberState, 12);
                this.statement.setObject(3, (Object)this.companyType, 12);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                String tracer = String.valueOf(LanguageTranslator.getString("generics.offenceType")) + " (" + this.getName() + ") \n";
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean update() {
        if (this.id != 0) {
            return this.updateValue();
        }
        return this.insert();
    }

    public boolean compareAndUpdate(String name, int memberState, int companyType) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.offenceType")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (memberState != this.memberState) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.memberState") + " '" + this.memberState + "' => '" + memberState + "'\n";
            this.setMemberState(memberState);
        }
        if (companyType != this.companyType) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.companyType") + " '" + this.companyType + "' => '" + companyType + "'\n";
            this.setCompanyType(companyType);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.offenceType")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public void affiche() {
        TimsLogger.info("#OffenceType# " + this.id + ", " + this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateValue() {
        boolean toReturn = false;
        this.affiche();
        String sql = "UPDATE " + table + " SET " + " NAME=? ," + " MEMBER_STATE=? ," + " COMPANY_TYPE=?" + " WHERE ID=?";
        try {
            try {
                this.statement = OffenceType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.name, 12);
                this.statement.setObject(2, (Object)this.memberState, 12);
                this.statement.setObject(3, (Object)this.companyType, 12);
                this.statement.setObject(4, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMemberState() {
        return this.memberState;
    }

    public void setMemberState(int memberState) {
        this.memberState = memberState;
    }

    public int getCompanyType() {
        return this.companyType;
    }

    public void setCompanyType(int companyType) {
        this.companyType = companyType;
    }

    public String getClassToLoad() {
        return this.classToLoad;
    }

    public void setClassToLoad(String classToLoad) {
        this.classToLoad = classToLoad;
    }

    public Vector<OffencePart> getParts() {
        return this.parts;
    }

    public void setParts(Vector<OffencePart> parts) {
        this.parts = parts;
    }

    public static Vector<OffenceType> getList() {
        if (list == null) {
            list = OffenceType.loadList(-1);
        }
        return list;
    }

    public static void setList(Vector<OffenceType> list) {
        TimsLogger.debug("#OffenceType.setList# define a new list");
        OffenceType.list = list;
    }

    public static OffenceType getOffenceType(int offenceTypeId) {
        for (OffenceType tmp : OffenceType.getList()) {
            if (tmp.getId() != offenceTypeId) continue;
            return tmp;
        }
        TimsLogger.debug("#OffenceType.getOffenceType# not found : " + offenceTypeId);
        return null;
    }

    public static Vector<OffenceType> loadList(int memberState) {
        Vector<OffenceType> toReturn;
        block5: {
            toReturn = new Vector<OffenceType>();
            String sql = "SELECT ID, NAME, CLASS, MEMBER_STATE, COMPANY_TYPE FROM " + table + " WHERE COMPANY_TYPE IN (0," + System.getProperty("company.type", "1") + ")";
            if (memberState != -1) {
                sql = String.valueOf(sql) + " AND MEMBER_STATE = " + memberState;
            }
            try {
                Statement stm = OffenceType.getConnection().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new OffenceType(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CLASS"), rs.getInt("MEMBER_STATE"), rs.getInt("COMPANY_TYPE"), OffencePart.getOffenceTypeList(rs.getInt("ID"))));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (SQLException ex) {
                TimsLogger.warn("#OffenceType.loadList()# " + ex);
                TimsLogger.debug(sql);
                if (Transport.debug < 1) break block5;
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

