/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import transpo.system.TimsLogger;

public class Offense
extends MainElement {
    public static int OFFSET = 119;
    public static final String designCC = "Conduite continue max (CC)";
    public static final String designCJMax = "Conduite journaliere maximale (CJ)";
    public static final String designCJTolere = "CJ tol\u00e9r\u00e9";
    public static final String designCHMax = "Conduite hebdomadaire max (CH)";
    public static final String designCBHMax = "Conduite sur 2 semaines max (C2S)";
    public static final String designRJMin = "Repos journalier min (RJ)";
    public static final String designRJTolere = "RJ tol\u00e9r\u00e9";
    public static final String designRHMin = "Repos hebdomadaire min (RH)";
    public static final String designRHRed = "2 repos hebdomadaire r\u00e9duit";
    public static final String designTEJMax = "TE journalier max (TEJ)";
    public static final String designTEJTolere = "TEJ tol\u00e9r\u00e9";
    public static final String designTEHMax = "TE hebdomadaire max (TEH) grands routiers";
    public static final String designTEBHMax = "TE sur 2 semaines (TE2S) max";
    public static final String designTEC1 = "TE continue 6h";
    public static final String designTEC2 = "TE continue 9h";
    private int driverId = 0;
    private String lastName = null;
    private String firstName = null;
    private String date = null;
    private int time = 0;
    private String code = null;
    private String maxThreshold = null;
    private String threshold = null;
    private String designation = null;
    private boolean brute = false;

    public Offense() {
    }

    public Offense(int cleCond, String dateJour, int heure, String cleInfra, String seuilInfra, String seuilT, String design, boolean brute) {
        this.driverId = cleCond;
        this.date = dateJour.substring(0, 10);
        this.time = heure;
        this.code = cleInfra;
        this.threshold = seuilInfra;
        this.designation = design;
        this.maxThreshold = seuilT;
        this.brute = brute;
    }

    public Offense(int cleCond, String dateJour, int heure, String cleInfra, String seuilInfra, boolean brute) {
        this.driverId = cleCond;
        this.date = dateJour.substring(0, 10);
        this.time = heure;
        this.code = cleInfra;
        this.threshold = seuilInfra;
        this.brute = brute;
    }

    public Offense(String dateJour, int heure, String designInfra, String seuilT, String seuilInfra, String nom, String prenom, boolean brute) {
        this.date = dateJour.substring(0, 10);
        this.time = heure;
        this.designation = designInfra;
        this.threshold = seuilInfra;
        this.lastName = nom;
        this.firstName = prenom;
        this.maxThreshold = seuilT;
        this.brute = brute;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCode() {
        return this.code;
    }

    public String getDate() {
        return this.date;
    }

    public int getTime() {
        return this.time;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getMaxThreshold() {
        return this.maxThreshold;
    }

    public String getDesignation() {
        return this.designation;
    }

    public boolean getBrute() {
        return this.brute;
    }

    public void affiche() {
        TimsLogger.info("Cle conducteur : " + this.getDriverId() + "\tCle infraction : " + this.getCode() + ", jour infraction : " + this.getDate() + ", heure infraction : " + this.getTime() + ", seuil infraction : " + this.getThreshold());
    }

    public String getSQLInsert() {
        String sBrut = this.getBrute() ? "1" : "0";
        String sql = String.valueOf(this.getDriverId()) + "\t" + this.getDate() + "\t" + this.getTime() + "\t" + this.getCode() + "\t" + this.getThreshold() + "\t" + sBrut;
        return sql;
    }

    public void insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_infractions (CLE,CLE_CHAUFFEUR,\"DATE\", HEURE_DEPASSEMENT , NUM_INFRACTIONS ,SEUIL_CONSTATE, BRUTE ) VALUES (GEN_T_INFRACTIONS.nextval,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_infractions (CLE_CHAUFFEUR,\"DATE\", HEURE_DEPASSEMENT , NUM_INFRACTIONS ,SEUIL_CONSTATE, BRUTE ) VALUES (?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Offense.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, Date.valueOf(this.date));
                this.statement.setObject(3, (Object)this.time, 4);
                this.statement.setObject(4, (Object)this.code, 12);
                this.statement.setObject(5, (Object)this.threshold, 4);
                this.statement.setObject(6, (Object)this.brute, 4);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.date);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.time + (int)Math.pow(2.0, 11.0)).substring(1);
            int x = 0;
            while (x < 3) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            tmp.write(this.brute ? 1 : 0);
            tmp.write(this.code.getBytes().length);
            tmp.write(this.code.getBytes());
            tmp.write(this.threshold.getBytes().length);
            tmp.write(this.threshold.getBytes());
            out.write((byte)OFFSET);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#Offenses.write# " + ex);
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 3) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.date = ConversionTime.binaryToDateString(tmp);
        this.time = Integer.parseInt(tmp.substring(13, 24), 2);
        this.brute = fileBuffer[3] == 1;
        this.code = new String(fileBuffer).substring(5, 5 + fileBuffer[4]);
        this.threshold = new String(fileBuffer).substring(5 + fileBuffer[4] + 1, 5 + fileBuffer[5 + fileBuffer[4]] + 1);
    }
}

