/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import fr.pgh.data.bdd.ElementArbre;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class Pays
implements ElementArbre {
    public static String[][] LIBELLE = new String[][]{{"UNK", LanguageTranslator.getString("UNKNOWN")}, {"A__", LanguageTranslator.getString("AUSTRIA")}, {"AL_", LanguageTranslator.getString("ALBANIA")}, {"AND", LanguageTranslator.getString("ANDORRA")}, {"ARM", LanguageTranslator.getString("ARMENIA")}, {"AZ_", LanguageTranslator.getString("AZERBAIDJAN")}, {"B__", LanguageTranslator.getString("BELGIUM")}, {"BG_", LanguageTranslator.getString("BULGARIA")}, {"BIH", LanguageTranslator.getString("BOSNIA_AND_HERZEGOVINA")}, {"BY_", LanguageTranslator.getString("BELARUS")}, {"CH_", LanguageTranslator.getString("SWITZERLAND")}, {"CY_", LanguageTranslator.getString("CYPRUS")}, {"CZ_", LanguageTranslator.getString("CZECH_REPUBLIC")}, {"D__", LanguageTranslator.getString("GERMANY")}, {"DK_", LanguageTranslator.getString("DENMARK")}, {"E__", LanguageTranslator.getString("SPAIN")}, {"EST", LanguageTranslator.getString("ESTONIA")}, {"F__", LanguageTranslator.getString("FRANCE")}, {"FIN", LanguageTranslator.getString("FINLAND")}, {"FL_", LanguageTranslator.getString("LIECHTENSTEIN")}, {"FR_", LanguageTranslator.getString("FAEROE_ISLANDS")}, {"UK_", LanguageTranslator.getString("UNITED_KINGDOM")}, {"GE_", LanguageTranslator.getString("GEORGIA")}, {"GR_", LanguageTranslator.getString("GREECE")}, {"H__", LanguageTranslator.getString("HUNGARY")}, {"HR_", LanguageTranslator.getString("CROATIA")}, {"I__", LanguageTranslator.getString("ITALY")}, {"IRL", LanguageTranslator.getString("IRELAND")}, {"IS_", LanguageTranslator.getString("ICELAND")}, {"KZ_", LanguageTranslator.getString("KAZAKHSTAN")}, {"L__", LanguageTranslator.getString("LUXEMBOURG")}, {"LT_", LanguageTranslator.getString("LITHUANIA")}, {"LV_", LanguageTranslator.getString("LATVIA")}, {"M__", LanguageTranslator.getString("MALTA")}, {"MC_", LanguageTranslator.getString("MONACO")}, {"MD_", LanguageTranslator.getString("REPUBLIC_OF_MOLDOVA")}, {"MK_", LanguageTranslator.getString("MACEDONIA")}, {"N__", LanguageTranslator.getString("NORWAY")}, {"NL_", LanguageTranslator.getString("NETHERLANDS")}, {"P__", LanguageTranslator.getString("PORTUGAL")}, {"PL_", LanguageTranslator.getString("POLAND")}, {"RO_", LanguageTranslator.getString("ROMANIA")}, {"RSM", LanguageTranslator.getString("SAN_MARINO")}, {"RUS", LanguageTranslator.getString("RUSSIA")}, {"S__", LanguageTranslator.getString("SWEDEN")}, {"SK_", LanguageTranslator.getString("SLOVAKIA")}, {"SLO", LanguageTranslator.getString("SLOVENIA")}, {"TM_", LanguageTranslator.getString("TURKMENISTAN")}, {"TR_", LanguageTranslator.getString("TURKEY")}, {"UA_", LanguageTranslator.getString("UKRAINE")}, {"V__", LanguageTranslator.getString("VATICAN")}, {"YU_", LanguageTranslator.getString("YUGOSLAVIA")}, {"EC_", LanguageTranslator.getString("EUROPE")}, {"EUR", LanguageTranslator.getString("REST_OF_EUROPE")}, {"WLD", LanguageTranslator.getString("REST_OF_THE_WORLD")}};
    private int cle;
    private String code;
    private String libelle;

    public boolean equals(Object object) {
        boolean toReturn = object instanceof Pays && ((Pays)object).getLibelle() != null && this.getLibelle() != null && ((Pays)object).getLibelle().equals(this.getLibelle());
        return toReturn;
    }

    public int hashCode() {
        int hash = (this.getLibelle() == null ? 0 : this.getLibelle().hashCode()) + "pays".hashCode();
        return hash;
    }

    public Pays(int cle, String abreviation, String libelle) {
        this.cle = cle;
        this.code = abreviation;
        this.libelle = libelle;
    }

    @Override
    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    @Override
    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    public static Vector<Pays> getVector() {
        Vector<Pays> tmp = new Vector<Pays>();
        int i = 0;
        while (i < LIBELLE.length) {
            tmp.add(new Pays(i, LIBELLE[i][0], LIBELLE[i][1]));
            ++i;
        }
        return tmp;
    }

    public static String getLibellePays(int libelle) {
        if (libelle > LIBELLE.length) {
            TimsLogger.warn("#Pays.getLibelle# unknown country " + libelle);
            return "ERROR";
        }
        return LIBELLE[libelle][1];
    }

    public static String getCodePays(int libelle) {
        if (libelle > LIBELLE.length) {
            return "ERROR";
        }
        return LIBELLE[libelle][0];
    }

    public static Pays getPays(int libelle) {
        return new Pays(libelle, Pays.getCodePays(libelle), Pays.getLibellePays(libelle));
    }

    public static Pays getPays(String libelle) {
        int x = 0;
        while (x < LIBELLE.length) {
            if (LIBELLE[x][1].equals(libelle)) {
                return new Pays(x, Pays.getCodePays(x), libelle);
            }
            ++x;
        }
        return new Pays(0, Pays.getCodePays(0), Pays.getLibellePays(0));
    }
}

