/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class PlaceAuthentication
extends MainElement {
    public static final String table = "PLACE_AUTHENTICATION";
    private int id = 0;
    private int driverId = 0;
    private Date timestamp = null;
    private int authenticationStatus = 0;

    public PlaceAuthentication(int id, int driverId, Date timestamp, int authenticationStatus) {
        this.id = id;
        this.driverId = driverId;
        this.timestamp = timestamp;
        this.authenticationStatus = authenticationStatus;
    }

    public int getId() {
        return this.id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public int getAuthenticationStatus() {
        return this.authenticationStatus;
    }

    public void setAuthenticationStatus(int authenticationStatus) {
        this.authenticationStatus = authenticationStatus;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#PlaceAuthentication.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO PLACE_AUTHENTICATION (" + PlaceAuthentication.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO PLACE_AUTHENTICATION (" + PlaceAuthentication.getAllFields().substring(PlaceAuthentication.getAllFields().indexOf(",")) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = PlaceAuthentication.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.timestamp.getTime()));
            this.statement.setObject(3, (Object)this.authenticationStatus, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM PLACE_AUTHENTICATION WHERE ID = ?";
        try {
            try {
                this.statement = PlaceAuthentication.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public String getSqlString() {
        SimpleDateFormat dateFormatBddHeure = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatBddHeure.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        return String.valueOf(this.getDriverId()) + "\t" + dateFormatBddHeure.format(this.getTimestamp()) + "\t" + this.getAuthenticationStatus();
    }

    private static String getAllFields() {
        return "ID, DRIVER_ID, AUTHENTICATION_TIME, AUTHENTICATION_STATUS";
    }

    public static Vector<PlaceAuthentication> loadList(int driverId, Date begin, Date end) {
        String sql = "";
        Vector<PlaceAuthentication> result = new Vector<PlaceAuthentication>();
        try {
            String res = "";
            if (driverId != 0) {
                res = String.valueOf(res) + " AND DRIVER_ID = ?";
            }
            if (begin != null) {
                res = end != null ? String.valueOf(res) + " AND AUTHENTICATION_TIME BETWEEN ? AND ?" : String.valueOf(res) + " AND AUTHENTICATION_TIME = ?";
            }
            sql = "SELECT " + PlaceAuthentication.getAllFields() + " FROM " + table;
            if (!res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY AUTHENTICATION_TIME";
            PreparedStatement stm = PlaceAuthentication.getConnection().prepareStatement(sql);
            int ind = 1;
            if (driverId != 0) {
                stm.setObject(ind, (Object)driverId, 4);
                ++ind;
            }
            if (begin != null) {
                stm.setTimestamp(ind, new Timestamp(begin.getTime()));
                ++ind;
            }
            if (end != null) {
                stm.setTimestamp(ind, new Timestamp(end.getTime()));
            }
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                result.add(new PlaceAuthentication(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getTimestamp("AUTHENTICATION_TIME"), rs.getInt("AUTHENTICATION_STATUS")));
            }
            TimsLogger.verbose("#PlaceAuthentication.loadList# sql = " + sql + " return " + result.size() + " results");
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#PlaceAuthentication.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }
}

