/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Rate
extends MainElement {
    public static final String table = "taux_base";
    private int cle = 0;
    private float t115M = 0.0f;
    private float t118M = 0.0f;
    private float t120M = 0.0f;
    private float t128M = 0.0f;
    private float t138M = 0.0f;
    private float t150M = 0.0f;
    private Date dateInsertion = null;
    private Date dateDebut = null;

    public Rate() {
        this.cle = 0;
        this.dateDebut = new Date();
        this.dateInsertion = new Date();
    }

    public Rate(int cle, float t115m, float t118m, float t120m, float t128m, float t138m, float t150m, Date dateInsertion, Date dateDebut) {
        this.cle = cle;
        this.t115M = t115m;
        this.t118M = t118m;
        this.t120M = t120m;
        this.t128M = t128m;
        this.t138M = t138m;
        this.t150M = t150m;
        this.dateInsertion = dateInsertion;
        this.dateDebut = dateDebut;
    }

    public Rate(int cle) {
        this.load(cle);
    }

    public boolean load(int cle) {
        ResultSet rs = null;
        String sql = "SELECT T115M, T118M, T120M, T128M, T138M, T150M, DATE_INSERTION, DATE_DEBUT  FROM taux_base WHERE CLE=?";
        try {
            this.statement = Rate.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)cle, 4);
            rs = this.statement.executeQuery();
            if (rs.next()) {
                this.cle = cle;
                this.t115M = rs.getFloat("T115M");
                this.t118M = rs.getFloat("T118M");
                this.t120M = rs.getFloat("T120M");
                this.t128M = rs.getFloat("T128M");
                this.t138M = rs.getFloat("T138M");
                this.t150M = rs.getFloat("T150M");
                this.dateInsertion = rs.getDate("DATE_INSERTION");
                this.dateDebut = rs.getDate("DATE_DEBUT");
                return true;
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("Rate.load()  : " + ex);
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public boolean loadCurrent() {
        ResultSet rs = null;
        boolean toReturn = false;
        String sql = "SELECT CLE, T115M, T118M, T120M, T128M, T138M, T150M, DATE_INSERTION, DATE_DEBUT FROM taux_base WHERE DATE_DEBUT < " + BddTransport.getCurrentDate() + " ORDER BY DATE_DEBUT";
        try {
            try {
                this.statement = Rate.getConnection().prepareStatement(sql);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.cle = rs.getInt("CLE");
                    this.t115M = rs.getFloat("T115M");
                    this.t118M = rs.getFloat("T118M");
                    this.t120M = rs.getFloat("T120M");
                    this.t128M = rs.getFloat("T128M");
                    this.t138M = rs.getFloat("T138M");
                    this.t150M = rs.getFloat("T150M");
                    this.dateInsertion = rs.getDate("DATE_INSERTION");
                    this.dateDebut = rs.getDate("DATE_DEBUT");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("Rate.load()  : " + ex);
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public void update() {
        if (this.cle == 0) {
            this.insert();
        } else {
            this.updateValue();
        }
    }

    public boolean insert() {
        try {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO taux_base(CLE, T115M, T118M, T120M, T128M, T138M, T150M, DATE_INSERTION, DATE_DEBUT) VALUES (GEN_T_JOUR_TYPE.nextval,?,?,?,?,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO taux_base(T115M, T118M, T120M, T128M, T138M, T150M, DATE_INSERTION, DATE_DEBUT) VALUES (?,?,?,?,?,?,?,?)";
            }
            this.statement = Rate.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)Float.valueOf(this.t115M), 6);
            this.statement.setObject(2, (Object)Float.valueOf(this.t118M), 6);
            this.statement.setObject(3, (Object)Float.valueOf(this.t120M), 6);
            this.statement.setObject(4, (Object)Float.valueOf(this.t128M), 6);
            this.statement.setObject(5, (Object)Float.valueOf(this.t138M), 6);
            this.statement.setObject(6, (Object)Float.valueOf(this.t150M), 6);
            this.statement.setDate(7, new java.sql.Date(this.dateInsertion.getTime()));
            this.statement.setDate(8, new java.sql.Date(this.dateDebut.getTime()));
            this.statement.executeUpdate();
            this.statement.close();
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateValue() {
        String sql = "UPDATE taux_base SET  T115M=?,  T118M=?,  T120M=?,  T128M=?,  T138M=?,  T150M=?,  DATE_DEBUT=? WHERE CLE=?";
        try {
            this.statement = Rate.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)Float.valueOf(this.t115M), 6);
            this.statement.setObject(2, (Object)Float.valueOf(this.t118M), 6);
            this.statement.setObject(3, (Object)Float.valueOf(this.t120M), 6);
            this.statement.setObject(4, (Object)Float.valueOf(this.t128M), 6);
            this.statement.setObject(5, (Object)Float.valueOf(this.t138M), 6);
            this.statement.setObject(6, (Object)Float.valueOf(this.t150M), 6);
            this.statement.setDate(7, new java.sql.Date(this.dateDebut.getTime()));
            this.statement.setObject(8, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        String sql = "DELETE FROM taux_base WHERE CLE =?";
        try {
            this.statement = Rate.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public Date getDateInsertion() {
        return this.dateInsertion;
    }

    public void setDateInsertion(Date dateInsertion) {
        this.dateInsertion = dateInsertion;
    }

    public float getT115M() {
        return this.t115M;
    }

    public void setT115M(float t115m) {
        this.t115M = t115m;
    }

    public float getT118M() {
        return this.t118M;
    }

    public void setT118M(float t118m) {
        this.t118M = t118m;
    }

    public float getT120M() {
        return this.t120M;
    }

    public void setT120M(float t120m) {
        this.t120M = t120m;
    }

    public float getT128M() {
        return this.t128M;
    }

    public void setT128M(float t128m) {
        this.t128M = t128m;
    }

    public float getT138M() {
        return this.t138M;
    }

    public void setT138M(float t138m) {
        this.t138M = t138m;
    }

    public float getT150M() {
        return this.t150M;
    }

    public void setT150M(float t150m) {
        this.t150M = t150m;
    }

    public static Vector<Rate> load() {
        Vector<Rate> toReturn = new Vector<Rate>();
        ResultSet rs = null;
        Statement stm = null;
        String sql = "SELECT CLE, T115M, T118M, T120M, T128M, T138M, T150M, DATE_INSERTION, DATE_DEBUT FROM taux_base ORDER BY DATE_DEBUT";
        try {
            try {
                stm = Rate.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new Rate(rs.getInt("CLE"), rs.getFloat("T115M"), rs.getFloat("T118M"), rs.getFloat("T120M"), rs.getFloat("T128M"), rs.getFloat("T138M"), rs.getFloat("T150M"), rs.getDate("DATE_INSERTION"), rs.getDate("DATE_DEBUT")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Rate.load()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

