/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Report
extends MainElement {
    public static String table = "REPORT";
    public static String RAPPORT_ACTIVITE = "ra";
    public static String RAPPORT_SERVICE = "rs";
    public static String RAPPORT_SSERVICE = "ss";
    public static String RAPPORT_AAC = "aac";
    public static String RAPPORT_SYNTHESE = "sa";
    public static String RAPPORT_NUIT = "rhn";
    public static String RAPPORT_JOUR = "rj";
    public static String RAPPORT_SM = "rsm";
    public static String RAPPORT_INFRACTION = "ri";
    public static String RAPPORT_SUPPRESSION = "rsup";
    public static String RAPPORT_COURRIER = "ci";
    public static String SYNTHESE_INFRACTION = "soffence";
    public static String RAPPORT_RC = "rc";
    public static String RAPPORT_FRAIS = "expenses";
    public static String SYNTHESE_FRAIS = "sexpense";
    public static String RAPPORT_SUIVI = "sh";
    public static String RAPPORT_UTILISATION_VEHICULE = "sv";
    public static String RAPPORT_MODIFICATION = "rm";
    public static String RAPPORT_PREPAIE = "pp";
    public static String RAPPORT_NON_ACT = "attestation";
    public static String RAPPORT_GLOBAL_ACTIVITE = "globalActivity";
    public static final int CONDUCTEUR = 1;
    public static final int VEHICULE = 2;
    private int id = 0;
    private String translationId = null;
    private String customizedName = null;
    private String fileName = null;
    private String classToLoad = "NONE";
    private int minimumVersion;
    private int module = -1;
    private int type = 1;

    public Report() {
    }

    public Report(int cle, String originalName, String customizedName, String fileName, String classToLoad, int minimumVersion, int module, int type) {
        this.id = cle;
        this.translationId = originalName;
        this.customizedName = customizedName;
        this.fileName = fileName;
        this.classToLoad = classToLoad;
        this.minimumVersion = minimumVersion;
        this.module = module;
        this.type = type;
    }

    public String getCustomizedName() {
        return this.customizedName;
    }

    public void setCustomizedName(String customizedName) {
        this.customizedName = customizedName;
    }

    public String getTranslationId() {
        return this.translationId;
    }

    public void setTranslationId(String originalName) {
        this.translationId = originalName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int cle) {
        this.id = cle;
    }

    public int getMinimumVersion() {
        return this.minimumVersion;
    }

    public void setMinimumVersion(int minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public int getModule() {
        return this.module;
    }

    public void setModule(int module) {
        this.module = module;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getClassToLoad() {
        return this.classToLoad;
    }

    public void setClassToLoad(String classToLoad) {
        this.classToLoad = classToLoad;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean loadByTranslationId(String translationId) {
        String sql = "SELECT " + this.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " WHERE TRANSLATION_ID='" + translationId + "'";
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean retour = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Report.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.translationId = rs.getString("TRANSLATION_ID");
                    this.customizedName = rs.getString("CUSTOMIZED_NAME");
                    this.fileName = rs.getString("FILE_NAME");
                    this.classToLoad = rs.getString("CLASS");
                    this.minimumVersion = rs.getInt("MINIMUM_VERSION");
                    this.module = rs.getInt("MODULE");
                    this.type = rs.getInt("TYPE");
                    this.id = rs.getInt("ID");
                    retour = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Report.load() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    private String getAllFields() {
        return "ID, TRANSLATION_ID, CUSTOMIZED_NAME, FILE_NAME, CLASS, MINIMUM_VERSION, MODULE, TYPE ";
    }

    public void update() {
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET TRANSLATION_ID=?," + " CUSTOMIZED_NAME=?," + " FILE_NAME=?," + " CLASS=?," + " MINIMUM_VERSION=?," + " MODULE=?," + " TYPE=?" + " WHERE ID=?";
        try {
            this.statement = Report.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.translationId, 12);
            this.statement.setObject(2, (Object)this.customizedName, 12);
            this.statement.setObject(3, (Object)this.fileName, 12);
            this.statement.setObject(4, (Object)this.classToLoad, 12);
            this.statement.setObject(5, (Object)this.minimumVersion, 4);
            this.statement.setObject(6, (Object)this.module, 4);
            this.statement.setObject(7, (Object)this.type, 4);
            this.statement.setObject(8, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void affiche() {
        TimsLogger.info("#Report.affiche# " + this.translationId + " " + this.customizedName + " " + this.fileName + " " + this.classToLoad + " " + this.minimumVersion);
    }

    public static Vector<Report> load() {
        Vector<Report> liste = new Vector<Report>();
        String sql = "SELECT ID, TRANSLATION_ID, CUSTOMIZED_NAME, FILE_NAME, CLASS, MINIMUM_VERSION, TYPE, MODULE FROM " + BddTransport.getBaseDefault(true) + table + " ORDER BY CUSTOMIZED_NAME";
        ResultSet rs = null;
        try {
            Statement stm = Report.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                liste.add(new Report(rs.getInt("ID"), rs.getString("TRANSLATION_ID"), rs.getString("CUSTOMIZED_NAME"), rs.getString("FILE_NAME"), rs.getString("CLASS"), rs.getInt("MINIMUM_VERSION"), rs.getInt("MODULE"), rs.getInt("TYPE")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("Report.loadReport()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }

    public static Vector<Report> loadAccessible(int cleProfil) {
        Vector<Report> liste = new Vector<Report>();
        String sql = "SELECT CLE, ID, TRANSLATION_ID, CUSTOMIZED_NAME, FILE_NAME, CLASS, MINIMUM_VERSION, MODULE, TYPE FROM " + BddTransport.getBaseDefault(true) + "DROIT_RAPPORT" + " DR" + " JOIN " + BddTransport.getBaseDefault(true) + table + " R ON DR.CLE_RAPPORT=R.ID" + " WHERE ENABLE = 1 AND CLE_PROFIL =" + cleProfil + " ORDER BY CUSTOMIZED_NAME";
        ResultSet rs = null;
        try {
            Statement stm = Report.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                int module = rs.getInt("MODULE");
                TimsLogger.debug("#Report.loadAccessible() => " + LicenceManager.getInstance().level + " " + LicenceManager.getInstance().module);
                if (rs.getInt("MINIMUM_VERSION") > LicenceManager.getInstance().level || module != -1 && !LicenceManager.isModuleEnable(module)) {
                    TimsLogger.debug("#Report.loadAccessible() => " + rs.getString("CUSTOMIZED_NAME") + " unavailable for this version (module =" + rs.getInt("MODULE") + ", version mini =" + rs.getInt("MINIMUM_VERSION") + ")");
                    continue;
                }
                TimsLogger.debug("#Report.loadAccessible() => " + rs.getString("CUSTOMIZED_NAME") + " available for this version (module =" + rs.getInt("MODULE") + ", version mini =" + rs.getInt("MINIMUM_VERSION") + ")");
                liste.add(new Report(rs.getInt("ID"), rs.getString("TRANSLATION_ID"), rs.getString("CUSTOMIZED_NAME"), rs.getString("FILE_NAME"), rs.getString("CLASS"), rs.getInt("MINIMUM_VERSION"), module, rs.getInt("TYPE")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("Report.loadReport()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }
}

