/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.MultiBoxItem;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class RoundType
extends MainElement
implements MultiBoxItem {
    public static final String table = "ROUND_TYPE";
    private static Vector<RoundType> list = null;
    private int id = 0;
    private String code = null;
    private String description = null;
    private int beginTime = 0;
    private int loadTime = 0;
    private int totalCutTime = 0;
    private int returnTime = 0;
    private int unloadTime = 0;
    private int totalTime = 0;
    private int maxServicePoint = 0;
    private int maxParcel = 0;
    private int avgDeliveryTime = 0;
    private int km = 0;
    private String beginPlace = null;
    private String endPlace = null;
    private boolean archived = false;

    public RoundType() {
    }

    public RoundType(int id, String code, String description, int beginTime, int loadTime, int totalCutTime, int returnTime, int unloadTime, int totalTime, int maxServicePoint, int maxParcel, int avgDeliveryTime, int km, boolean archived) {
        this.id = id;
        this.code = code;
        this.description = description;
        this.beginTime = beginTime;
        this.loadTime = loadTime;
        this.totalCutTime = totalCutTime;
        this.returnTime = returnTime;
        this.unloadTime = unloadTime;
        this.totalTime = totalTime;
        this.maxServicePoint = maxServicePoint;
        this.maxParcel = maxParcel;
        this.avgDeliveryTime = avgDeliveryTime;
        this.km = km;
        this.archived = archived;
    }

    public String toString() {
        return this.getCode();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(int beginTime) {
        this.beginTime = beginTime;
    }

    public int getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(int loadTime) {
        this.loadTime = loadTime;
    }

    public int getTotalCutTime() {
        return this.totalCutTime;
    }

    public void setTotalCutTime(int totalCutTime) {
        this.totalCutTime = totalCutTime;
    }

    public int getReturnTime() {
        return this.returnTime;
    }

    public void setReturnTime(int returnTime) {
        this.returnTime = returnTime;
    }

    public int getUnloadTime() {
        return this.unloadTime;
    }

    public void setUnloadTime(int unloadTime) {
        this.unloadTime = unloadTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(int totalTime) {
        this.totalTime = totalTime;
    }

    public int getMaxServicePoint() {
        return this.maxServicePoint;
    }

    public void setMaxServicePoint(int maxServicePoint) {
        this.maxServicePoint = maxServicePoint;
    }

    public int getMaxParcel() {
        return this.maxParcel;
    }

    public void setMaxParcel(int maxParcel) {
        this.maxParcel = maxParcel;
    }

    public int getAvgDeliveryTime() {
        return this.avgDeliveryTime;
    }

    public void setAvgDeliveryTime(int avgDeliveryTime) {
        this.avgDeliveryTime = avgDeliveryTime;
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    public String getBeginPlace() {
        return this.beginPlace;
    }

    public void setBeginPlace(String beginPlace) {
        this.beginPlace = beginPlace;
    }

    public String getEndPlace() {
        return this.endPlace;
    }

    public void setEndPlace(String endPlace) {
        this.endPlace = endPlace;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean loadById(int roundId) {
        String sql = "SELECT " + RoundType.getAllFields() + " FROM " + table + " WHERE ID=" + roundId;
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + RoundType.getAllFields() + " FROM " + table + " WHERE ROUND_CODE='" + code + "'";
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = RoundType.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.code = rs.getString("ROUND_CODE");
                    this.description = rs.getString("DESCRIPTION");
                    this.beginTime = rs.getInt("BEGIN_TIME");
                    this.loadTime = rs.getInt("LOAD_TIME");
                    this.totalCutTime = rs.getInt("TOTAL_CUT_TIME");
                    this.returnTime = rs.getInt("RETURN_TIME");
                    this.unloadTime = rs.getInt("UNLOAD_TIME");
                    this.totalTime = rs.getInt("TOTAL_TIME");
                    this.maxServicePoint = rs.getInt("MAX_SERVICE_POINT");
                    this.maxParcel = rs.getInt("MAX_PARCEL");
                    this.avgDeliveryTime = rs.getInt("AVG_DELIVERY_TIME");
                    this.km = rs.getInt("KM");
                    this.archived = rs.getBoolean("ARCHIVED");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#RoundType.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        boolean result = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO ROUND_TYPE (" + RoundType.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,0)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO ROUND_TYPE (" + RoundType.getAllFields().substring(RoundType.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,0)";
        }
        try {
            try {
                this.statement = RoundType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.code, 12);
                this.statement.setObject(2, (Object)this.description, 12);
                this.statement.setObject(3, (Object)this.beginTime, 4);
                this.statement.setObject(4, (Object)this.loadTime, 4);
                this.statement.setObject(5, (Object)this.totalCutTime, 4);
                this.statement.setObject(6, (Object)this.returnTime, 4);
                this.statement.setObject(7, (Object)this.unloadTime, 4);
                this.statement.setObject(8, (Object)this.totalTime, 4);
                this.statement.setObject(9, (Object)this.maxServicePoint, 4);
                this.statement.setObject(10, (Object)this.maxParcel, 4);
                this.statement.setObject(11, (Object)this.avgDeliveryTime, 4);
                this.statement.setObject(12, (Object)this.km, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public boolean updateValue() {
        boolean result = false;
        String sql = "UPDATE ROUND_TYPE SET ROUND_CODE=? ,DESCRIPTION=? ,MAX_SERVICE_POINT=? ,MAX_PARCEL=? ,BEGIN_TIME=? ,LOAD_TIME=? ,TOTAL_CUT_TIME=? ,RETURN_TIME=? ,UNLOAD_TIME=? ,TOTAL_TIME=? ,AVG_DELIVERY_TIME=? ,KM=?, ARCHIVED=? WHERE ID=?";
        try {
            try {
                this.statement = RoundType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.code, 12);
                this.statement.setObject(2, (Object)this.description, 12);
                this.statement.setObject(3, (Object)this.maxServicePoint, 4);
                this.statement.setObject(4, (Object)this.maxParcel, 4);
                this.statement.setObject(5, (Object)this.beginTime, 4);
                this.statement.setObject(6, (Object)this.loadTime, 4);
                this.statement.setObject(7, (Object)this.totalCutTime, 4);
                this.statement.setObject(8, (Object)this.returnTime, 4);
                this.statement.setObject(9, (Object)this.unloadTime, 4);
                this.statement.setObject(10, (Object)this.totalTime, 4);
                this.statement.setObject(11, (Object)this.avgDeliveryTime, 4);
                this.statement.setObject(12, (Object)this.km, 4);
                this.statement.setObject(13, (Object)(this.archived ? 1 : 0), 4);
                this.statement.setObject(14, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                result = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public boolean delete() {
        boolean result = false;
        String sql = "DELETE FROM t_tournee WHERE ID=?";
        try {
            try {
                this.statement = RoundType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                result = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public boolean compareAndUpdate(String code, String description, int beginTime, int loadTime, int totalCutTime, int returnTime, int unloadTime, int totalTime, int maxServicePoint, int maxParcel, int avgDeliveryTime, int km, boolean archived) {
        TimsLogger.debug("#RoundType.compareAndUpdate# " + this.toString());
        String tracer = String.valueOf(LanguageTranslator.getString("generics.round")) + " n\u00b0 " + this.id + " (" + this.getId() + ") \n";
        if (this.id == 0) {
            this.setCode(code);
            this.setDescription(description);
            this.setBeginTime(beginTime);
            this.setLoadTime(loadTime);
            this.setReturnTime(returnTime);
            this.setUnloadTime(unloadTime);
            this.setTotalTime(totalTime);
            this.setTotalCutTime(totalCutTime);
            this.setMaxServicePoint(maxServicePoint);
            this.setMaxParcel(maxParcel);
            this.setAvgDeliveryTime(avgDeliveryTime);
            this.setKm(km);
            this.setArchived(archived);
            tracer = String.valueOf(LanguageTranslator.getString("generics.round")) + "\n" + LanguageTranslator.getString("generics.code") + " => " + this.code;
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
            return this.insert();
        }
        if (Fonctions.fieldChange(code, this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (Fonctions.fieldChange(description, this.description)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.description") + " '" + this.description + "' => '" + description + "'\n";
            this.setDescription(description);
        }
        if (beginTime != this.beginTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.beginTime") + " '" + this.beginTime + "' => '" + beginTime + "'\n";
            this.setBeginTime(beginTime);
        }
        if (loadTime != this.loadTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.loadDuration") + " '" + this.loadTime + "' => '" + loadTime + "'\n";
            this.setLoadTime(loadTime);
        }
        if (totalCutTime != this.totalCutTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.totalCutTime") + " '" + this.totalCutTime + "' => '" + totalCutTime + "'\n";
            this.setTotalCutTime(totalCutTime);
        }
        if (returnTime != this.returnTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.returnTime") + " '" + this.returnTime + "' => '" + returnTime + "'\n";
            this.setReturnTime(returnTime);
        }
        if (unloadTime != this.unloadTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.unloadDuration") + " '" + this.unloadTime + "' => '" + unloadTime + "'\n";
            this.setUnloadTime(unloadTime);
        }
        if (totalTime != this.totalTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.totalTime") + " '" + this.totalTime + "' => '" + totalTime + "'\n";
            this.setTotalTime(totalTime);
        }
        if (maxServicePoint != this.maxServicePoint) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.maxServicePoint") + " '" + this.maxServicePoint + "' => '" + maxServicePoint + "'\n";
            this.setMaxServicePoint(maxServicePoint);
        }
        if (maxParcel != this.maxParcel) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.maxParcel") + " '" + this.maxParcel + "' => '" + maxParcel + "'\n";
            this.setMaxParcel(maxParcel);
        }
        if (avgDeliveryTime != this.avgDeliveryTime) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("round.avgDeliveryTime") + " '" + this.avgDeliveryTime + "' => '" + avgDeliveryTime + "'\n";
            this.setAvgDeliveryTime(avgDeliveryTime);
        }
        if (km != this.km) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.km") + " '" + this.km + "' => '" + km + "'\n";
            this.setKm(km);
        }
        if (archived != this.archived) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archived") + " '" + this.archived + "' => '" + archived + "'\n";
            this.setArchived(archived);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.round")) + " n\u00b0 " + this.id + " (" + this.getId() + ") \n")) {
            TimsLogger.debug("#RoundType.compareAndUpdate# changes : " + tracer);
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#RoundType# no changes");
        return true;
    }

    private static String getAllFields() {
        return "ID, ROUND_CODE, DESCRIPTION, BEGIN_TIME, LOAD_TIME, TOTAL_CUT_TIME, RETURN_TIME, UNLOAD_TIME, TOTAL_TIME, MAX_SERVICE_POINT, MAX_PARCEL, AVG_DELIVERY_TIME, KM, ARCHIVED";
    }

    public static Vector<RoundType> loadList(String filters) {
        Vector<RoundType> toReturn = new Vector<RoundType>();
        if (filters == null && list != null) {
            return list;
        }
        ResultSet rs = null;
        String sql = "SELECT " + RoundType.getAllFields() + " FROM " + table;
        if (filters != null && !filters.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + filters.substring(4);
        }
        try {
            Transport.ps.startOperation();
            Statement stm = RoundType.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate type de tourn\u00e9es", "#RoundType.loadList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                toReturn.add(new RoundType(rs.getInt("ID"), rs.getString("ROUND_CODE"), rs.getString("DESCRIPTION"), rs.getInt("BEGIN_TIME"), rs.getInt("LOAD_TIME"), rs.getInt("TOTAL_CUT_TIME"), rs.getInt("RETURN_TIME"), rs.getInt("UNLOAD_TIME"), rs.getInt("TOTAL_TIME"), rs.getInt("MAX_SERVICE_POINT"), rs.getInt("MAX_PARCEL"), rs.getInt("AVG_DELIVERY_TIME"), rs.getInt("KM"), rs.getBoolean("ARCHIVED")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("RoundType.loadList()  : " + ex);
            TimsLogger.debug(sql);
        }
        if (filters == null) {
            list = toReturn;
        }
        return toReturn;
    }

    public static Vector<RoundType> loadListById(Vector<Integer> roundTypeIdList) {
        String filters = "";
        for (int x : roundTypeIdList) {
            filters = String.valueOf(filters) + "," + x;
        }
        if (filters != "") {
            filters = " AND ID IN (" + filters.substring(1) + ")";
        }
        return RoundType.loadList(filters);
    }

    public static RoundType getRoundType(Vector<RoundType> roundTypes, int roundId) {
        if (roundTypes == null) {
            roundTypes = RoundType.getList();
        }
        for (RoundType rt : roundTypes) {
            if (rt.getId() != roundId) continue;
            return rt;
        }
        return null;
    }

    public static void setList(Vector<RoundType> list) {
        RoundType.list = list;
    }

    public static Vector<RoundType> getList() {
        if (list == null) {
            list = RoundType.loadList("AND ARCHIVED = 0");
        }
        return list;
    }
}

