/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import fr.pgh.data.bdd.Link;
import fr.pgh.data.bdd.MainElement;
import java.io.File;
import java.util.Date;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Pattern;
import transpo.system.TimsLogger;

public class Rule
extends MainElement {
    private int id = 0;
    private String name = null;
    private String fieldSeparator = null;
    private String lineSeparator = null;
    private Date creation = null;
    private Vector<Link> links = null;
    private Vector<String[]> value = null;
    private File toLoad = null;
    private String file = "";

    public Rule(String name, String fieldSeparator, String lineSeparator, Date creation, Vector<Link> links) {
        this.name = name;
        this.fieldSeparator = fieldSeparator;
        this.lineSeparator = lineSeparator;
        this.creation = creation;
        this.links = links;
    }

    public Date getCreation() {
        return this.creation;
    }

    public void setCreation(Date creation) {
        this.creation = creation;
    }

    public File getToLoad() {
        return this.toLoad;
    }

    public void setToLoad(File toLoad) {
        this.toLoad = toLoad;
        try {
            Scanner scanner = new Scanner(toLoad);
            while (scanner.hasNextLine()) {
                this.file = String.valueOf(this.file) + scanner.nextLine();
            }
            scanner.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Vector<Link> getLinks() {
        return this.links;
    }

    public void setLinks(Vector<Link> links) {
        this.links = links;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getPattern() {
        String toReturn = "";
        for (Link tmp : this.links) {
            toReturn = String.valueOf(toReturn) + this.getFieldSeparator() + tmp.getPattern();
        }
        toReturn = String.valueOf(toReturn) + this.getLineSeparator();
        return toReturn.substring(1);
    }

    public int checkPattern() {
        if (this.toLoad == null) {
            return 0;
        }
        try {
            TimsLogger.debug(String.valueOf(this.getPattern()) + "\r\n" + this.file);
            if (Pattern.matches("(" + this.getPattern() + ")*", this.file)) {
                return 1;
            }
            return 2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public Vector<String[]> getValue() {
        if (this.value == null) {
            this.value = new Vector();
            String[] lines = this.file.split(this.getLineSeparator());
            int x = 0;
            while (x < lines.length) {
                this.value.add(lines[x].split(this.getFieldSeparator()));
                ++x;
            }
            TimsLogger.debug("Line count " + this.value.size());
            for (String[] tmp : this.value) {
                TimsLogger.debug("Field count " + tmp.length);
                int x2 = 0;
                while (x2 < tmp.length) {
                    TimsLogger.debug(String.valueOf(x2) + " => " + tmp[x2]);
                    ++x2;
                }
            }
        }
        return this.value;
    }

    public static Vector<Rule> getRules() {
        Vector<Rule> toReturn = new Vector<Rule>();
        Vector<Link> link = new Vector<Link>();
        link.add(new Link(1, 1, "%s", "cle_activite", 4, true));
        link.add(new Link(2, 2, "%s", "date", 12, false));
        link.add(new Link(3, 3, "%s", "type_activite", 4, false));
        toReturn.add(new Rule("test : *,*,*;", ",", ";", null, link));
        Vector<Link> link2 = new Vector<Link>();
        link2.add(new Link(4, 1, "%s", "matricule_chauffeur", 4, true));
        link2.add(new Link(5, 2, "%s", "nom_conducteur", 12, false));
        link2.add(new Link(6, 3, "%s", "prenom_conducteur", 12, false));
        link2.add(new Link(7, 4, "%s", "date_entree", 91, false));
        toReturn.add(new Rule("test : *,*,*,*;", ",", ";", null, link2));
        Vector<Link> link3 = new Vector<Link>();
        link3.add(new Link(9, 1, "%s", "matricule_chauffeur", 12, true));
        link3.add(new Link(10, 2, "%s", "nom_conducteur", 12, false));
        link3.add(new Link(11, 3, "%s", "prenom_conducteur", 12, false));
        link3.add(new Link(12, 4, "%s", "date_entree", 12, false));
        link3.add(new Link(13, 5, "select cle_agence from t_agence where des_agence = %s", "CLE_AGENCE", 4, false));
        toReturn.add(new Rule("test : *;*RN", ";", "\\r\\n", null, link3));
        return toReturn;
    }
}

