/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class SavedComment
extends MainElement {
    private int cle = 0;
    private String designation = null;

    public SavedComment() {
        this.designation = "COMMENTAIRE";
    }

    public SavedComment(int cle, String designation) {
        this.cle = cle;
        this.designation = designation;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO T_COMMENT (CLE, DESIGNATION) VALUES (GEN_T_COMMENT.nextval,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO comment (DESIGNATION) VALUES (?)";
        }
        try {
            this.statement = SavedComment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.designation, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("comment", Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateValue() {
        String sql = "UPDATE " + (System.getProperty("SGBDR", "mysql").equals("oracle") ? "T_COMMENT" : "comment") + " SET " + " DESIGNATION =? ," + " WHERE CLE=?";
        try {
            this.statement = SavedComment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.designation, 12);
            this.statement.setObject(2, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("comment", Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean delete() {
        String sql = "DELETE FROM " + (System.getProperty("SGBDR", "mysql").equals("oracle") ? "T_COMMENT" : "comment") + " WHERE CLE=?";
        try {
            this.statement = SavedComment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("comment", Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getCle() {
        return this.cle;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public void affiche() {
        TimsLogger.info("#TypeContrat.affiche# " + this.designation);
    }

    public static Vector<SavedComment> loadList() {
        Vector<SavedComment> toReturn = new Vector<SavedComment>();
        ResultSet rs = null;
        String sql = "SELECT CLE, DESIGNATION FROM " + (System.getProperty("SGBDR", "mysql").equals("oracle") ? "T_COMMENT" : "comment");
        try {
            Transport.ps.startOperation();
            Statement stm = SavedComment.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate commentaire pr\u00e9d\u00e9fini", "#SavedComment.loadList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                toReturn.add(new SavedComment(rs.getInt("CLE"), rs.getString("DESIGNATION")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("Comment.loadList()  : " + ex);
            TimsLogger.debug(sql);
        }
        return toReturn;
    }
}

