/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class ScanPicture
extends MainElement {
    private int cle = 0;
    private int cleUser = 0;
    private String name = null;
    private String dateScan = null;
    private String dateProcession = null;
    private int number = 0;
    private String path = null;
    private int processed = 1;
    private boolean inserted;

    public ScanPicture() {
    }

    public ScanPicture(int cle, int cleUser, String name, String dateScan, String dateProcession, int number, String path, int processed, boolean inserted) {
        this.cle = cle;
        this.cleUser = cleUser;
        this.name = name;
        this.dateScan = dateScan;
        this.dateProcession = dateProcession;
        this.number = number;
        this.path = path;
        this.processed = processed;
        this.inserted = inserted;
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#ScanPicture.insert()#");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_scan_image (CLE, CLE_USER, NOM, DATE_SCAN, DATE_PROCESSION, NUMERO, PATH, PROCESSED) VALUES (GEN_T_SCAN_IMAGE.nextval,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_scan_image (CLE_USER, NOM, DATE_SCAN, DATE_PROCESSION, NUMERO, PATH, PROCESSED) VALUES (?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = ScanPicture.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleUser, 12);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setDate(3, Date.valueOf(this.dateScan));
                this.statement.setDate(4, Date.valueOf(this.dateProcession));
                this.statement.setObject(5, (Object)this.number, 4);
                this.statement.setObject(6, (Object)this.path, 12);
                this.statement.setObject(7, (Object)this.processed, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_scan_image", Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean update() throws Exception {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean updateValue() throws Exception {
        boolean retour = false;
        TimsLogger.debug("#ScanPicture.update()#");
        String sql = "UPDATE t_scan_image SET CLE_USER = ?, NUMERO = ?, DATE_SCAN = ?, DATE_PROCESSION = ?, NOM = ?, PATH = ?, PROCESSED = ? WHERE CLE = ?";
        try {
            try {
                this.statement = ScanPicture.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleUser, 4);
                this.statement.setObject(2, (Object)this.number, 4);
                this.statement.setDate(3, Date.valueOf(this.dateScan));
                this.statement.setDate(4, Date.valueOf(this.dateProcession));
                this.statement.setObject(5, (Object)this.name, 12);
                this.statement.setObject(6, (Object)this.path, 12);
                this.statement.setObject(7, (Object)this.processed, 4);
                this.statement.setObject(8, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_scan_image", Constants.ACTION_TYPE.UPDATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                throw ex;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean load(String name) {
        block4: {
            ResultSet rs = null;
            TimsLogger.debug("#ScanPicture.load()#");
            String sql = "SELECT CLE, CLE_USER, NOM, DATE_SCAN, DATE_PROCESSION, PATH, NUMERO, PROCESSED FROM t_scan_image WHERE NOM = ?";
            this.statement = ScanPicture.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)name, 12);
            rs = this.statement.executeQuery();
            if (!rs.next()) break block4;
            this.cle = rs.getInt("CLE");
            this.cleUser = rs.getInt("CLE_USER");
            this.name = rs.getString("NOM");
            this.dateScan = ScanPicture.getDateFromSGBD(rs.getString("DATE_SCAN"));
            this.dateProcession = ScanPicture.getDateFromSGBD(rs.getString("DATE_PROCESSION"));
            this.number = rs.getInt("NUMERO");
            this.path = rs.getString("PATH");
            this.processed = rs.getInt("PROCESSED");
            this.statement.close();
            return true;
        }
        try {
            this.statement.close();
            return false;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getDateScan() {
        return this.dateScan;
    }

    public void setDateScan(String dateScan) {
        this.dateScan = dateScan;
    }

    public String getDateProcession() {
        return this.dateProcession;
    }

    public void setDateProcession(String dateProcession) {
        this.dateProcession = dateProcession;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getProcessed() {
        return this.processed;
    }

    public void setProcessed(int processed) {
        this.processed = processed;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean inserted) {
        this.inserted = inserted;
    }

    public static Vector<ScanPicture> searchUnprocessed() {
        ResultSet rs = null;
        Vector<ScanPicture> result = new Vector<ScanPicture>();
        String sql = "SELECT CLE, CLE_USER, NUMERO, DATE_SCAN, DATE_PROCESSION, NOM, PATH, PROCESSED FROM t_scan_image WHERE PROCESSED = 0";
        try {
            Statement stm = ScanPicture.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new ScanPicture(rs.getInt("CLE"), rs.getInt("CLE_USER"), rs.getString("NOM"), rs.getString("DATE_SCAN"), rs.getString("DATE_PROCESSION"), rs.getInt("NUMERO"), rs.getString("PATH"), rs.getInt("PROCESSED"), true));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("ScanPicture.searchUnprocessed()  : " + ex);
            TimsLogger.debug(sql);
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

