/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class SpecificCondition
extends MainElement {
    public static final String table = "SPECIFIC_CONDITION";
    public static final int OUT_BEGIN = 1;
    public static final int OUT_END = 2;
    public static final int FERRY = 3;
    private int id = 0;
    private int driverId = 0;
    private Date specificTimestamp = null;
    private int type = 0;

    public SpecificCondition(int id, int driverId, Date specificTimestamp, int type) {
        this.id = id;
        this.driverId = driverId;
        this.specificTimestamp = specificTimestamp;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getSpecificTimestamp() {
        return this.specificTimestamp;
    }

    public void setSpecificTimestamp(Date specificTimestamp) {
        this.specificTimestamp = specificTimestamp;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#SpecificCondition.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO SPECIFIC_CONDITION (" + SpecificCondition.getAllFields() + ")" + " VALUES (GEN_SPECIFIC_CONDITION.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO SPECIFIC_CONDITION (" + SpecificCondition.getAllFields().substring(SpecificCondition.getAllFields().indexOf(",")) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = SpecificCondition.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.specificTimestamp.getTime()));
            this.statement.setObject(3, (Object)this.type, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM SPECIFIC_CONDITION WHERE ID = ?";
        try {
            try {
                this.statement = SpecificCondition.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public String getSqlString() {
        SimpleDateFormat dateFormatBddHeure = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatBddHeure.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        return String.valueOf(this.getDriverId()) + "\t" + dateFormatBddHeure.format(this.getSpecificTimestamp()) + "\t" + this.getType();
    }

    private static String getAllFields() {
        return "ID, DRIVER_ID, SPECIFIC_TIMESTAMP, SPECIFIC_TYPE";
    }

    public static Vector<SpecificCondition> loadList(int driverId, Date begin, Date end) {
        String sql = "";
        Vector<SpecificCondition> result = new Vector<SpecificCondition>();
        try {
            String res = "";
            if (driverId != 0) {
                res = String.valueOf(res) + " AND DRIVER_ID = ?";
            }
            if (begin != null) {
                res = end != null ? String.valueOf(res) + " AND SPECIFIC_TIMESTAMP BETWEEN ? AND ?" : String.valueOf(res) + " AND SPECIFIC_TIMESTAMP = ?";
            }
            sql = "SELECT " + SpecificCondition.getAllFields() + " FROM " + table;
            if (!res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY ID";
            PreparedStatement stm = SpecificCondition.getConnection().prepareStatement(sql);
            int ind = 1;
            if (driverId != 0) {
                stm.setObject(ind, (Object)driverId, 4);
                ++ind;
            }
            if (begin != null) {
                stm.setTimestamp(ind, new Timestamp(begin.getTime()));
                ++ind;
            }
            if (end != null) {
                stm.setTimestamp(ind, new Timestamp(end.getTime()));
            }
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                result.add(new SpecificCondition(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getTimestamp("SPECIFIC_TIMESTAMP"), rs.getInt("SPECIFIC_TYPE")));
            }
            TimsLogger.verbose("#SpecCond.loadList# sql = " + sql + " return " + result.size() + " results");
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#SpecificCondition.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static String getTypeLbl(int type) {
        switch (type) {
            case 1: {
                return LanguageTranslator.getString("specificCondition.outBegin");
            }
            case 2: {
                return LanguageTranslator.getString("specificCondition.outEnd");
            }
            case 3: {
                return LanguageTranslator.getString("specificCondition.ferry");
            }
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    public static String getImage(SpecificCondition tmp) {
        switch (tmp.getType()) {
            case 1: {
                return "images/-out.png";
            }
            case 2: {
                return "images/out-.png";
            }
            case 3: {
                return "images/ferry.png";
            }
        }
        return "images/unk.png";
    }
}

