/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.SuppliesTypeNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Supplies
extends MainElement {
    public static final String table = "SUPPLIES";
    private static Vector<Supplies> list = null;
    private int id = 0;
    private String name = null;
    private String code = null;
    private boolean archive = false;

    public Supplies() {
    }

    public Supplies(int id, String name, String code, boolean archive) {
        this.id = id;
        this.name = name;
        this.code = code;
        this.archive = archive;
    }

    public boolean equals(Object o) {
        return o instanceof Supplies && this.code.equals(((Supplies)o).getCode());
    }

    public String toString() {
        return this.getName();
    }

    private String getAllFields() {
        return "ID, NAME, CODE, ARCHIVED";
    }

    public boolean loadByName(String name) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(this.getAllFields()).append(" FROM ").append(table).append(" WHERE NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(name)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(this.getAllFields()).append(" FROM ").append(table).append(" WHERE CODE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(code)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int id) {
        String sql = "SELECT " + this.getAllFields() + " FROM " + table + " WHERE ID=" + id;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Supplies.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#Supplies.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Supplies.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                    this.archive = rs.getBoolean("ARCHIVED");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Supplies.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#Supplies.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO SUPPLIES (ID, NAME, CODE, ARCHIVED) VALUES (GEN_SUPPLIES.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO SUPPLIES (NAME, CODE, ARCHIVED) VALUES (?,?,?)";
        }
        try {
            this.statement = Supplies.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.archive, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE SUPPLIES SET  NAME=? , CODE=? , ARCHIVE=? , WHERE ID=?";
        try {
            this.statement = Supplies.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.archive, 4);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean compareAndUpdate(int id, String designation, String code, int kmExpiration, int periodExpiration, float cost, Vector<Supplies> supplies, boolean archive) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.supplies")) + " n\u00b0 " + id + " (" + this.name + ") \n";
        if (Fonctions.fieldChange(designation, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.name") + " '" + this.name + "' => '" + this.name + "'\n";
            this.setName(this.name);
        }
        if (Fonctions.fieldChange(code, code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (archive != this.archive) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archive") + " '" + this.archive + "' => '" + archive + "'\n";
            this.setArchive(archive);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.supplies")) + " n\u00b0 " + id + " (" + this.name + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM SUPPLIES WHERE ID=?";
        try {
            this.statement = Supplies.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public static Vector<Supplies> loadList(boolean archive) {
        Vector<Supplies> liste = new Vector<Supplies>();
        String sql = "SELECT ID, NAME, CODE, ARCHIVED FROM SUPPLIES WHERE ARCHIVED = " + (archive ? "1" : "0") + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = Supplies.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                Supplies tmp = new Supplies(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getBoolean("ARCHIVED"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Suuplies.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<Supplies> getList() {
        if (list == null) {
            list = Supplies.loadList(false);
        }
        return list;
    }

    public static void setList(Vector<Supplies> list) {
        Supplies.list = list;
    }

    public static Supplies getSupplies(int idSupplies) throws SuppliesTypeNotFoundException {
        for (Supplies tmp : Supplies.getList()) {
            if (tmp.getId() != idSupplies) continue;
            return tmp;
        }
        throw new SuppliesTypeNotFoundException();
    }
}

