/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;

public class Table
extends MainElement {
    private String tableName = null;
    private Vector<String> primaryKey = null;
    private Vector<String> foreignKeys = null;
    private Vector<String> champs = null;
    private boolean loaded = false;

    public Table() {
    }

    public Table(String tableName) {
        this.tableName = tableName;
    }

    public Table(String tableName, Vector<String> primaryKey, Vector<String> foreignKeys, Vector<String> champs) {
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.foreignKeys = foreignKeys;
        this.champs = champs;
    }

    public boolean load() {
        TimsLogger.debug("\n####################################################load " + this.tableName);
        if (this.loaded) {
            return true;
        }
        try {
            this.primaryKey = new Vector();
            this.foreignKeys = new Vector();
            this.champs = new Vector();
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "describe " + this.tableName;
            }
            System.getProperty("SGBDR", "mysql").equals("oracle");
            Statement stm = Table.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString("Key").equals("PRI")) {
                    this.primaryKey.add(rs.getString("Field"));
                    continue;
                }
                if (rs.getString("Key").equals("MUL")) {
                    this.foreignKeys.add(rs.getString("Field"));
                    continue;
                }
                this.champs.add(rs.getString("Field"));
            }
            TimsLogger.debug("\nPRI ");
            for (String tmp : this.primaryKey) {
                TimsLogger.debug(String.valueOf(tmp) + ";");
            }
            TimsLogger.debug("\nFOR ");
            for (String tmp : this.foreignKeys) {
                TimsLogger.debug(String.valueOf(tmp) + ";");
            }
            TimsLogger.debug("\nOTH ");
            for (String tmp : this.champs) {
                TimsLogger.debug(String.valueOf(tmp) + ";");
            }
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("Table.load()  : " + ex);
        }
        return false;
    }

    public static Vector<Table> getAllTables() {
        Vector<Table> result = new Vector<Table>();
        try {
            DatabaseMetaData dmd = Table.getConnection().getMetaData();
            Table.getConnection().setCatalog(BddTransport.getInstance().societeCourante.getNomBase());
            ResultSet tables = dmd.getTables(Table.getConnection().getCatalog(), null, "%", null);
            while (tables.next()) {
                result.add(new Table(tables.getString("TABLE_NAME")));
            }
            TimsLogger.debug(String.valueOf(result.size()) + " table trouv\u00e9es");
            for (Table tmp : result) {
                tmp.load();
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.debug("Table.getAllTables()  : " + ex);
        }
        return result;
    }
}

