/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class TaskParameter
extends MainElement {
    public static final String table = "TASK_PARAMETER";
    private int id = 0;
    private int taskActivationId = 0;
    private String name = null;
    private String value = null;

    public TaskParameter(int id, int taskActivationId, String name, String value) {
        this.id = id;
        this.taskActivationId = taskActivationId;
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskParameter && ((TaskParameter)obj).getTaskActivationId() == this.taskActivationId && ((TaskParameter)obj).getName() == this.name;
    }

    public int hashCode() {
        return this.name.hashCode() + Integer.valueOf(this.taskActivationId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTaskActivationId() {
        return this.taskActivationId;
    }

    public void setTaskActivationId(int taskActivationId) {
        this.taskActivationId = taskActivationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO TASK_PARAMETER (" + TaskParameter.getAllFields() + ")" + "(GEN_" + table + ".nextval,?,?,?)";
                } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(" + TaskParameter.getAllFields().substring(TaskParameter.getAllFields().indexOf(",") + 1) + ") VALUES " + "(?,?,?)";
                }
                statement = TaskParameter.getConnection().prepareStatement(sql);
                statement.setObject(1, this.taskActivationId, 4);
                statement.setObject(2, this.name, 12);
                statement.setObject(3, this.value, 12);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " TASK_ACTIVATION_ID=?, " + " NAME=?, " + " VALUE=? " + " WHERE ID=?";
        try {
            try {
                this.statement = TaskParameter.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.taskActivationId, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setObject(3, (Object)this.value, 12);
                this.statement.setObject(4, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = TaskParameter.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private static String getAllFields() {
        return "ID, TASK_ACTIVATION_ID, NAME, VALUE";
    }

    public static boolean update(int taskActivationId, String name, String newValue) {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " VALUE=? " + " WHERE TASK_ACTIVATION_ID=? AND NAME = ?";
        PreparedStatement stm = null;
        try {
            try {
                stm = TaskParameter.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)newValue, 12);
                stm.setInt(2, taskActivationId);
                stm.setObject(3, (Object)name, 12);
                if (stm.executeUpdate() == 1) {
                    retour = true;
                }
                stm.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public static ArrayList<TaskParameter> getList(int activationTaskId) {
        ArrayList<TaskParameter> toReturn = new ArrayList<TaskParameter>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (activationTaskId != -1) {
            sql = String.valueOf(sql) + " WHERE TASK_ACTIVATION_ID = " + activationTaskId;
        }
        TimsLogger.debug("#AutomaticTaskParameter.getList# activationTaskId : " + activationTaskId + " => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = TaskParameter.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new TaskParameter(rs.getInt("ID"), rs.getInt("TASK_ACTIVATION_ID"), rs.getString("NAME"), rs.getString("VALUE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

