/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Tracking
extends MainElement {
    public static final int ACTION_INSERT = 0;
    public static final int ACTION_DELETE = 1;
    public static final int ACTION_UPDATE = 2;
    private int id;
    private int userId;
    private String tableChanged;
    private int actionType;
    private Date date;
    private String content;

    public Tracking(int cle, int cleUser, String tableChanged, int actionType, Date date, String content) {
        this.id = cle;
        this.userId = cleUser;
        this.tableChanged = tableChanged;
        this.actionType = actionType;
        this.date = date;
        this.content = content;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void insert() {
        String sql = null;
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO tracking (ID, USER_ID, TABLE_CHANGED, ACTION_TYPE, ACTION_DATE, CONTENT)  VALUES (GEN_TRACKING.NEXTVAL,?,?,?,?,?)";
        } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO tracking (USER_ID, TABLE_CHANGED, ACTION_TYPE, ACTION_DATE, CONTENT)  VALUES (?,?,?,?,?)";
        }
        try {
            this.statement = Tracking.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.userId, 4);
            this.statement.setObject(2, (Object)this.tableChanged, 12);
            this.statement.setObject(3, (Object)this.actionType, 4);
            this.statement.setTimestamp(4, new Timestamp(this.date.getTime()));
            this.statement.setObject(5, (Object)this.content, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("tracking", Constants.ACTION_TYPE.CREATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<Tracking> loadTrace(int userId) {
        Vector<Tracking> liste = new Vector<Tracking>();
        String sql = "SELECT ID, USER_ID, TABLE_CHANGED, ACTION_TYPE, ACTION_DATE, CONTENT FROM tracking ORDER BY DATE, ACTION_TYPE";
        ResultSet rs = null;
        try {
            Statement stm = Tracking.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                liste.add(new Tracking(rs.getInt("ID"), rs.getInt("USER_ID"), rs.getString("TABLE_CHANGED"), rs.getInt("ACTION_TYPE"), rs.getDate("ACTION_DATE"), rs.getString("CONTENT")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("Tracking.loadTrace()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }
}

