/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Vehicule;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class UevOffence
extends MainElement {
    public static final int OFFSET = 58;
    public static final String table = "UEV_OFFENCE";
    public static final int CALIBRATION = 0;
    public static final int CARD = 1;
    public static final int SPEED = 2;
    public static final int SPEED_OVERVIEW = 3;
    public static String[] LIBELLE = new String[]{LanguageTranslator.getString("uev.offence.calibration"), LanguageTranslator.getString("uev.offence.card"), LanguageTranslator.getString("uev.offence.speed"), LanguageTranslator.getString("uev.offence.speedOverview")};
    private int id;
    private int vehicleId;
    private int driverId;
    private Date begin;
    private Date end;
    private int length = 0;
    private int threshold = 0;
    private int gravity = 0;
    private int offenceTypeId = 0;

    public UevOffence() {
    }

    public UevOffence(int vehicleId, int driverId, Date begin, Date end, int length, int threshold, int gravity, int offenceTypeId) {
        this.vehicleId = vehicleId;
        this.driverId = driverId;
        this.begin = begin;
        this.end = end;
        this.length = length;
        this.threshold = threshold;
        this.gravity = gravity;
        this.offenceTypeId = offenceTypeId;
    }

    public boolean equals(Object object) {
        return object instanceof UevOffence && ((UevOffence)object).getBegin().equals(this.begin) && ((UevOffence)object).getOffenceTypeId() == this.offenceTypeId && ((UevOffence)object).getVehicleId() == this.vehicleId;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * (hash + this.vehicleId + this.begin.hashCode());
        return hash;
    }

    public boolean load(int cle, Date day) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + UevOffence.getAllFields() + " FROM " + table + " WHERE VEHICLE_ID=? AND BEGIN = ?";
        try {
            try {
                this.statement = UevOffence.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)cle, 4);
                this.statement.setObject(2, (Object)day, 93);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.begin = rs.getTimestamp("BEGIN");
                    this.end = rs.getTimestamp("END");
                    this.length = rs.getInt("LENGTH");
                    this.gravity = rs.getInt("GRAVITY");
                    this.offenceTypeId = rs.getInt("OFFENCE_TYPE_ID");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#OffenceUev.load()# " + ex);
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        if (this.gravity == 127) {
            TimsLogger.debug("" + this.gravity);
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO UEV_OFFENCE (" + UevOffence.getAllFields() + ") " + "VALUES (GEN_" + table.toUpperCase() + ".nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO UEV_OFFENCE (" + UevOffence.getAllFields().substring(UevOffence.getAllFields().indexOf(",") + 1) + ") " + "VALUES (?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = UevOffence.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.vehicleId, 4);
                this.statement.setObject(2, (Object)this.driverId, 4);
                this.statement.setObject(3, (Object)this.offenceTypeId, 4);
                this.statement.setTimestamp(4, new Timestamp(this.begin.getTime()));
                this.statement.setTimestamp(5, this.end == null ? null : new Timestamp(this.end.getTime()));
                this.statement.setObject(6, (Object)this.threshold, 4);
                this.statement.setObject(7, (Object)this.gravity, 4);
                this.statement.setObject(8, (Object)this.length, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (SQLException e) {
                System.err.println("#OffenceUev.insert# erreur");
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean update() {
        String sql = "UPDATE UEV_OFFENCE SET  VEHICLE_ID=? , DRIVER_ID=? , OFFENCE_TYPE_ID=? , BEGIN=? , END=? , THRESHOLD=? , GRAVITY=? , LENGTH=?  WHERE ID=?";
        try {
            this.statement = UevOffence.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicleId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setObject(3, (Object)this.offenceTypeId, 4);
            this.statement.setTimestamp(4, new Timestamp(this.begin.getTime()));
            this.statement.setTimestamp(5, new Timestamp(this.end.getTime()));
            this.statement.setObject(6, (Object)this.threshold, 4);
            this.statement.setObject(7, (Object)this.gravity, 4);
            this.statement.setObject(8, (Object)this.length, 4);
            this.statement.setObject(9, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("loadId()#  sql = " + sql + " => " + ex.getMessage());
        }
        return false;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int cleVehicule) {
        this.vehicleId = cleVehicule;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public int getOffenceTypeId() {
        return this.offenceTypeId;
    }

    public void setOffenceTypeId(int offenceTypeId) {
        this.offenceTypeId = offenceTypeId;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int type) {
        this.gravity = type;
    }

    public String getSQLString() {
        return String.valueOf(this.vehicleId) + "\t" + this.driverId + "\t" + this.offenceTypeId + "\t" + ConversionTime.dateToString(this.begin, "yyyy-MM-dd HH:mm:ss") + "\t" + ConversionTime.dateToString(this.end, "yyyy-MM-dd HH:mm:ss") + "\t" + this.threshold + "\t" + this.length + "\t" + this.gravity;
    }

    private static String getAllFields() {
        return "ID, VEHICLE_ID, DRIVER_ID, OFFENCE_TYPE_ID, BEGIN, END, THRESHOLD, GRAVITY, LENGTH";
    }

    public static ArrayList<UevOffence> load(Vector<Agence> agencies, Vector<Vehicule> vehicles, String begin, String end) {
        String restriction = "";
        if (agencies != null && agencies.size() != 0) {
            String agencyFilter = UevOffence.buildAgencyFilters(agencies, "c.CLE_AGENCE");
            restriction = String.valueOf(restriction) + " AND VEHICLE_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ")" + " AND c.ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
        }
        if (vehicles != null && vehicles.size() != 0) {
            restriction = String.valueOf(restriction) + " AND " + UevOffence.buildVehicleFilters(vehicles, "VEHICLE_ID");
        }
        if (begin != null && !begin.equals("")) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND BEGIN >= " + BddTransport.getDateStringToSGBDR(begin, false) + " AND BEGIN <= " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(restriction) + " AND " + BddTransport.getDateTruncation("BEGIN") + " = " + BddTransport.getDateStringToSGBDR(begin, false);
        }
        if (!restriction.equals("")) {
            restriction = restriction.substring(5);
        }
        return UevOffence.loadList(restriction);
    }

    public static ArrayList<UevOffence> load(int vehicleId, Date begin, Date end) {
        return UevOffence.load(vehicleId, ConversionTime.dateToString(begin, "yyyy-MM-dd HH:mm:ss"), ConversionTime.dateToString(end, "yyyy-MM-dd HH:mm:ss"));
    }

    public static ArrayList<UevOffence> load(int vehicleId, String begin, String end) {
        String restriction = "";
        restriction = vehicleId != 0 ? String.valueOf(restriction) + " AND VEHICLE_ID = " + vehicleId : String.valueOf(restriction) + " AND VEHICLE_ID IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + ")";
        if (begin != null && !begin.equals("")) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND BEGIN >= " + BddTransport.getDateStringToSGBDR(begin, true) + " AND BEGIN <= " + BddTransport.getDateStringToSGBDR(end, true) : String.valueOf(restriction) + " AND " + BddTransport.getDateTruncation("BEGIN") + " = " + BddTransport.getDateStringToSGBDR(begin, true);
        }
        if (!restriction.equals("")) {
            restriction = restriction.substring(5);
        }
        return UevOffence.loadList(restriction);
    }

    public static ArrayList<UevOffence> loadByDriver(Vector<Agence> agencies, Vector<Conducteur> drivers, String begin, String end) {
        String restriction = "";
        if (agencies != null && agencies.size() != 0) {
            String agencyFilter = UevOffence.buildAgencyFilters(agencies, "c.CLE_AGENCE");
            restriction = String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ")" + " AND c.ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
        }
        if (drivers != null && drivers.size() != 0) {
            restriction = String.valueOf(restriction) + " AND " + UevOffence.buildDriverFilters(drivers, "DRIVER_ID");
        }
        if (begin != null && !begin.equals("")) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND BEGIN >= " + BddTransport.getDateStringToSGBDR(begin, false) + " AND BEGIN <= " + BddTransport.getDateStringToSGBDR(end, false) : String.valueOf(restriction) + " AND " + BddTransport.getDateTruncation("BEGIN") + " = " + BddTransport.getDateStringToSGBDR(begin, false);
        }
        if (!restriction.equals("")) {
            restriction = restriction.substring(5);
        }
        return UevOffence.loadList(restriction);
    }

    public static ArrayList<UevOffence> loadList(String filters) {
        ArrayList<UevOffence> liste = new ArrayList<UevOffence>();
        String sql = "SELECT " + UevOffence.getAllFields() + " FROM " + table + " WHERE LENGTH >= " + System.getProperty("uev.offence.minLength", "1") + (filters == null || filters.equals("") ? "" : " AND " + filters) + " ORDER BY BEGIN";
        TimsLogger.debug("UevOffence.loadList # " + sql);
        ResultSet rs = null;
        try {
            Transport.ps.startOperation();
            Statement stm = UevOffence.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate infraction uev", "#UevEventsFaults.load() => %s# sql = " + sql, 1);
            while (rs.next()) {
                UevOffence toAdd = new UevOffence(rs.getInt("VEHICLE_ID"), rs.getInt("DRIVER_ID"), rs.getTimestamp("BEGIN"), rs.getTimestamp("END"), rs.getInt("LENGTH"), rs.getInt("THRESHOLD"), rs.getInt("GRAVITY"), rs.getInt("OFFENCE_TYPE_ID"));
                toAdd.setId(rs.getInt("ID"));
                liste.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("UevOffence.loadList# Error in sql  : " + ex);
            ex.printStackTrace();
        }
        return liste;
    }
}

