/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.uev.object.VuCompanyLockData;
import transpo.system.util.Constants;

public class UevSession
extends MainElement {
    public static final int OFFSET = 116;
    public static final String table = "uev_session";
    private int id = 0;
    private int vehicleId = 0;
    private Date open = null;
    private Date close = null;
    private String company = null;
    private String companyCard = null;
    private String companyAddress = null;

    public UevSession() {
    }

    public UevSession(int id, int vehicleId, Date open, Date close, String company, String companyCard, String companyAddress) {
        this.id = id;
        this.vehicleId = vehicleId;
        this.open = open;
        this.close = close;
        this.company = company;
        this.companyCard = companyCard;
        this.companyAddress = companyAddress;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Date getOpen() {
        return this.open;
    }

    public void setOpen(Date open) {
        this.open = open;
    }

    public Date getClose() {
        return this.close;
    }

    public void setClose(Date close) {
        this.close = close;
    }

    public String getCompanyCard() {
        return this.companyCard;
    }

    public void setCompanyCard(String companyCard) {
        this.companyCard = companyCard;
    }

    public String getCompanyAddress() {
        return this.companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void affiche() {
        TimsLogger.debug("#UevSession.affiche# du " + this.open + " au " + this.close + " (" + this.companyCard + " => " + this.companyAddress + ")");
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#UevSession.insert()");
        this.affiche();
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO uev_session (ID, VEHICLE_ID, OPEN, CLOSE, COMPANY, COMPANY_CARD, COMPANY_ADDRESS) VALUES (GEN_UEV_SESSION.nextval,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO uev_session (VEHICLE_ID, OPEN, CLOSE, COMPANY, COMPANY_CARD, COMPANY_ADDRESS) VALUES (?,?,?,?,?,?)";
        }
        try {
            this.statement = UevSession.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicleId, 4);
            this.statement.setTimestamp(2, new Timestamp(this.open.getTime()));
            this.statement.setTimestamp(3, new Timestamp(this.close.getTime()));
            this.statement.setObject(4, (Object)this.company, 12);
            this.statement.setObject(5, (Object)this.companyCard, 12);
            this.statement.setObject(6, (Object)this.companyAddress, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "";
        TimsLogger.debug("#UevSession.update()");
        this.affiche();
        sql = "UPDATE uev_session SET  OPEN = ?, CLOSE = ? WHERE ID = " + this.id;
        try {
            this.statement = UevSession.getConnection().prepareStatement(sql);
            this.statement.setTimestamp(1, new Timestamp(this.open.getTime()));
            this.statement.setTimestamp(2, new Timestamp(this.close.getTime()));
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UevSession getLastUevSession(int vehicleId) {
        UevSession toReturn = null;
        String sql = "";
        try {
            if (vehicleId == 0) {
                TimsLogger.error("Vehicle cannot be null for getLastUevSession");
                return null;
            }
            sql = "SELECT ID, VEHICLE_ID, " + BddTransport.getDateSGBDRToString("OPEN", true, "") + "," + BddTransport.getDateSGBDRToString("CLOSE", true, "") + "," + " COMPANY, COMPANY_CARD, COMPANY_ADDRESS" + " FROM " + table + " WHERE VEHICLE_ID = " + vehicleId + " AND OPEN = (SELECT max(open) from " + table + " where vehicle_id =" + vehicleId + ")";
            Statement stm = UevSession.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (true) {
                if (!rs.next()) {
                    rs.close();
                    stm.close();
                    return toReturn;
                }
                if (rs.getTimestamp("OPEN") == null) {
                    return null;
                }
                toReturn = new UevSession(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("OPEN"), rs.getTimestamp("CLOSE"), rs.getString("COMPANY"), rs.getString("COMPANY_CARD"), rs.getString("COMPANY_ADDRESS"));
            }
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
            return toReturn;
        }
        catch (Exception ex) {
            TimsLogger.warn("UevSession.getLastUevSession(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return toReturn;
    }

    public static Vector<UevSession> getUevSession(int vehicleId, String open, String close) {
        Vector<UevSession> result = new Vector<UevSession>();
        String sql = "";
        try {
            sql = "SELECT ID, VEHICLE_ID, " + BddTransport.getDateSGBDRToString("OPEN", true, "") + "," + BddTransport.getDateSGBDRToString("CLOSE", true, "") + "," + " COMPANY, COMPANY_CARD, COMPANY_ADDRESS" + " FROM " + table;
            String restriction = "";
            if (vehicleId != 0) {
                restriction = String.valueOf(restriction) + " AND VEHICLE_ID = " + vehicleId;
            }
            if (open != null && !open.equals("")) {
                restriction = String.valueOf(restriction) + " AND OPEN >= " + BddTransport.getDateStringToSGBDR(open, false);
            }
            if (close != null && !close.equals("")) {
                restriction = String.valueOf(restriction) + " AND CLOSE <= " + BddTransport.getDateStringToSGBDR(close, false);
            }
            if (!restriction.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY VEHICLE_ID, OPEN";
            Statement stm = UevSession.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                result.add(new UevSession(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("OPEN"), rs.getTimestamp("CLOSE"), rs.getString("COMPANY"), rs.getString("COMPANY_CARD"), rs.getString("COMPANY_ADDRESS")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("UevSession.getUevSession(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static UevSession createFromVuCompanyLock(VuCompanyLockData session, int vehicleId) {
        return new UevSession(0, vehicleId, session.getBegin(), session.getEnd(), session.getName(), session.getCard().getCardNumber().getCardNumber(), session.getAddress());
    }
}

