/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.UserMessage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class UserMessageActivation
extends MainElement {
    public static final String table = "USER_MESSAGE_ACTIVATION";
    int id = 0;
    int messageId = 0;
    int userId = 0;
    boolean validated = false;
    Date validationDate = null;

    public UserMessageActivation() {
    }

    public UserMessageActivation(int id, int messageId, int userId, boolean validated, Date validationDate) {
        this.id = id;
        this.messageId = messageId;
        this.userId = userId;
        this.validated = validated;
        this.validationDate = validationDate;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (" + UserMessageActivation.getAllFields() + ")" + " VALUES (GEN_USER_MESSAGE.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (" + UserMessageActivation.getAllFields().substring(UserMessageActivation.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = UserMessageActivation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.userId, 4);
            this.statement.setObject(2, (Object)this.messageId, 4);
            this.statement.setObject(3, (Object)(this.validated ? 1 : 0), 4);
            this.statement.setTimestamp(4, new Timestamp(this.validationDate.getTime()));
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET" + " MESSAGE_ID=? ," + " USER_ID=? ," + " VALIDATED=? ," + " VALIDATION_DATE=?" + " WHERE ID=?";
        try {
            this.statement = UserMessageActivation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.messageId, 4);
            this.statement.setObject(2, (Object)this.userId, 4);
            this.statement.setObject(3, (Object)(this.validated ? 1 : 0), 4);
            this.statement.setTimestamp(4, new Timestamp(this.validationDate.getTime()));
            this.statement.setObject(5, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = UserMessageActivation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean load(int id) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + UserMessageActivation.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID=?";
        try {
            try {
                this.statement = UserMessageActivation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)id, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = id;
                    this.messageId = rs.getInt("MESSAGE");
                    this.userId = rs.getInt("USER_ID");
                    this.validated = rs.getInt("VALIDATION") == 1;
                    this.validationDate = rs.getTimestamp("VALIDATION_DATE");
                } else {
                    TimsLogger.info("#UserMessage.load# no data for region n\u00b0" + id);
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                block24: {
                    TimsLogger.debug("#UserMessage.load(String id)# : " + ex);
                    if (Transport.debug < 2) break block24;
                    ex.printStackTrace();
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public static Vector<UserMessageActivation> loadList(int messageId) {
        Vector<UserMessageActivation> toReturn = new Vector<UserMessageActivation>();
        ResultSet rs = null;
        Statement stm = null;
        String sql = "SELECT " + UserMessageActivation.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " WHERE VALIDATED=0 ";
        sql = messageId != 0 ? String.valueOf(sql) + "AND MESSAGE_ID = " + messageId : String.valueOf(sql) + "AND USER_ID = " + Transport.conn.getUserCle();
        try {
            try {
                stm = UserMessageActivation.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new UserMessageActivation(rs.getInt("ID"), rs.getInt("MESSAGE_ID"), rs.getInt("USER_ID"), rs.getInt("VALIDATED") == 1, rs.getDate("VALIDATION_DATE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("UserMessageActivation.loadList()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static boolean addActivation(UserMessage currentMessage) {
        boolean toReturn = true;
        PreparedStatement stm = null;
        String sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (MESSAGE_ID , USER_ID)" + " select " + currentMessage.getId() + ", cle_utilisateur from " + BddTransport.getBaseDefault(true) + "t_utilisateur";
        TimsLogger.debug(sql);
        try {
            try {
                stm = UserMessageActivation.getConnection().prepareStatement(sql);
                stm.executeUpdate();
                stm.close();
                TimsLogger.debug(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                toReturn = false;
                TimsLogger.warn("UserMessageActivation.addActivation()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    private static String getAllFields() {
        return "ID, MESSAGE_ID, USER_ID, VALIDATED, VALIDATION_DATE";
    }
}

