/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.CompanyWarningActivation;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class UserWidget
extends MainElement {
    public static final String table = "USER_WIDGET";
    private int id = 0;
    private int widgetId = 0;
    private int userId = 0;
    private int position = 0;

    public UserWidget(int id, int widgetId, int userId, int position) {
        this.id = id;
        this.widgetId = widgetId;
        this.userId = userId;
        this.position = position;
    }

    public boolean equals(Object obj) {
        return obj instanceof UserWidget && ((UserWidget)obj).getWidgetId() == this.widgetId && ((CompanyWarningActivation)obj).getCompanyId() == this.userId;
    }

    public int hashCode() {
        return Integer.valueOf(this.userId + this.widgetId + this.userId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getWidgetId() {
        return this.widgetId;
    }

    public void setWidgetId(int widgetId) {
        this.widgetId = widgetId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int companyId) {
        this.userId = companyId;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO USER_WIDGET(ID, WIDGET_ID, USER_ID, POSITION) VALUES (GEN_USER_WIDGET.nextval,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(WIDGET_ID, USER_ID, POSITION) VALUES " + "(?,?,?)";
            }
            if (sql == null) {
                TimsLogger.warn("#UserWidget.insert# unknown database " + System.getProperty("SGBDR", "mysql"));
                return false;
            }
            try {
                statement = UserWidget.getConnection().prepareStatement(sql);
                statement.setObject(1, this.widgetId, 4);
                statement.setObject(2, this.userId, 4);
                statement.setObject(3, this.position, 4);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " WIDGET_ID=?, " + " USER_ID=?, " + " POSITION=? " + " WHERE ID=?";
        try {
            try {
                this.statement = UserWidget.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.widgetId, 4);
                this.statement.setObject(2, (Object)this.userId, 4);
                this.statement.setObject(3, (Object)this.position, 4);
                this.statement.setObject(4, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = UserWidget.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean multipleDelete(int userId, Vector<Integer> toDelete) {
        boolean toReturn = false;
        String where = "";
        if (userId != 0) {
            where = String.valueOf(where) + " AND USER_ID = " + userId;
        }
        if (toDelete != null) {
            where = String.valueOf(where) + " AND ID_WARNING IN (";
            String list = "";
            for (Integer iter : toDelete) {
                list = String.valueOf(list) + "," + iter;
            }
            where = String.valueOf(where) + list.substring(1) + ")";
        }
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table;
        if (!where.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + where.substring(5);
        }
        Statement stm = null;
        try {
            try {
                stm = UserWidget.getConnection().createStatement();
                stm.executeUpdate(sql);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                TimsLogger.warn("#UW.multipleDelete# sql error (" + sql + ")");
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static ArrayList<UserWidget> getList(int userId) {
        ArrayList<UserWidget> toReturn = new ArrayList<UserWidget>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (userId != -1) {
            sql = String.valueOf(sql) + " WHERE USER_ID = " + userId;
        }
        TimsLogger.info("#UWA.getList# soci\u00e9t\u00e9 : " + userId + " => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = UserWidget.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new UserWidget(rs.getInt("ID"), rs.getInt("WIDGET_ID"), rs.getInt("USER_ID"), rs.getInt("POSITION")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

