/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class VehicleComment
extends MainElement {
    public static final String table = "DAILY_VEHICLE_COMMENT";
    public static final int OFFSET = 117;
    private int id = 0;
    private int vehicleId = 0;
    private Date date = null;
    private String comment = null;
    private boolean mailed = false;

    public VehicleComment() {
    }

    public VehicleComment(int cle, int vehicleId, Date date, String designation, boolean mailed) {
        this.id = cle;
        this.vehicleId = vehicleId;
        this.date = date;
        this.comment = designation;
        this.mailed = mailed;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#VehicleComment.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO DAILY_VEHICLE_COMMENT (ID, VEHICLE_ID, DAY, COMM) VALUES (GEN_DAILY_VEHICLE_COMMENT.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO DAILY_VEHICLE_COMMENT (VEHICLE_ID, DAY, COMM) VALUES (?,?,?)";
        }
        try {
            this.statement = VehicleComment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicleId, 4);
            this.statement.setDate(2, new java.sql.Date(this.date.getTime()));
            this.statement.setObject(3, (Object)this.comment, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), this.affiche()).insert();
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateValue() {
        String sql = "UPDATE DAILY_VEHICLE_COMMENT SET  VEHICLE_ID=? , DAY=? , COMM=? WHERE ID = ?";
        try {
            this.statement = VehicleComment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicleId, 4);
            this.statement.setDate(2, new java.sql.Date(this.date.getTime()));
            this.statement.setObject(3, (Object)this.comment, 12);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean delete() {
        String sql = "DELETE FROM DAILY_VEHICLE_COMMENT WHERE ID=?";
        try {
            this.statement = VehicleComment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String designation) {
        this.comment = designation;
    }

    public String affiche() {
        String toReturn = "d\u00e9tail commentaire\r\n";
        toReturn = String.valueOf(toReturn) + "id v\u00e9hicule : " + this.vehicleId + "\r\n";
        toReturn = String.valueOf(toReturn) + "date : " + this.date + "\r\n";
        toReturn = String.valueOf(toReturn) + "designation : " + this.comment + "\r\n";
        return toReturn;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isMailed() {
        return this.mailed;
    }

    public void setMailed(boolean mailed) {
        this.mailed = mailed;
    }

    public static Vector<VehicleComment> loadList(int agencyId, int vehicleId, Date begin, Date end) {
        Vector<VehicleComment> toReturn = new Vector<VehicleComment>();
        String sql = "";
        String res = "";
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DAY BETWEEN ? AND ?" : String.valueOf(res) + " AND DAY = ?";
        }
        if (agencyId != 0 && vehicleId == 0) {
            res = String.valueOf(res) + " AND VEHICLE_ID IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE CLE_AGENCE = ?)";
        }
        if (vehicleId != 0) {
            res = String.valueOf(res) + " AND VEHICLE_ID = ?";
        }
        try {
            sql = "SELECT ID, VEHICLE_ID, DAY, COMM  FROM DAILY_VEHICLE_COMMENT";
            if (res != null && !res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY VEHICLE_ID, DAY";
            PreparedStatement stm = VehicleComment.getConnection().prepareStatement(sql);
            int x = 1;
            if (begin != null) {
                stm.setDate(x, new java.sql.Date(begin.getTime()));
                ++x;
            }
            if (end != null) {
                stm.setDate(x, new java.sql.Date(end.getTime()));
                ++x;
            }
            if (agencyId != 0) {
                stm.setObject(x, (Object)agencyId, 4);
                ++x;
            }
            if (vehicleId != 0) {
                stm.setObject(x, (Object)vehicleId, 4);
                ++x;
            }
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                toReturn.add(new VehicleComment(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getDate("DAY"), rs.getString("COMM"), false));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("VehicleComment.loadList() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return toReturn;
    }
}

