/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Vehicule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.uev.object.VuCardRecord;
import transpo.system.util.Constants;

public class VehicleUsed
extends MainElement {
    public static final String driver_table = "driver_vehicle_used";
    public static final String vehicle_table = "vehicle_used";
    public static final int OFFSET = 52;
    public static int LECTEUR_AUCUN = 2;
    public static int LECTEUR_CONVOYEUR = 1;
    public static int LECTEUR_CONDUCTEUR = 0;
    public static int SOURCE_CARD = 0;
    public static int SOURCE_UEV = 1;
    public static int SOURCE_IMPORT = 3;
    public static int CARTE = 0;
    public static int SCAN = 2;
    private int cle = 0;
    private int cleConducteur = 0;
    private int cleVehicule = 0;
    private Date dateDebut = null;
    private Date dateFin = null;
    private int kmDebut = 0;
    private int kmFin = 0;
    private int kmEffectue = 0;
    private int source = SOURCE_CARD;
    private String nom = null;
    private String prenom = null;
    private String numeroCarte = null;
    private String immatriculation = null;
    private int lecteur = LECTEUR_AUCUN;
    private boolean manualInput = false;

    public VehicleUsed() {
    }

    public VehicleUsed(int cleConducteur, String nom, String prenom, String numeroCarte, Date dateDebut, Date dateFin) {
        this.cleConducteur = cleConducteur;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.nom = nom;
        this.prenom = prenom;
        this.numeroCarte = numeroCarte;
    }

    public VehicleUsed(int cle, int cleConducteur, int cleVehicule, Date dateDebut, Date dateFin, int kmDebut, int kmFin, int kmEffectue, boolean manualInput, int lecteur, String nom, String prenom, String numeroCarte, String immatriculation, int source) {
        this.cle = cle;
        this.cleConducteur = cleConducteur;
        this.cleVehicule = cleVehicule;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.kmDebut = kmDebut;
        this.kmFin = kmFin == 0xFFFFFF ? -1 : kmFin;
        this.kmEffectue = kmEffectue;
        this.manualInput = manualInput;
        this.lecteur = lecteur;
        this.nom = nom;
        this.prenom = prenom;
        this.numeroCarte = numeroCarte;
        this.immatriculation = immatriculation;
        this.source = source;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VehicleUsed)) {
            return false;
        }
        return ((VehicleUsed)obj).getNumeroCarte().equals(this.getNumeroCarte()) && ((VehicleUsed)obj).getDateDebut().equals(this.getDateDebut()) && ((VehicleUsed)obj).getImmatriculation().equals(this.getImmatriculation()) && ((VehicleUsed)obj).getKmDebut() == this.getKmDebut();
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                Transport.ps.startOperation();
                statement = VehicleUsed.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.cle = rs.getInt("CLE");
                    toReturn = true;
                }
                Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate VehicleUsed", "#VehicleUsed.load() => %s# sql = " + sql, 3);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#VehicleUsed.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update(String tableToInsert) {
        if (this.cle == 0) {
            return this.insert(tableToInsert);
        }
        return this.updateValue(tableToInsert);
    }

    public boolean insert(String tableToInsert) {
        boolean toReturn = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + tableToInsert + " (CLE, CLE_CHAUFFEUR, CLE_VEHICULE,DATE_DEBUT, DATE_FIN, KM_DEBUT, KM_FIN, KM_EFFECTUE," + " MANUAL_INPUT, LECTEUR, NOM, PRENOM, NUMERO_CARTE, IMMATRICULATION, SOURCE)" + " VALUES (GEN_" + tableToInsert + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + tableToInsert + " (CLE_CHAUFFEUR, CLE_VEHICULE, DATE_DEBUT, DATE_FIN, KM_DEBUT, KM_FIN, KM_EFFECTUE," + " MANUAL_INPUT, LECTEUR, NOM, PRENOM, NUMERO_CARTE, IMMATRICULATION, SOURCE)" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = VehicleUsed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.setObject(2, (Object)this.cleVehicule, 4);
                this.statement.setTimestamp(3, new Timestamp(this.dateDebut.getTime()));
                this.statement.setTimestamp(4, new Timestamp(this.dateFin.getTime()));
                this.statement.setObject(5, (Object)this.kmDebut, 4);
                this.statement.setObject(6, (Object)this.kmFin, 4);
                this.statement.setObject(7, (Object)(this.kmFin == -1 ? -1 : this.kmFin - this.kmDebut), 4);
                this.statement.setObject(8, (Object)this.manualInput, 4);
                this.statement.setObject(9, (Object)this.lecteur, 4);
                this.statement.setObject(10, (Object)this.nom, 12);
                this.statement.setObject(11, (Object)this.prenom, 12);
                this.statement.setObject(12, (Object)this.numeroCarte, 12);
                this.statement.setObject(13, (Object)this.immatriculation, 12);
                this.statement.setObject(14, (Object)this.source, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(tableToInsert, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean updateValue(String tableToUpdate) {
        boolean toReturn = false;
        if (this.cle == 0) {
            TimsLogger.warn("#VehicleUsed.update()#Error# clePrise to update == 0");
        }
        String sql = "UPDATE " + tableToUpdate + " SET " + " CLE_CHAUFFEUR=? ," + " CLE_VEHICULE=? ," + " DATE_DEBUT=? ," + " DATE_FIN=? ," + " KM_DEBUT=? ," + " KM_FIN=? ," + " KM_EFFECTUE= ? ," + " MANUAL_INPUT= ? ," + " LECTEUR= ? ," + " NOM= ? ," + " PRENOM= ? ," + " NUMERO_CARTE= ? ," + " IMMATRICULATION= ? ," + " SOURCE= ? " + " WHERE CLE=?";
        try {
            try {
                this.statement = VehicleUsed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleConducteur, 4);
                this.statement.setObject(2, (Object)this.cleVehicule, 4);
                this.statement.setTimestamp(3, new Timestamp(this.dateDebut.getTime()));
                this.statement.setTimestamp(4, new Timestamp(this.dateFin.getTime()));
                this.statement.setObject(5, (Object)this.kmDebut, 4);
                this.statement.setObject(6, (Object)this.kmFin, 4);
                this.statement.setObject(7, (Object)(this.kmFin - this.kmDebut), 4);
                this.statement.setObject(8, (Object)this.manualInput, 4);
                this.statement.setObject(9, (Object)this.lecteur, 4);
                this.statement.setObject(10, (Object)this.nom, 12);
                this.statement.setObject(11, (Object)this.prenom, 12);
                this.statement.setObject(12, (Object)this.numeroCarte, 12);
                this.statement.setObject(13, (Object)this.immatriculation, 12);
                this.statement.setObject(14, (Object)this.source, 4);
                this.statement.setObject(15, (Object)this.cle, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(tableToUpdate, Constants.ACTION_TYPE.UPDATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean delete(String tableToDelete) {
        boolean toReturn = false;
        String sql = "DELETE FROM " + tableToDelete + " WHERE CLE=?";
        try {
            try {
                this.statement = VehicleUsed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(tableToDelete, Constants.ACTION_TYPE.DELETE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public void print() {
        TimsLogger.debug("#VehicleUsed.print() #" + this.cleVehicule + " (" + this.immatriculation + ") " + this.dateDebut + " => " + this.dateFin + " : " + this.kmDebut + " " + this.kmFin);
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public int getCleVehicule() {
        return this.cleVehicule;
    }

    public void setCleVehicule(int cleVehicule) {
        this.cleVehicule = cleVehicule;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public String getImmatriculation() {
        return this.immatriculation;
    }

    public void setImmatriculation(String immatriculation) {
        this.immatriculation = immatriculation;
    }

    public int getKmDebut() {
        return this.kmDebut;
    }

    public void setKmDebut(int kmDebut) {
        this.kmDebut = kmDebut;
    }

    public int getKmEffectue() {
        return this.kmEffectue;
    }

    public void setKmEffectue(int kmEffectue) {
        this.kmEffectue = kmEffectue;
    }

    public int getKmFin() {
        return this.kmFin;
    }

    public void setKmFin(int kmFin) {
        this.kmFin = kmFin == 0xFFFFFF ? -1 : kmFin;
    }

    public int getLecteur() {
        return this.lecteur;
    }

    public void setLecteur(int lecteur) {
        this.lecteur = lecteur;
    }

    public boolean isManualInput() {
        return this.manualInput;
    }

    public void setManualInput(boolean manualInput) {
        this.manualInput = manualInput;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getNumeroCarte() {
        return this.numeroCarte;
    }

    public void setNumeroCarte(String numeroCarte) {
        this.numeroCarte = numeroCarte;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = "" + this.dateDebut.getTime() + this.dateFin.getTime();
            activite = String.valueOf(activite) + Integer.toBinaryString(this.kmDebut + (int)Math.pow(2.0, 21.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.kmFin + (int)Math.pow(2.0, 21.0)).substring(1);
            activite = String.valueOf(activite) + this.source;
            activite = String.valueOf(activite) + (this.manualInput ? "1" : "0");
            activite = String.valueOf(activite) + this.lecteur;
            while (activite.length() < 96) {
                activite = String.valueOf(activite) + "0";
            }
            int x = 0;
            while (x < 12) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            tmp.write((byte)this.nom.length());
            tmp.write(this.nom.getBytes());
            tmp.write((byte)this.prenom.length());
            tmp.write(this.prenom.getBytes());
            tmp.write((byte)this.numeroCarte.length());
            tmp.write(this.numeroCarte.getBytes());
            out.write(52);
            out.write((byte)(tmp.toByteArray().length / 255 + 1));
            out.write((byte)tmp.toByteArray().length);
            out.write(tmp.toByteArray());
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#VehicleUsed.write# " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 12) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.kmDebut = Integer.parseInt(tmp.substring(48, 69), 2);
        this.kmFin = Integer.parseInt(tmp.substring(69, 90), 2);
        this.source = Integer.parseInt(tmp.substring(90, 91), 2);
        this.manualInput = Integer.parseInt(tmp.substring(91, 92), 2) == 1;
        this.lecteur = Integer.parseInt(tmp.substring(92, 93), 2);
        int offset = 12;
        int length = fileBuffer[offset] >= 0 ? fileBuffer[offset] : fileBuffer[offset] + 256;
        this.nom = new String(fileBuffer).substring(++offset, offset + length);
        length = fileBuffer[offset += length] >= 0 ? fileBuffer[offset] : fileBuffer[offset] + 256;
        this.prenom = new String(fileBuffer).substring(++offset, offset + length);
        length = fileBuffer[offset += length] >= 0 ? fileBuffer[offset] : fileBuffer[offset] + 256;
        this.numeroCarte = new String(fileBuffer).substring(++offset, offset + length);
    }

    public static Vector<VehicleUsed> loadListVehicle(int cleConducteur, int cleVehicule, Date dateDebut, Date dateFin) {
        return VehicleUsed.loadListVehicle(cleConducteur, cleVehicule, ConversionTime.dateToString(dateDebut, "yyyy-MM-dd", null), ConversionTime.dateToString(dateFin, "yyyy-MM-dd", null), false);
    }

    public static Vector<VehicleUsed> loadListVehicle(int cleConducteur, int cleVehicule, Date dateDebut, Date dateFin, boolean extend) {
        return VehicleUsed.loadListVehicle(cleConducteur, cleVehicule, ConversionTime.dateToString(dateDebut, "yyyy-MM-dd", null), ConversionTime.dateToString(dateFin, "yyyy-MM-dd", null), extend);
    }

    public static Vector<VehicleUsed> loadListVehicle(int cleConducteur, int cleVehicule, String dateDebut, String dateFin, boolean extend) {
        return VehicleUsed.loadList(cleConducteur, cleVehicule, dateDebut, dateFin, vehicle_table, extend);
    }

    public static Vector<VehicleUsed> loadListDriver(int cleConducteur, int cleVehicule, Date dateDebut, Date dateFin) {
        return VehicleUsed.loadListDriver(cleConducteur, cleVehicule, ConversionTime.dateToString(dateDebut, "yyyy-MM-dd", null), ConversionTime.dateToString(dateFin, "yyyy-MM-dd", null));
    }

    public static Vector<VehicleUsed> loadListDriver(int cleConducteur, int cleVehicule, String dateDebut, String dateFin) {
        return VehicleUsed.loadList(cleConducteur, cleVehicule, dateDebut, dateFin, driver_table, false);
    }

    private static Vector<VehicleUsed> loadList(int cleConducteur, int cleVehicule, String dateDebut, String dateFin, String tableToLoad, boolean extend) {
        String sql = "";
        Vector<VehicleUsed> result = new Vector<VehicleUsed>();
        try {
            sql = "SELECT CLE, CLE_VEHICULE, CLE_CHAUFFEUR, NOM, PRENOM, NUMERO_CARTE, IMMATRICULATION, DATE_DEBUT, DATE_FIN,  KM_DEBUT, KM_FIN, KM_EFFECTUE, MANUAL_INPUT, LECTEUR, SOURCE FROM " + tableToLoad;
            String res = "";
            if (dateDebut != null) {
                String beginMark = BddTransport.getDateStringToSGBDR(dateDebut, false);
                String endMark = BddTransport.getDateStringToSGBDR(ConversionTime.addDay(dateFin == null ? dateDebut : dateFin, "yyyy-MM-dd", 1), false);
                res = extend ? String.valueOf(res) + " AND DATE_DEBUT < " + endMark + " AND DATE_FIN > " + beginMark : String.valueOf(res) + " AND DATE_DEBUT>=" + beginMark + " AND DATE_DEBUT<" + endMark;
            }
            if (cleVehicule != 0) {
                res = String.valueOf(res) + " AND CLE_VEHICULE =" + cleVehicule;
            }
            if (cleConducteur != 0) {
                res = String.valueOf(res) + " AND CLE_CHAUFFEUR=" + cleConducteur;
            }
            if (!res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY DATE_DEBUT";
            Transport.ps.startOperation();
            Statement stm = VehicleUsed.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate VehicleUsed", "#VehicleUsed.loadList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new VehicleUsed(rs.getInt("CLE"), rs.getInt("CLE_CHAUFFEUR"), rs.getInt("CLE_VEHICULE"), rs.getTimestamp("DATE_DEBUT"), rs.getTimestamp("DATE_FIN"), rs.getInt("KM_DEBUT"), rs.getInt("KM_FIN"), rs.getInt("KM_EFFECTUE") == 0 ? rs.getInt("KM_FIN") - rs.getInt("KM_DEBUT") : rs.getInt("KM_EFFECTUE"), rs.getBoolean("MANUAL_INPUT"), rs.getInt("LECTEUR"), rs.getString("NOM"), rs.getString("PRENOM"), rs.getString("NUMERO_CARTE"), rs.getString("IMMATRICULATION"), rs.getInt("SOURCE")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#getVehicleUsedDriver()# Erreur sql = " + sql + " => " + ex.getMessage());
        }
        return result;
    }

    public static VehicleUsed exist(VehicleUsed toSearch, Vector<VehicleUsed> list) {
        TimsLogger.debug("VehicleUsed.exist # search " + toSearch.getDateDebut() + " " + toSearch.getCleVehicule());
        for (VehicleUsed tmp : list) {
            TimsLogger.debug("VehicleUsed.exist # compare " + tmp.getDateDebut() + " " + tmp.getCleVehicule());
            if (tmp.getCleVehicule() != toSearch.getCleVehicule() || tmp.getDateDebut().compareTo(toSearch.getDateDebut()) != 0) continue;
            return tmp;
        }
        return null;
    }

    public static void updateConducteur(String numeroCarte, int driverId) {
        TimsLogger.debug("#VehicleUsed.updateConducteur()# numeroCarte " + numeroCarte);
        String sql = "UPDATE vehicle_used SET  CLE_CHAUFFEUR= ? WHERE NUMERO_CARTE=?";
        try {
            PreparedStatement statement = VehicleUsed.getConnection().prepareStatement(sql);
            statement.setObject(1, (Object)driverId, 4);
            statement.setObject(2, (Object)numeroCarte, 12);
            statement.executeUpdate();
            statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(vehicle_table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateVehicule(String immatriculation) {
        TimsLogger.debug("#VehicleUsed.updateVehicule()# immatriculation " + immatriculation);
        String sql = "UPDATE driver_vehicle_used SET  CLE_VEHICULE= (SELECT CLE_VEHICULE FROM t_vehicule WHERE N_IMMATRICULATION = ?) WHERE " + BddTransport.getClearedImmat("IMMATRICULATION") + " = " + BddTransport.getClearedImmat("?");
        try {
            PreparedStatement statement = VehicleUsed.getConnection().prepareStatement(sql);
            statement.setObject(1, (Object)immatriculation, 12);
            statement.setObject(2, (Object)immatriculation, 12);
            statement.executeUpdate();
            statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(driver_table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getSQLInsert() {
        return String.valueOf(this.getCleVehicule()) + "\t" + this.getCleConducteur() + "\t" + this.getPrenom() + "\t" + this.getNom() + "\t" + this.getNumeroCarte() + "\t" + this.getImmatriculation() + "\t" + ConversionTime.dateToString(this.getDateDebut(), "yyyy-MM-dd HH:mm:ss") + "\t" + this.getKmDebut() + "\t" + ConversionTime.dateToString(this.getDateFin(), "yyyy-MM-dd HH:mm:ss") + "\t" + this.getKmFin() + "\t" + (this.getKmFin() - this.getKmDebut()) + "\t" + (this.isManualInput() ? "1" : "0") + "\t" + this.getLecteur() + "\t" + this.getSource();
    }

    public static VehicleUsed fromVuCardRecord(VuCardRecord vcr, Vehicule vehicle) {
        return new VehicleUsed(0, 0, vehicle.getCleVehicule(), vcr.getInsertion(), vcr.getWithdraw(), vcr.getOdometerValueAtInsertion(), vcr.getOdometerValueAtWithdraw(), vcr.getOdometerValueAtWithdraw() - vcr.getOdometerValueAtInsertion(), vcr.getManualInput() == 1, vcr.getCardSlotNumber(), vcr.getCardHolder().getSurName(), vcr.getCardHolder().getFirstName(), vcr.getCard().getCardNumber().getCardNumber(), vehicle.getRegistrationNumber(), SOURCE_UEV);
    }
}

