/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.dao;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddTransport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DAO<T> {
    protected Connection connexion = BddTransport.getInstance().getConnection();

    public abstract int create(T var1);

    public abstract void update(T var1);

    public abstract void delete(T var1);

    public abstract T read(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int executeUpdate(String sql) {
        int toReturn = -1;
        Statement stm = null;
        try {
            try {
                stm = this.connexion.createStatement();
                toReturn = stm.executeUpdate(sql);
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ResultSet executeQuery(String sql) {
        ResultSet toReturn = null;
        Statement stm = null;
        try {
            try {
                stm = this.connexion.createStatement();
                toReturn = stm.executeQuery(sql);
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

