/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.jxmapviewer.viewer;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.GNSSPlace;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.jxmapviewer.viewer.TimsWaypoint;
import org.jxmapviewer.beans.AbstractBean;
import org.jxmapviewer.viewer.GeoPosition;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DefaultTimsWaypoint
extends AbstractBean
implements TimsWaypoint {
    private GNSSPlace place;
    private GeoPosition position;

    public DefaultTimsWaypoint(GNSSPlace place) {
        this.place = place;
        this.position = new GeoPosition(place.getLatitude(), place.getLongitude());
    }

    @Override
    public GeoPosition getPosition() {
        return this.position;
    }

    @Override
    public String getHtmlToolTip(boolean condensed) {
        return condensed ? String.valueOf(ConversionTime.dateToString(this.place.getPointTime(), "dd/MM/yyyy HH:mm")) + " - " + Vehicule.getVehicleLibelle(this.place.getVehicleId()) + " " + Conducteur.getDriverLibelle(this.place.getDriverId()) : "<html>" + ConversionTime.dateToString(this.place.getPointTime(), "dd/MM/yyyy HH:mm:ss") + "<br/>" + LanguageTranslator.getString("generics.vehicle") + " : " + Vehicule.getVehicleLibelle(this.place.getVehicleId()) + "<br/>" + LanguageTranslator.getString("generics.driver") + " : " + Conducteur.getDriverLibelle(this.place.getDriverId()) + "<br/>" + LanguageTranslator.getString("generics.km") + " : " + this.place.getVehicleOdometerValue() + "</html>";
    }

    @Override
    public String getVehicle() {
        try {
            Vehicule v = Vehicule.getVehicule(null, this.place.getVehicleId());
            String toReturn = v.getRegistrationNumber();
            if (toReturn == null) {
                toReturn = v.getIdentificationNumber();
            }
            return toReturn == null ? String.valueOf(v.getId()) : toReturn;
        }
        catch (DBObjectNotFoundException e) {
            TimsLogger.debug(String.valueOf(this.place.getVehicleId()) + " not found");
            return LanguageTranslator.getString("generics.unknown");
        }
    }

    @Override
    public String getDriver() {
        return Conducteur.getDriverLibelle(this.place.getDriverId());
    }

    @Override
    public int getOdometerValue() {
        return this.place.getVehicleOdometerValue();
    }

    @Override
    public GNSSPlace getGNSSPlace() {
        return this.place;
    }
}

