/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer;

import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.util.MercatorUtils;

public class WMSTileFactoryInfo
extends TileFactoryInfo {
    private String layers;
    private String styles;
    private String tileBgColor;
    private String tileFormat;
    private String srs;

    public WMSTileFactoryInfo(int minZoom, int maxZoom, int totalMapZoom, String baseURL, String layers, String styles, String defaultBgColor, String tileFormat, String srs, int tileSize) {
        super(minZoom, maxZoom, totalMapZoom, tileSize, true, true, baseURL, "x", "y", "zoom");
        this.layers = layers;
        this.styles = styles;
        this.tileBgColor = defaultBgColor;
        this.tileFormat = tileFormat;
        this.srs = srs;
    }

    public WMSTileFactoryInfo(int minZoom, int maxZoom, int totalMapZoom, String baseURL, String layers, String styles, String defaultBgColor) {
        this(minZoom, maxZoom, totalMapZoom, baseURL, layers, styles, defaultBgColor, "image/jpeg", "EPSG:4326", 255);
    }

    public WMSTileFactoryInfo(int minZoom, int maxZoom, int totalMapZoom, String baseURL, String layers, String defaultBgColor) {
        this(minZoom, maxZoom, totalMapZoom, baseURL, layers, "", defaultBgColor);
    }

    public WMSTileFactoryInfo(int minZoom, int maxZoom, int totalMapZoom, String baseURL, String layers) {
        this(minZoom, maxZoom, totalMapZoom, baseURL, layers, "0xAFDAF6");
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        int tileSize = this.getTileSize(zoom);
        zoom = this.getTotalMapZoom() - zoom;
        int z = (int)Math.pow(2.0, (double)zoom - 1.0);
        int m = x - z;
        int n = z - 1 - y;
        int tilesPerDimension = (int)Math.pow(2.0, zoom);
        double radius = (double)(tileSize * tilesPerDimension) / (Math.PI * 2);
        double ulx = MercatorUtils.xToLong(m * tileSize, radius);
        double uly = MercatorUtils.yToLat(n * tileSize, radius);
        double lrx = MercatorUtils.xToLong((m + 1) * tileSize, radius);
        double lry = MercatorUtils.yToLat((n + 1) * tileSize, radius);
        if (lrx < ulx) {
            lrx = -lrx;
        }
        String bbox = String.valueOf(ulx) + "," + uly + "," + lrx + "," + lry;
        String url = String.valueOf(this.getBaseURL()) + "?version=1.1.1&request=GetMap&layers=" + this.getLayers() + "&format=" + this.getTileFormat() + "&bbox=" + bbox + "&width=" + tileSize + "&height=" + tileSize + "&srs=" + this.getSrs() + "&styles=" + this.getStyles() + (this.getTileBgColor() == null ? "" : "&bgcolor=" + this.getTileBgColor());
        return url;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setLayers(String layers) {
        this.layers = layers;
    }

    public String getStyles() {
        return this.styles;
    }

    public void setStyles(String styles) {
        this.styles = styles;
    }

    public String getTileBgColor() {
        return this.tileBgColor;
    }

    public void setTileBgColor(String tileBgColor) {
        this.tileBgColor = tileBgColor;
    }

    public String getTileFormat() {
        return this.tileFormat;
    }

    public void setTileFormat(String tileFormat) {
        this.tileFormat = tileFormat;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }
}

