/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.google;

import org.jxmapviewer.viewer.TileFactoryInfo;

public class GoogleMapsTileFactoryInfo
extends TileFactoryInfo {
    private static final int max = 19;
    private static final int TILE_SIZE = 256;
    private final String key;

    public GoogleMapsTileFactoryInfo(String key) {
        this("Google Maps", "https://maps.googleapis.com/maps/api/staticmap", key);
    }

    public GoogleMapsTileFactoryInfo(String name, String baseURL, String key) {
        super(name, 1, 17, 19, 256, true, true, baseURL, "x", "y", "z");
        this.key = key;
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        System.out.println("testing for validity: X " + x + " Y = " + y);
        zoom = this.getTotalMapZoom() - zoom;
        double xtile = (double)x + 0.5;
        double ytile = (double)y + 0.5;
        double n = Math.pow(2.0, zoom);
        double lon_deg = xtile / n * 360.0 - 180.0;
        double lat_rad = Math.atan(Math.sinh(Math.PI * (1.0 - 2.0 * ytile / n)));
        double lat_deg = lat_rad * 180.0 / Math.PI;
        String url = String.valueOf(this.baseURL) + "?center=" + lat_deg + "," + lon_deg + "&zoom=" + zoom + "&key=" + this.key + "&maptype=roadmap" + "&size=" + 256 + "x" + 256;
        return url;
    }

    @Override
    public String getAttribution() {
        return "\u00a9 Google";
    }

    @Override
    public String getLicense() {
        return "https://www.google.com/intl/en_US/help/terms_maps/";
    }
}

