/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.input;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import org.jxmapviewer.JXMapViewer;

public class CenterMapListener
extends MouseAdapter {
    private JXMapViewer viewer;

    public CenterMapListener(JXMapViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        boolean singleClick;
        boolean left = SwingUtilities.isLeftMouseButton(evt);
        boolean middle = SwingUtilities.isMiddleMouseButton(evt);
        boolean doubleClick = evt.getClickCount() == 2;
        boolean right = SwingUtilities.isRightMouseButton(evt);
        boolean bl = singleClick = evt.getClickCount() == 1;
        if (middle || left && doubleClick) {
            this.recenterMap(evt);
        }
        if (right && singleClick) {
            this.viewer.reloadLastOverlay();
        }
    }

    private void recenterMap(MouseEvent evt) {
        Rectangle bounds = this.viewer.getViewportBounds();
        double x = bounds.getX() + (double)evt.getX();
        double y = bounds.getY() + (double)evt.getY();
        this.viewer.setCenter(new Point2D.Double(x, y));
        this.viewer.setZoom(this.viewer.getZoom() - 1);
        this.viewer.repaint();
    }
}

