/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.viewer;

import fr.pgh.data.bdd.GNSSPlace;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.DayTrack;

public class RoutePainter
implements Painter<JXMapViewer> {
    private final int INSET = 4;
    private Color color = Color.RED;
    private boolean antiAlias = true;
    private DayTrack dayTrack;

    public RoutePainter(DayTrack dayTrack, Color color) {
        this.dayTrack = dayTrack;
        this.color = color;
    }

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(3.0f));
        this.drawRoute(g, map);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(1.0f));
        this.drawRoute(g, map);
        g.dispose();
    }

    private void drawRoute(Graphics2D g, JXMapViewer map) {
        int lastX = 0;
        int lastY = 0;
        boolean first = true;
        for (GNSSPlace gp : this.dayTrack.getTrack()) {
            Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
            if (first) {
                first = false;
                g.drawOval(lastX - 5, lastY - 5, 10, 10);
            } else {
                g.drawLine(lastX, lastY, (int)pt.getX(), (int)pt.getY());
            }
            g.drawOval(lastX - 2, lastY - 2, 4, 4);
            lastX = (int)pt.getX();
            lastY = (int)pt.getY();
        }
        String text = this.dayTrack.getVehicle() == null ? "?" : (this.dayTrack.getVehicle().getRegistrationNumber() != null ? this.dayTrack.getVehicle().getRegistrationNumber() : this.dayTrack.getVehicle().getIdentificationNumber());
        Font oldFont = g.getFont();
        Font regFont = oldFont.deriveFont((float)oldFont.getSize() * 0.8f).deriveFont(oldFont.getStyle() | 1);
        g.setFont(regFont);
        FontMetrics metrics = g.getFontMetrics(regFont);
        int txtH = metrics.getHeight();
        int txtW = metrics.stringWidth(text) + 2;
        int rectX = lastX - txtW / 2 - 2;
        int rectY = lastY - 5 - txtH;
        int txtX = lastX - txtW / 2;
        int txtY = lastY - 5 - 2;
        g.fillRoundRect(rectX, rectY, txtW + 4, txtH, 10, 10);
        g.setColor(Color.BLACK);
        g.drawString(text, txtX, txtY);
        g.setFont(oldFont);
        g.drawOval(lastX - 5, lastY - 5, 10, 10);
    }
}

