/*
 * Decompiled with CFR 0.152.
 */
package transpo.system;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class RegisterUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextField txtCle = null;
    private JTextField txtCode = null;
    private JLabel lblCle = null;
    private JLabel lblCode = null;
    private JTextPane txtAccueil = null;
    private JButton btnConfirmer = null;
    private JButton btnQuitter = null;
    private String keyProduct;
    private String activationCode;

    public RegisterUI() {
        try {
            if (!new File("tims.install").exists()) {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("register.noConfigurationFile"));
                TimsLogger.warn("RegisterUI# no configuration file");
                System.exit(0);
            } else {
                BufferedReader br = new BufferedReader(new FileReader("tims.install"));
                this.keyProduct = br.readLine();
                this.activationCode = br.readLine();
                br.close();
            }
        }
        catch (FileNotFoundException exc) {
            TimsLogger.warn("Erreur RegisterProduct()");
            exc.printStackTrace();
        }
        catch (IOException ex) {
            System.err.println("erreur RegisterProduct() : " + ex);
        }
        if (this.keyProduct == null) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("register.badConfigurationFile"));
            System.exit(0);
        }
        if (this.activationCode != null && this.activationCode != "") {
            if (!this.register()) {
                this.initialize();
            } else {
                this.dispose();
            }
        } else {
            this.initialize();
        }
    }

    private void initialize() {
        this.setSize(330, 200);
        this.setTitle(LanguageTranslator.getString("register.title", Transport.res.getResourceString("executableVersion")));
        this.setLocationRelativeTo(this.getParent());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RegisterUI.this.exit();
            }
        });
        this.setContentPane(this.getJContentPane());
        this.setModal(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(0, 30, 5, 0);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = new Insets(0, 0, 5, 30);
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints11.gridy = 2;
            this.lblCode = new JLabel();
            this.lblCode.setText(LanguageTranslator.getString("register.activationCode"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.gridx = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getTxtCle(), gridBagConstraints);
            this.jContentPane.add((Component)this.getTxtCode(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getLblCle(), gridBagConstraints2);
            this.jContentPane.add((Component)this.lblCode, gridBagConstraints11);
            this.jContentPane.add((Component)this.getTxtAccueil(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getBtnConfirmer(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getBtnQuitter(), gridBagConstraints6);
        }
        return this.jContentPane;
    }

    private JTextField getTxtCle() {
        if (this.txtCle == null) {
            this.txtCle = new JTextField();
            this.txtCle.setText(this.keyProduct);
        }
        return this.txtCle;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JLabel getLblCle() {
        if (this.lblCle == null) {
            this.lblCle = new JLabel();
            this.lblCle.setText(LanguageTranslator.getString("register.key"));
        }
        return this.lblCle;
    }

    private JTextPane getTxtAccueil() {
        if (this.txtAccueil == null) {
            this.txtAccueil = new JTextPane();
            this.txtAccueil.setText(LanguageTranslator.getString("register.description"));
            this.txtAccueil.setBackground(new Color(238, 238, 238));
        }
        return this.txtAccueil;
    }

    public void exit() {
        System.exit(0);
    }

    private JButton getBtnConfirmer() {
        if (this.btnConfirmer == null) {
            this.btnConfirmer = new JButton();
            this.btnConfirmer.setText(LanguageTranslator.getString("button.valid"));
            this.btnConfirmer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RegisterUI.this.register()) {
                        RegisterUI.this.dispose();
                    }
                }
            });
        }
        return this.btnConfirmer;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.btnQuitter;
    }

    public String getCle() {
        String key = this.genKey(this.keyProduct);
        return key;
    }

    public boolean register() {
        File ficIns = new File("tims.install");
        if (!ficIns.exists()) {
            TimsLogger.warn("erreur : le fichier n'existe pas");
        } else {
            String cle = this.getCle();
            if (this.activationCode == null) {
                this.activationCode = this.getTxtCode().getText();
            }
            if (this.activationCode.equals(cle)) {
                Preferences p = Preferences.userRoot().node("TIMS");
                p.put("Licence", this.keyProduct);
                p.put("Activation", this.activationCode);
                ficIns.delete();
                return true;
            }
            TimsLogger.warn("erreur : mauvaise cl\u00e9 " + this.activationCode);
            this.activationCode = null;
        }
        return false;
    }

    public String genKey(String code) {
        int length = code.length();
        int tmp1 = Integer.parseInt(code.substring(0, length / 3));
        int tmp2 = Integer.parseInt(code.substring(length / 3, 2 * length / 3));
        long tmp3 = Long.parseLong(code.substring(2 * length / 3), 16);
        String tmp = String.valueOf(tmp3 - (long)(tmp1 + tmp2));
        String retour = "";
        int x = tmp.length() - 1;
        while (x >= 0) {
            retour = String.valueOf(retour) + tmp.charAt(x);
            --x;
        }
        TimsLogger.debug("G\u00e9n\u00e9ration du code pour " + code + " => " + retour);
        return retour;
    }
}

