/*
 * Decompiled with CFR 0.152.
 */
package transpo.system;

import fr.pgh.conversion.ConversionTime;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import transpo.system.Transport;

public class TimsLogger {
    public static String currentLogPath = null;
    private static boolean initialized = false;

    public TimsLogger() {
        if (Transport.apiMode != 1) {
            for (String older : TimsLogger.getList()) {
                if (!this.isOutdated(older)) continue;
                String fileName = "tims" + ConversionTime.dateStringToFormat(older, "dd/MM/yyyy HH'h'mm", "yyyyMMddHHmm") + ".log";
                new File(String.valueOf(Transport.savePath) + fileName).delete();
            }
        }
        if (Transport.debug == 0 || System.getProperty("forceLogCreate", "0").equals("1")) {
            this.createLog();
        } else {
            ConsoleAppender ca = new ConsoleAppender();
            ca.setWriter((Writer)new OutputStreamWriter(System.out));
            ca.setLayout((Layout)new PatternLayout("[%d{HH:mm:ss,SSS}] %-5p (%t)[%C]: %m%n"));
            if (Transport.debug >= 2) {
                ca.setThreshold((Priority)Level.ALL);
            } else {
                ca.setThreshold((Priority)Level.INFO);
            }
            ca.activateOptions();
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)ca);
            initialized = true;
        }
    }

    private void createLog() {
        try {
            String date = ConversionTime.dateToString(new Date(), "yyyyMMddHHmm");
            if (Transport.apiMode != 1) {
                currentLogPath = String.valueOf(System.getProperty("logTo") == null ? Transport.savePath : System.getProperty("logTo")) + "tims" + date + ".log";
                System.out.println("#TimsLogger.CreateLog#" + Transport.savePath + "tims" + date + ".log");
            } else {
                currentLogPath = "log/stdout" + date + ".log";
            }
            PrintStream ps = new PrintStream(currentLogPath);
            System.setOut(ps);
            System.setErr(ps);
            initialized = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void log(String message, String from) {
        if (!initialized) {
            System.out.println("#TimsLogger# logger not yet initialized");
        }
        System.out.println(String.valueOf(new SimpleDateFormat("[dd/MM/yyyy - HH:mm:ss] ").format(new Date())) + (from == null ? "" : "**" + from + "**") + " " + message);
    }

    public static void info(String message, String from) {
        TimsLogger.log("[INFO] " + message, from);
    }

    public static void info(String message) {
        TimsLogger.info(message, null);
    }

    public static void apiLog(String message, String from) {
        TimsLogger.log("[API] " + message, from);
    }

    public static void apiLog(String message) {
        TimsLogger.apiLog(message, null);
    }

    public static void warn(String message, String from) {
        TimsLogger.log("[WARN] " + message, from);
    }

    public static void warn(String message) {
        TimsLogger.warn(message, null);
    }

    public static void error(String message, String from) {
        TimsLogger.log("[ERROR] " + message, from);
    }

    public static void error(String message) {
        TimsLogger.error(message, null);
    }

    public static void debug(String message, String from) {
        if (Transport.debug >= 1) {
            TimsLogger.log("[DEBUG] " + message, from);
        }
    }

    public static void debug(String message) {
        TimsLogger.debug(message, null);
    }

    public static void verbose(String message, String from) {
        if (Transport.debug >= 3) {
            TimsLogger.log("[VERBOSE] " + message, from);
        }
    }

    public static void verbose(String message) {
        TimsLogger.verbose(message, null);
    }

    public static Vector<String> getList() {
        Vector<String> toReturn = new Vector<String>();
        File oldLog = new File(String.valueOf(Transport.savePath) + "tims.log");
        if (oldLog.exists()) {
            File newName = new File(String.valueOf(Transport.savePath) + "tims200901011200.log");
            if (newName.exists()) {
                newName.delete();
            }
            System.out.println("#TimsLogger.getList()# rename " + oldLog.getAbsolutePath() + " to " + newName.getAbsolutePath());
            oldLog.renameTo(newName);
        } else {
            System.out.println("#TimsLogger.getList()# not found " + oldLog.getAbsolutePath());
        }
        Pattern filter = Pattern.compile("tims[0-9]*\\.log");
        String[] s = new File(Transport.savePath).list();
        int i = 0;
        while (i < s.length) {
            Matcher m = filter.matcher(s[i]);
            if (m.matches()) {
                toReturn.add(ConversionTime.dateStringToFormat(s[i].substring(4, 16), "yyyyMMddHHmm", "dd/MM/yyyy HH'h'mm"));
            }
            ++i;
        }
        System.out.println("#TimsLogger.getList()# " + toReturn.size() + " log found");
        return toReturn;
    }

    public boolean isOutdated(String file) {
        if (this.getDate(file) == null) {
            return true;
        }
        return this.getDate(file).before(ConversionTime.addDay(new Date(), -7));
    }

    public Date getDate(String file) {
        if (file.length() != "dd/MM/yyyy HHhmm".length()) {
            System.out.println("#TimsLogger.getDate# bad name " + file);
            return null;
        }
        return ConversionTime.stringToDate(file, "dd/MM/yyyy HH'h'mm");
    }

    public static String getCurrentLogPath() {
        return currentLogPath;
    }
}

