/*
 * Decompiled with CFR 0.152.
 */
package transpo.system;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;

public class Tray {
    private static TrayIcon trayIcon;

    public static TrayIcon getTray() {
        return trayIcon;
    }

    public static void init() {
        if (SystemTray.isSupported()) {
            TimsLogger.verbose("start init");
            SystemTray tray = SystemTray.getSystemTray();
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TimsLogger.debug("Tray Icon - Mouse clicked!");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    TimsLogger.debug("Tray Icon - Mouse entered!");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TimsLogger.debug("Tray Icon - Mouse exited!");
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    TimsLogger.debug("Tray Icon - Mouse pressed!");
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        TimsLogger.debug("Tray Icon - Mouse released!");
                    }
                }
            };
            trayIcon = new TrayIcon(Fonctions.createImage("images/tims-ico.png", "SERVEUR"), "TIMS SERVEUR", Tray.getPopupMenu());
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    trayIcon.displayMessage("Status TIMS serveur", "L'application est en cours d'execution", TrayIcon.MessageType.INFO);
                }
            };
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(actionListener);
            trayIcon.addMouseListener(mouseListener);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                TimsLogger.warn("TrayIcon could not be added.");
            }
            trayIcon.displayMessage("TIMS SERVEUR", "L'application serveur est lanc\u00e9, vous avez acc\u00e8s aux options avec cet ic\u00f4ne", TrayIcon.MessageType.INFO);
        } else {
            TimsLogger.warn("Tray not supported.");
        }
    }

    public static PopupMenu getPopupMenu() {
        ActionListener exitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimsLogger.error("Exiting...");
                System.exit(0);
            }
        };
        ActionListener openLog = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimsLogger.info("Open Log...");
                if (TimsLogger.getCurrentLogPath() != null) {
                    File log = new File(TimsLogger.getCurrentLogPath());
                    if (log.exists()) {
                        this.getLogWindows(log).setVisible(true);
                    } else {
                        MessageSystemManager.error(null, "File not found", "File error");
                    }
                } else if (Transport.debug >= 1) {
                    this.getLogWindows(null).setVisible(true);
                } else {
                    MessageSystemManager.error(null, "File not found", "File error");
                }
            }

            private JDialog getLogWindows(File file) {
                JDialog showLog = new JDialog();
                showLog.setBounds(0, 0, 400, 250);
                JScrollPane jsp = new JScrollPane();
                JTextArea txt = new JTextArea();
                txt.setEnabled(false);
                jsp.setViewportView(txt);
                showLog.add(jsp);
                try {
                    String allFile = "";
                    if (file == null) {
                        allFile = "No log file passed, is it a debug mode ?";
                    } else {
                        String line;
                        RandomAccessFile raf = new RandomAccessFile(file, "r");
                        while ((line = raf.readLine()) != null) {
                            allFile = String.valueOf(allFile) + line + "\n";
                        }
                    }
                    txt.setText(allFile);
                }
                catch (IOException e) {
                    TimsLogger.warn("erreur dans: " + e);
                }
                return showLog;
            }
        };
        PopupMenu popup = new PopupMenu();
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(exitListener);
        popup.add(exitItem);
        MenuItem logItem = new MenuItem("Log");
        logItem.addActionListener(openLog);
        popup.add(logItem);
        return popup;
    }
}

