/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Societe;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.user.UserPreferences;
import transpo.system.util.Fonctions;
import transport.report.MasterReport;

public class ARCardDetail
extends JFrame {
    private JComboBox cbSociete = null;
    private JComboBox cbTypeExport = null;
    private JPanel pnlBtn = null;
    private JButton btnExporter = null;
    private JButton btnQuitter = null;
    private Vector<Agence> agencies = null;
    private Vector<Conducteur> drivers = null;

    public static void main(String[] args) {
        Transport.getArgs(args, new String[0]);
        Transport.init();
        Transport.debug = 2;
        new ARCardDetail().setVisible(true);
    }

    public ARCardDetail() {
        this.setSize(371, 160);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.gc();
                System.exit(0);
            }
        });
        this.setContentPane(this.getJContentPane());
        this.setTitle("Export conducteur");
    }

    private JPanel getJContentPane() {
        JPanel jContentPane = new JPanel();
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridwidth = 2;
        gridBagConstraints11.gridy = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridy = 0;
        jContentPane = new JPanel();
        jContentPane.setLayout(new GridBagLayout());
        jContentPane.add((Component)new JLabel("Soci\u00e9t\u00e9"), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 10, new Insets(0, 5, 0, 5)));
        jContentPane.add((Component)this.getCbSociete(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 10, new Insets(0, 5, 0, 5)));
        jContentPane.add((Component)new JLabel("Type d'export"), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 0, 10, new Insets(0, 5, 0, 5)));
        jContentPane.add((Component)this.getCbTypeExport(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, 10, new Insets(0, 5, 0, 5)));
        jContentPane.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 0.0, 1.0, 2, 10, new Insets(0, 5, 0, 5)));
        return jContentPane;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnExporter(), gridBagConstraints5);
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints4);
        }
        return this.pnlBtn;
    }

    private JComboBox getCbTypeExport() {
        if (this.cbTypeExport == null) {
            this.cbTypeExport = new JComboBox();
            this.cbTypeExport.addItem("pdf");
            this.cbTypeExport.addItem("\u00e9cran");
            this.cbTypeExport.addItem("xls");
            this.cbTypeExport.addItem("csv");
            String reportOut = UserPreferences.getPreferences("preference.report.out");
            if (reportOut != null) {
                this.cbTypeExport.setSelectedItem(reportOut);
            }
        }
        return this.cbTypeExport;
    }

    private JButton getBtnExporter() {
        if (this.btnExporter == null) {
            this.btnExporter = new JButton();
            this.btnExporter.setText("Exporter");
            this.btnExporter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ARCardDetail.this.execute();
                }
            });
        }
        return this.btnExporter;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText("Quitter");
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.btnQuitter;
    }

    private JComboBox getCbSociete() {
        if (this.cbSociete == null) {
            this.cbSociete = new JComboBox();
            ComboBoxModel modeleSociete = new ComboBoxModel(Societe.loadList(null), true, "SELECTIONNER UNE SOCIETE");
            this.cbSociete.setModel(modeleSociete);
            this.cbSociete.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Societe soc = (Societe)((ComboBoxModel)ARCardDetail.this.getCbSociete().getModel()).getObjectAt(ARCardDetail.this.getCbSociete().getSelectedIndex());
                    BddTransport.getInstance().changeDB(soc, false);
                }
            });
        }
        return this.cbSociete;
    }

    public void execute() {
        this.agencies = Agence.loadList(null, 0);
        this.drivers = Conducteur.loadList(0);
        TimsLogger.debug("G\u00e9n\u00e9ration du rapport " + this.agencies.size() + " " + this.drivers.size());
        Report report = new Report();
        report.loadByTranslationId("card");
        report.setTranslationId("conducteur");
        report.setCustomizedName("conducteur");
        report.setFileName("templatePortrait.jrxml");
        report.setClassToLoad("transport.report.CardDetail");
        report.setMinimumVersion(1);
        report.setModule(1);
        report.setType(1);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (System.getProperty("URL") != null) {
                params.put("SERVEUR", System.getProperty("HOME_PATH"));
            } else {
                params.put("SERVEUR", "");
            }
            params.put("OUT", this.getCbTypeExport().getSelectedItem().toString());
            MasterReport mr = null;
            if (!report.getClassToLoad().equals("NONE")) {
                Class<?> c = Class.forName(report.getClassToLoad());
                mr = (MasterReport)c.newInstance();
            } else {
                mr = new MasterReport();
            }
            mr.setValues(null, report, this.agencies, this.drivers, null, params);
            mr.process();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            TimsLogger.warn("#ARUevOffence.printTbl()# error during report process");
            ex.printStackTrace();
        }
    }
}

