/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class ARCardRenewal
extends AbstractAutomaticWarning {
    @Override
    public void execute() {
        Date firstDay = ConversionTime.getFirstDayOfPreviousMonth(ConversionTime.add(new Date(), 2, 3));
        Date lastDay = ConversionTime.getLastDayOfPreviousMonth(ConversionTime.add(new Date(), 2, 3));
        Report offenceReport = new Report();
        offenceReport.loadByTranslationId("card");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (System.getProperty("URL") != null) {
                params.put("SERVEUR", System.getProperty("HOME_PATH"));
            } else {
                params.put("SERVEUR", "");
            }
            params.put("DATE_DEBUT", ConversionTime.dateToString(firstDay, "dd/MM/yyyy"));
            params.put("DATE_FIN", ConversionTime.dateToString(lastDay, "dd/MM/yyyy"));
            params.put("NOM_SOC", null);
            params.put("BEGIN", firstDay);
            params.put("END", lastDay);
            params.put("RESOLUTION", 1);
            params.put("DETAIL", false);
            params.put("BRUTE", "1");
            params.put("OUT", "csv");
            params.put("DESTINATION", Transport.savePath);
            MasterReport mr = null;
            if (!offenceReport.getClassToLoad().equals("NONE")) {
                Class<?> c = Class.forName(offenceReport.getClassToLoad());
                mr = (MasterReport)c.newInstance();
            } else {
                mr = new MasterReport();
            }
            mr.setValues(null, offenceReport, Agence.loadList(null, 0), Conducteur.loadList(new Integer[0]), null, params);
            mr.process();
            TimsLogger.debug("offence file " + mr.reportName() + ".csv");
            if (new File(String.valueOf(Transport.savePath) + mr.reportName() + ".csv").exists()) {
                this.warnContent = "<br/>" + LanguageTranslator.getString("mail.uev.offence", new SimpleDateFormat("MMMM yyyy").format(firstDay)) + "<br/>";
                this.attachment.add(new File(String.valueOf(Transport.savePath) + mr.reportName() + ".csv"));
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            TimsLogger.warn("#ARUevOffence.printTbl()# error during report process");
            ex.printStackTrace();
        }
    }
}

