/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.util.Fonctions;

public class ARProjection
extends AbstractAutomaticWarning {
    private static final String FILE_NAME = "TIMS_CPT.txt";
    private Vector<Map<String, Object>> data = null;
    private PrintWriter writer;
    int workday = 0;
    Vector<Conducteur> drivers = null;
    Vector<Agence> agencies = Agence.getList();

    public static void main(String[] args) {
        Transport.getArgs(args, new String[0]);
        Transport.init();
        Transport.apiMode = 1;
        ARProjection test2 = new ARProjection();
        test2.execute();
    }

    public ARProjection() {
        this.drivers = Conducteur.loadList(0);
    }

    @Override
    public void execute() {
        try {
            if (!new File(String.valueOf(System.getProperty("export_default_path")) + FILE_NAME).exists()) {
                TimsLogger.info("ARProjection# Pas de fichier");
            }
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(System.getProperty("export_default_path")) + FILE_NAME, false)));
        }
        catch (IOException ex) {
            TimsLogger.warn("Impossible d'ouvrir le fichier");
        }
        Date begin = (Date)ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.DATE);
        Date end = (Date)ConversionTime.getLastDayOfMonth(new Date(), ConversionTime.DATE);
        this.workday = ConversionTime.getWorkday(begin, end);
        Vector<TypeContrat> contractList = TypeContrat.loadList();
        this.data = new Vector();
        boolean toAdd = true;
        int workedTime = 0;
        int workedDay = 0;
        int firstRule = 0;
        int secondRule = 0;
        int thirdRule = 0;
        int fourstRule = 0;
        int hourProj = 0;
        int satHour = 0;
        int satDayCount = 0;
        int altPaidHour = 0;
        int altGenerateHSHour = 0;
        int altDayCount = 0;
        Vector<String> dayTypeOnly = new Vector<String>();
        Vector<Service> tmpS = Service.getService(this.agencies, null, begin, end);
        Vector<LienJourConducteur> others = LienJourConducteur.loadList(this.agencies, null, begin, end);
        Conducteur currentDriver = null;
        int defaultDayLength = 0;
        TimsLogger.debug("#ARProjection.process()# " + tmpS.size() + " services");
        if (tmpS.size() == 0) {
            return;
        }
        for (Service s : tmpS) {
            if (currentDriver == null || s.getDriverId() != currentDriver.getCleConducteur()) {
                if (currentDriver != null && toAdd) {
                    float moyenne = workedDay == 0 ? 0.0f : (float)workedTime / (float)workedDay;
                    hourProj = (int)(moyenne * (float)(this.workday - altDayCount));
                    TimsLogger.debug(String.valueOf(currentDriver.getMatricule()) + " => " + (hourProj + altPaidHour + satHour));
                    this.writeLine(currentDriver, hourProj + altPaidHour + satHour);
                }
                toAdd = true;
                altDayCount = 0;
                altGenerateHSHour = 0;
                altPaidHour = 0;
                satDayCount = 0;
                satHour = 0;
                hourProj = 0;
                fourstRule = 0;
                thirdRule = 0;
                secondRule = 0;
                firstRule = 0;
                workedDay = 0;
                workedTime = 0;
                dayTypeOnly.clear();
                try {
                    currentDriver = Conducteur.getDriver(this.drivers, s.getDriverId());
                    if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                        try {
                            TypeContrat driverContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                            defaultDayLength = driverContract.getDailyValue();
                        }
                        catch (TypeContratNotFoundException ex) {
                            TimsLogger.warn("Contrat " + currentDriver.getCleTypeContrat() + " introuvable pour " + currentDriver.getNom());
                            toAdd = false;
                        }
                    }
                }
                catch (DriverNotFoundException ex) {
                    TimsLogger.warn("Unable to find driver " + s.getDriverId());
                    toAdd = false;
                }
                for (LienJourConducteur tmp : others) {
                    int day;
                    JourType dayType = tmp.getDayType();
                    if (tmp.getCleConducteur() != currentDriver.getCleConducteur()) continue;
                    if (dayType.isPaid()) {
                        altPaidHour += tmp.getDuree(defaultDayLength);
                    }
                    if (dayType.isGenerateHS()) {
                        altGenerateHSHour += tmp.getDuree(defaultDayLength);
                    }
                    if (tmp.getType() == 2 || tmp.getDuree(defaultDayLength) >= 420) {
                        day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false);
                        if (day != 7 && day != 1) {
                            ++altDayCount;
                        }
                    } else if (tmp.getType() == 1 && LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() > 1 && (day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false)) != 7 && day != 1) {
                        ++altDayCount;
                    }
                    if (!dayType.isServiceIncluded() || tmp.getType() != 2 && (!System.getProperty("company", "PGH").equals("salvesen") || tmp.getDuree(defaultDayLength) < 420)) continue;
                    TimsLogger.debug("#ARProjection.process# no service possible on " + tmp.getDateJour());
                    dayTypeOnly.add(ConversionTime.dateToString(tmp.getDateJour(), "yyyy-MM-dd"));
                }
            }
            if (currentDriver.getMatricule() == null || currentDriver.getMatricule().equals("")) {
                toAdd = false;
            }
            if (dayTypeOnly.contains(s.getBeginDate().substring(0, 10))) {
                TimsLogger.debug("#ARProjection.process# Unauthorized service on " + s.getBeginDate());
                continue;
            }
            if (ConversionTime.getDayOfWeek(s.getBeginDate(), "yyyy-MM-dd HH:mm:ss", false) == 7) {
                satHour += s.getService();
                ++satDayCount;
                continue;
            }
            workedTime += s.getService();
            ++workedDay;
            workedDay += ConversionTime.getNbJourBetween(s.getBeginDate(), s.getEndDate(), "yyyy-MM-dd HH:mm:ss");
            firstRule += s.getFirstWork();
            secondRule += s.getLastWork();
            thirdRule += s.getFirstWorkAfterRest();
            fourstRule += s.getSecondWorkAfterRest();
        }
        if (toAdd) {
            float moyenne = workedDay == 0 ? 0.0f : (float)workedTime / (float)workedDay;
            hourProj = (int)(moyenne * (float)(this.workday - altDayCount));
            TimsLogger.debug(String.valueOf(currentDriver.getMatricule()) + " => " + (hourProj + altPaidHour + satHour));
            this.writeLine(currentDriver, hourProj + altPaidHour + satHour);
        }
        this.writer.close();
        if (System.getProperty("export_default_path_bis") != null) {
            String file = String.valueOf(System.getProperty("export_default_path")) + FILE_NAME;
            String copy = String.valueOf(System.getProperty("export_default_path_bis")) + FILE_NAME;
            try {
                Fonctions.copy(file, copy);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void writeLine(Conducteur driver, int projection) {
        String hProjection = ConversionTime.heureIntToString(projection, ".");
        while (hProjection.length() < 7) {
            hProjection = "0" + hProjection;
        }
        String mat = driver.getMatricule();
        while (mat.length() < 16) {
            mat = String.valueOf(mat) + " ";
        }
        this.writer.write("CRE                                                " + mat + "                                        " + "        " + ConversionTime.dateToString(new Date(), "dd/MM/yyyy") + "        " + "          " + "       " + "ZTIMS               " + "    " + "H" + hProjection + "      " + "      " + "        " + "                    " + "    " + " " + "       " + "      " + "      " + "        " + "                                                                             ");
        this.writer.flush();
    }
}

