/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.UevSession;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.uev.VuProcessingG1;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGenerator;

public class ARVuAnalyze
extends AbstractAutomaticWarning {
    @Override
    public void execute() {
        String fileName = "Donn\u00e9es manquantes v\u00e9hicule - " + ConversionTime.dateToString(new Date(), "MMMMM Y");
        Date end = (Date)ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.DATE);
        Date from = ConversionTime.add(end, 2, -6);
        CustomReport crManque = CustomReportFactory.getGeneric(fileName);
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, "IMMATRICULATION", String.class.getName(), "", 20, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "AGENCE", String.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DEBUT", String.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "FIN", String.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DUREE", Integer.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "KM", Integer.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "SESSION", String.class.getName(), "", 40, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DATE ENTREE", String.class.getName(), "", 40, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DATE SORTIE", String.class.getName(), "", 40, column.size() + 1));
        crManque.setColumn(column);
        ArrayList dataManque = new ArrayList();
        ArrayList<String> missingDownload = new ArrayList<String>();
        String sFrom = ConversionTime.dateToStringDb(from);
        Vector<UevDownload> to = UevDownload.loadList("DATE_TELECHARGEMENT > \"" + sFrom + "\"");
        TimsLogger.debug("#Fonctions.analyseHole# " + to.size() + " fichiers \u00e0 analyser " + sFrom);
        Vehicule current = null;
        Vector<UevSession> lastSessionList = null;
        ArrayList<UevEventsFaults> interruption = new ArrayList<UevEventsFaults>();
        TreeMap<Date, Integer> activeDay = new TreeMap<Date, Integer>();
        Date lastDownload = null;
        int x = 0;
        while (x < to.size()) {
            UevDownload d = to.get(x);
            try {
                Vehicule v = d.getVehicle();
                File file = new File(String.valueOf(Transport.savePath) + "\\" + d.getFichier());
                if (!file.exists()) {
                    file = FileManager.getFile(v, d.getFichier());
                }
                if (file != null) {
                    if (current == null || !current.equals(v) || x == to.size() - 1) {
                        if (current != null) {
                            TimsLogger.debug("Processing " + current.getRegistrationNumber() + " next " + v.getRegistrationNumber());
                            Date entry = ConversionTime.stringToDateDb(current.getDateEntree());
                            if (activeDay.size() != 0) {
                                ArrayList l = new ArrayList(activeDay.keySet());
                                while (((Date)l.get(0)).before(from) || entry != null && ((Date)l.get(0)).before(entry)) {
                                    activeDay.remove(l.get(0));
                                    l.remove(0);
                                    if (activeDay.size() == 0) break;
                                }
                                current.loadById(current.getCleVehicule());
                                Date toAdd = ConversionTime.addDay(from, -1);
                                if (entry != null && toAdd.before(entry)) {
                                    toAdd = ConversionTime.addDay(entry, -1);
                                }
                                activeDay.put(toAdd, 0);
                                Fonctions.sort(dataManque, null, current, activeDay, lastSessionList, lastDownload, interruption);
                            } else {
                                TimsLogger.debug("Pas de jours \u00e0 traiter pour " + current.getRegistrationNumber());
                            }
                        }
                        current = v;
                        lastSessionList = null;
                        interruption = new ArrayList();
                        activeDay = new TreeMap();
                        lastDownload = null;
                        missingDownload.clear();
                    }
                    VuProcessingG1 uevdp = new VuProcessingG1(file);
                    lastSessionList = uevdp.getSessionList();
                    for (UevEventsFaults toAdd : uevdp.getInterruption()) {
                        if (interruption.contains(toAdd)) continue;
                        interruption.add(toAdd);
                    }
                    if (lastDownload != null && !lastDownload.equals(d.getPreviousDownload())) {
                        missingDownload.add(ConversionTime.dateToStringFr(d.getPreviousDownload()));
                    }
                    lastDownload = d.getTelechargement();
                    TimsLogger.debug(activeDay.size() + " " + d.getTelechargement());
                    HashMap<Date, Integer> days = uevdp.getActiveDay();
                    if (days != null) {
                        activeDay.putAll(days);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++x;
        }
        TimsLogger.debug(String.valueOf(dataManque.size()) + " lines");
        boolean generated = Fonctions.tblToReport(crManque, new DJGenerator(), dataManque, "xls", Transport.savePath);
        if (generated) {
            File toSend = new File(String.valueOf(Transport.savePath) + fileName + ".xls");
            if (toSend.exists()) {
                this.warnContent = "<br/>" + LanguageTranslator.getString("mail.analyze") + "<br/>";
                this.attachment.add(toSend);
            } else {
                TimsLogger.warn("Can't find report " + toSend.getAbsolutePath());
            }
        } else {
            TimsLogger.error("#ARUevIntervention.execute# generation error");
        }
    }
}

