/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic.launcher;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Configuration;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.PayPeriod;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.Utilisateur;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.mail.MailSender;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class AutomaticWarningLauncher {
    MailSender ms = null;
    private static boolean fullTest = false;
    private static String userTest = null;
    private static String companyTest = null;

    public static void main(String[] args) {
        System.setProperty("SGBDR", "mysql");
        System.setProperty("URL", "tims.pgh.fr/");
        System.setProperty("HOME_PATH", "tims.pgh.fr/");
        System.setProperty("BASE", "tims.pgh.fr");
        System.setProperty("PORT", "3306");
        System.setProperty("USER", "sgobert");
        System.setProperty("PASSWORD", "Lod$69jm42");
        Transport.apiMode = 1;
        Transport.getArgs(args, new String[0]);
        if (Transport.debug == 2) {
            userTest = "sgobert";
            fullTest = true;
            int i = 0;
            while (i < args.length) {
                if (args[i].toLowerCase().startsWith("usertest")) {
                    userTest = args[i].substring(args[i].indexOf("=") + 1).trim();
                    TimsLogger.debug("#AwL.main# Test de " + userTest);
                }
                ++i;
            }
            if (userTest == null) {
                fullTest = true;
                TimsLogger.debug("#AwL.main# Test complet de la base");
            }
        }
        new AutomaticWarningLauncher();
    }

    public AutomaticWarningLauncher() {
        Transport.init();
        try {
            this.ms = new MailSender();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Vector<Utilisateur> superUsers = new Vector<Utilisateur>();
        HashMap<Utilisateur, String> suContent = new HashMap<Utilisateur, String>();
        for (Utilisateur user : Utilisateur.listAdmin()) {
            if (!user.isAlerted() || user.isRestreintSociete()) continue;
            superUsers.add(user);
        }
        Configuration.loadList(null, true);
        Vector<Societe> tmp = Societe.loadList(null);
        for (Societe current : tmp) {
            if (companyTest != null && !current.getNomSociete().equals(companyTest)) {
                TimsLogger.info("on saute la soci\u00e9t\u00e9 " + current.getNomSociete() + " (on fait un test de " + companyTest + ")");
                continue;
            }
            TimsLogger.info("Traitement de la soci\u00e9t\u00e9 " + current.getNomSociete() + " (" + current.getNomBase() + ")");
            Transport.bdd.changeDB(current, false);
            Vector<Utilisateur> toProcess = Utilisateur.list(current.getNomSociete());
            toProcess.addAll(superUsers);
            for (Utilisateur user : toProcess) {
                if (userTest != null && !user.getLogin().equals(userTest)) {
                    TimsLogger.info("on saute l'utilisateur " + user.getLogin() + " (on fait un test de " + userTest + ")");
                    continue;
                }
                if (!user.isAlerted() || !user.isEnable()) {
                    TimsLogger.info("Alertes d\u00e9sactiv\u00e9es " + user.getNom());
                    continue;
                }
                ConnexionSettings.getInstance().chargerUser(user.getLogin(), user.getMdp());
                Region.setList(null);
                Agence.setList(null);
                JourType.setList(null);
                TypeContrat.setList(null);
                ExpensesType.setList(null);
                TypeActivite.setList(null);
                PayPeriod.setList(null);
                Conducteur.setList(null);
                OffenceType.setList(null);
                OffencePart.setList(null);
                OffenceThreshold.setList(null);
                RoundType.setList(null);
                System.gc();
                String userMail = "";
                ArrayList<File> attachment = new ArrayList<File>();
                Vector<AutomaticWarning> userWarn = AutomaticWarning.loadUserList(user.getCleUser());
                TimsLogger.info("Traitement des alertes de l'utilisateur " + user.getNom() + " (" + userWarn.size() + " alertes actives)");
                for (AutomaticWarning warning : userWarn) {
                    TimsLogger.info("#AutoWarnLauncher# Traitement " + warning.getName());
                    if (this.execution(warning)) {
                        TimsLogger.debug("#AutoWarnLauncher# executing " + warning.getName() + " for " + user.getLogin() + " on " + current.getNomSociete());
                        try {
                            Class<?> c = Class.forName(warning.getCalculationClass());
                            AbstractAutomaticWarning userWarning = (AbstractAutomaticWarning)c.newInstance();
                            userWarning.execute();
                            TimsLogger.info(String.valueOf(warning.getCalculationClass()) + " => " + (userWarning.getWarnContent() != null ? String.valueOf(userWarning.getWarnContent().length()) + " car" : "0 car"));
                            TimsLogger.debug(String.valueOf(warning.getCalculationClass()) + " => \"\"" + userWarning.getWarnContent() + "\"\"");
                            userMail = String.valueOf(userMail) + (userWarning.getWarnContent() != null ? userWarning.getWarnContent() : "");
                            attachment.addAll(userWarning.getAttachment());
                        }
                        catch (Exception ex) {
                            TimsLogger.error(String.valueOf(warning.getName()) + " error " + ex.getMessage());
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    TimsLogger.debug(String.valueOf(warning.getName()) + " not today " + warning.getFrequency() + " " + warning.getExecutionDate());
                }
                ArrayList<String> tos = new ArrayList<String>();
                tos.add(fullTest ? "sebastien.gobert@pgh.fr" : user.getEmail());
                try {
                    if (superUsers.contains(user) && !userMail.equals("")) {
                        String ever = (String)suContent.get(user);
                        userMail = "<h2>Soci\u00e9t\u00e9 " + current.getNomSociete() + "</h2>" + userMail;
                        suContent.put(user, ever == null ? userMail : String.valueOf(ever) + "<br/>" + userMail);
                    } else if (!userMail.equals("")) {
                        userMail = String.valueOf(LanguageTranslator.getString("mail.welcome", user.getPrenom(), user.getNom())) + "<br/>" + userMail;
                        if (Transport.debug == 0) {
                            this.ms.sendMessage(tos, "Alertes automatiques TIMS", userMail, attachment, false);
                        } else {
                            PrintWriter writer = new PrintWriter("E:/TEST-AUTO/" + user.getLogin() + " - " + user.getEmail() + ".html");
                            for (File toS : attachment) {
                                new File("E:/TEST-AUTO/" + user.getLogin() + "/").mkdirs();
                                toS.renameTo(new File("E:/TEST-AUTO/" + user.getLogin() + "/" + toS.getName()));
                                writer.println("Send " + toS.getName());
                            }
                            writer.println(userMail);
                            writer.close();
                        }
                        TimsLogger.info("#AWL# " + userMail.length() + " caract\u00e8res envoy\u00e9s \u00e0 " + user.getEmail() + " (" + attachment.size() + " fichiers joints)");
                    }
                }
                catch (Exception ex) {
                    TimsLogger.error(String.valueOf(userMail) + " mail error " + ex.getMessage());
                    ex.printStackTrace();
                }
                for (File toDel : attachment) {
                    TimsLogger.debug("#AWL# Delete " + toDel.getName() + " for " + user.getPrenom() + " " + user.getNom());
                    toDel.delete();
                }
            }
        }
        for (Utilisateur su : superUsers) {
            TimsLogger.info("#AWL# process super user " + su.getLogin());
            ArrayList<String> tos = new ArrayList<String>();
            tos.add(fullTest ? "sebastien.gobert@pgh.fr" : su.getEmail());
            String toSend = (String)suContent.get(su);
            if (toSend == null || toSend.equals("")) continue;
            try {
                if (Transport.debug == 0) {
                    this.ms.sendMessage(tos, "Alertes ADMINISTRATEUR TIMS", toSend, null, false);
                } else {
                    PrintWriter writer = new PrintWriter("E:/TEST-AUTO/ADMIN-" + su.getEmail() + ".html");
                    writer.println(toSend);
                    writer.close();
                }
                TimsLogger.info("#AWL# " + toSend.length() + " caract\u00e8res envoy\u00e9s \u00e0 super user " + su.getEmail() + " (0 fichiers joints)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean execution(AutomaticWarning warning) {
        if (Transport.debug >= 2) {
            return true;
        }
        switch (warning.getFrequency()) {
            case 0: {
                return true;
            }
            case 1: {
                TimsLogger.info(String.valueOf(warning.getName()) + " weekly => " + ConversionTime.getDayOfWeek(new Date(), false) + " =? " + (warning.getExecutionDate() + 1));
                return ConversionTime.getDayOfWeek(new Date(), false) == warning.getExecutionDate() + 1;
            }
            case 2: {
                TimsLogger.info(String.valueOf(warning.getName()) + " monthly => " + ConversionTime.dateToString(new Date(), "dd") + " =? " + warning.getExecutionDate());
                return ConversionTime.dateToString(new Date(), "dd").equals(String.valueOf(warning.getExecutionDate()));
            }
            case 3: {
                return ConversionTime.dateToString(new Date(), "ddMM").equals("0101");
            }
        }
        TimsLogger.debug("#AutoWarnLauncher.execute# unknow frequency " + warning.getFrequency());
        return false;
    }
}

