/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.controller;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverDayAnomaly;
import fr.pgh.data.bdd.DriverDownloadWarning;
import fr.pgh.data.bdd.ImportActivity;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.viewable.ProgressViewManager;
import transpo.system.util.CsvReading;
import transpo.system.util.Fonctions;
import transpo.system.util.ProcessType;

public class ImportActivityController {
    private File file = null;
    private String dateFormat = "dd/MM/yyyy";
    private ArrayList<String[]> content = null;
    private ArrayList<Jour> driverDays = null;
    private ArrayList<LienJourConducteur> driverMissings = null;
    private Vector<VehicleUsed> vehicleUsed = null;
    private ArrayList<String[]> driverPeriod = new ArrayList();
    private Vector<String> unknownRegistrationNumber = new Vector();
    private ImportActivity currentImport = null;
    ProgressViewManager pg = null;

    public ImportActivityController(ProgressViewManager pg) {
        this.content = new ArrayList();
        this.driverDays = new ArrayList();
        this.driverMissings = new ArrayList();
        this.vehicleUsed = new Vector();
        this.pg = pg;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int analyzeFile() {
        this.pg.setVisible(true);
        this.currentImport = new ImportActivity(0, ImportActivity.Status.ANALYZED, null, this.file.getName(), ConnexionSettings.getInstance().getUserCle());
        this.pg.setText("V\u00e9rification de la structure du fichier");
        if (this.checkFileStructure() != 1) {
            return 0;
        }
        this.pg.setText("Analyse du contenu");
        this.convertContent();
        this.checkContent();
        this.pg.setVisible(false);
        return 1;
    }

    public ArrayList<DriverDownloadWarning> getDriverWarnings() {
        return this.currentImport.getWarnings();
    }

    public void setDriverWarnings(ArrayList<DriverDownloadWarning> driverWarnings) {
        this.currentImport.setWarnings(driverWarnings);
    }

    public ArrayList<DriverDayAnomaly> getDriverDayAnomalies() {
        return this.currentImport.getAnomalies();
    }

    public void setDriverDayAnomalies(ArrayList<DriverDayAnomaly> driverDayAnomalies) {
        this.currentImport.setAnomalies(driverDayAnomalies);
    }

    public ArrayList<Jour> getDriverDays() {
        return this.driverDays;
    }

    public void setDriverDays(ArrayList<Jour> driverDays) {
        this.driverDays = driverDays;
    }

    public ArrayList<LienJourConducteur> getDriverMissings() {
        return this.driverMissings;
    }

    public void setDriverMissings(ArrayList<LienJourConducteur> driverMissings) {
        this.driverMissings = driverMissings;
    }

    public ImportActivity getCurrentImport() {
        return this.currentImport;
    }

    public void setCurrentImport(ImportActivity current) {
        this.currentImport = current;
    }

    public Vector<String> getUnknownRegistrationNumber() {
        return this.unknownRegistrationNumber;
    }

    public void setUnknownRegistrationNumber(Vector<String> unknownRegistrationNumber) {
        this.unknownRegistrationNumber = unknownRegistrationNumber;
    }

    public int convertContent() {
        int currentBegin = -1;
        int currentNight = 0;
        int kmTotal = 0;
        int workTotal = 0;
        int restTotal = 0;
        Conducteur currentDriver = null;
        String begin = null;
        String end = null;
        int ending = 0;
        Vector<ActiviteConducteur> activities = new Vector<ActiviteConducteur>();
        int x = 0;
        while (x < this.content.size()) {
            block21: {
                String[] line = this.content.get(x);
                String matricule = line[0];
                Date beginDate = ConversionTime.stringToDate(line[1], this.dateFormat);
                int beginHour = ConversionTime.heureStringToInt(line[2], ".");
                Date endDate = ConversionTime.stringToDate(line[3], this.dateFormat);
                int endHour = ConversionTime.heureStringToInt(line[4], ".");
                String additional = line[5];
                Date beginDateTime = ConversionTime.stringToDate(String.valueOf(line[1]) + " " + line[2], String.valueOf(this.dateFormat) + " HH.mm");
                Date endDateTime = ConversionTime.stringToDate(String.valueOf(line[3]) + " " + line[4], String.valueOf(this.dateFormat) + " HH.mm");
                int km = line.length > 6 ? Integer.parseInt(line[6]) : 0;
                try {
                    String[] newLine;
                    MainElement toAdd;
                    boolean hasNext;
                    Conducteur driver = Conducteur.getDriver(null, matricule);
                    boolean bl = hasNext = x < this.content.size() - 1;
                    if (begin == null) {
                        begin = ConversionTime.dateToStringDb(beginDate);
                    }
                    end = ConversionTime.dateToStringDb(endDate);
                    ending = endHour;
                    try {
                        JourType dayType = JourType.getDayType(additional);
                        toAdd = new LienJourConducteur();
                        toAdd.setValues(0, driver.getCleConducteur(), dayType.getCle(), ConnexionSettings.getInstance().getUserCle(), beginDate, beginHour, 0, 2);
                        this.driverMissings.add((LienJourConducteur)toAdd);
                        TimsLogger.debug("#IAC.convertContent# save " + driver.getMatricule() + " / " + ConversionTime.dateToStringDb(beginDate) + " / " + dayType.getCode());
                        if (!hasNext || !driver.getMatricule().equals(this.content.get(x + 1)[0])) {
                            TimsLogger.debug("#IAC.convertContent# add period (last is day) " + driver.getMatricule() + " : " + begin + " => " + end);
                            newLine = new String[]{String.valueOf(driver.getCleConducteur()), begin, end, String.valueOf(ending)};
                            this.driverPeriod.add(newLine);
                            begin = null;
                            end = null;
                            ending = 0;
                        }
                    }
                    catch (DayTypeNotFoundException dayType) {
                        if (currentDriver == null) {
                            activities.add(new ActiviteConducteur(driver.getCleConducteur(), 0, 4, "R", 0, beginHour, beginHour, ConversionTime.dateToStringDb(beginDate), "IMPORT", this.file.getName(), "", "", "", 0));
                            currentDriver = driver;
                        }
                        if (currentBegin == -1) {
                            currentBegin = beginHour;
                        }
                        int length = endHour > beginHour ? endHour - beginHour : 1440 - beginHour;
                        toAdd = new ActiviteConducteur(driver.getCleConducteur(), 0, 2, "T", beginHour, endHour > beginHour ? endHour : 1440, length, ConversionTime.dateToStringDb(beginDate), "IMPORT", this.file.getName(), "", "", "", 0);
                        currentNight += Fonctions.getTempsNuit((ActiviteConducteur)toAdd);
                        kmTotal += km;
                        workTotal += length;
                        activities.add((ActiviteConducteur)toAdd);
                        if (beginDate.compareTo(endDate) != 0) {
                            TimsLogger.debug("#IAC.convertContent# save " + driver.getMatricule() + " / " + ConversionTime.dateToStringDb(beginDate) + " / " + workTotal + " / " + restTotal);
                            this.driverDays.add(new Jour(0, driver.getCleConducteur(), ConversionTime.dateToStringDb(beginDate), 0, workTotal, 0, restTotal, 0, 0, 0, workTotal, currentBegin, endHour, currentNight, kmTotal, 0, false, activities, "", ConnexionSettings.getInstance().getUserCle(), this.file.getName(), false));
                            currentBegin = 0;
                            currentNight = 0;
                            kmTotal = 0;
                            workTotal = 0;
                            activities = new Vector();
                            toAdd = new ActiviteConducteur(driver.getCleConducteur(), 0, 2, "T", 0, endHour, endHour, ConversionTime.dateToStringDb(endDate), "IMPORT", this.file.getName(), "", "", "", 0);
                            currentNight += Fonctions.getTempsNuit((ActiviteConducteur)toAdd);
                            workTotal = length;
                            activities.add((ActiviteConducteur)toAdd);
                        }
                        TimsLogger.debug("#IAC.convertContent# hasNext : " + hasNext + " <><> " + (hasNext ? "new driver : " + !currentDriver.getMatricule().equals(this.content.get(x + 1)[0]) + " (" + currentDriver.getMatricule() + "//" + this.content.get(x + 1)[0] + ") <><>" + "date : " + (beginDate.compareTo(ConversionTime.stringToDate(this.content.get(x + 1)[1], this.dateFormat)) != 0) + " (" + beginDate + "//" + ConversionTime.stringToDate(this.content.get(x + 1)[1], this.dateFormat) + ")" : "no next"));
                        if (!hasNext || !currentDriver.getMatricule().equals(this.content.get(x + 1)[0]) || beginDate.compareTo(ConversionTime.stringToDate(this.content.get(x + 1)[1], this.dateFormat)) != 0) {
                            activities.add(new ActiviteConducteur(driver.getCleConducteur(), 0, 4, "R", endHour, 1440, 1440 - endHour, ConversionTime.dateToStringDb(beginDate), "IMPORT", this.file.getName(), "", "", "", 0));
                            TimsLogger.debug("#IAC.convertContent# save " + driver.getMatricule() + " / " + ConversionTime.dateToStringDb(beginDate) + " / " + workTotal + " / " + restTotal);
                            this.driverDays.add(new Jour(0, driver.getCleConducteur(), ConversionTime.dateToStringDb(beginDate), 0, workTotal, 0, restTotal, 0, 0, 0, workTotal, currentBegin, endHour, currentNight, kmTotal, 0, false, Fonctions.sortActivitiesList(activities), "", ConnexionSettings.getInstance().getUserCle(), this.file.getName(), false));
                            if (!hasNext || !currentDriver.getMatricule().equals(this.content.get(x + 1)[0])) {
                                TimsLogger.debug("#IAC.convertContent# add period (last is activity) " + driver.getMatricule() + " : " + begin + " => " + end);
                                newLine = new String[]{String.valueOf(currentDriver.getCleConducteur()), begin, end, String.valueOf(ending)};
                                this.driverPeriod.add(newLine);
                                begin = null;
                                end = null;
                                ending = 0;
                            }
                            currentBegin = -1;
                            currentNight = 0;
                            kmTotal = 0;
                            currentDriver = null;
                            workTotal = 0;
                            activities = new Vector();
                        } else {
                            int next = ConversionTime.heureStringToInt(this.content.get(x + 1)[2], ".");
                            if (endHour < next) {
                                activities.add(new ActiviteConducteur(driver.getCleConducteur(), 0, 4, "R", endHour, next, next - endHour, ConversionTime.dateToStringDb(beginDate), "IMPORT", this.file.getName(), "", "", "", 0));
                            }
                        }
                        if (km == 0) break block21;
                        try {
                            Vehicule used = Vehicule.getVehicule(null, additional);
                            this.vehicleUsed.add(new VehicleUsed(0, driver.getCleConducteur(), used.getCleVehicule(), beginDateTime, endDateTime, 0, 0, km, false, 0, driver.getNom(), driver.getPrenom(), driver.getNumeroCarte(), used.getRegistrationNumber(), VehicleUsed.SOURCE_IMPORT));
                        }
                        catch (DBObjectNotFoundException ex) {
                            if (!this.unknownRegistrationNumber.contains(additional)) {
                                TimsLogger.warn("#IAC.convertContent# " + additional + " not found");
                                this.unknownRegistrationNumber.add(additional);
                            }
                        }
                    }
                }
                catch (DriverNotFoundException ex) {
                    if (!this.unknownRegistrationNumber.contains(matricule)) {
                        TimsLogger.warn("#IAC.convertContent# " + matricule + " not found");
                        this.unknownRegistrationNumber.add(matricule);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TimsLogger.warn("#IAC.convertContent# error on " + this.content.get(x)[0] + " " + this.content.get(x)[1] + " " + this.content.get(x)[2]);
                }
            }
            ++x;
        }
        TimsLogger.debug("#IAC.convertContent# " + this.driverDays + " jours \u00e0 traiter");
        if (Transport.debug >= 1) {
            for (Jour oneDay : this.driverDays) {
                oneDay.affiche();
            }
        }
        return 1;
    }

    public int checkContent() {
        TimsLogger.debug("#IAC.checkContent# Checking " + this.driverPeriod.size() + " periods");
        for (String[] toCheck : this.driverPeriod) {
            TimsLogger.debug("#IAC.checkContent# Checking period " + toCheck[0] + " " + toCheck[1] + " " + toCheck[2] + " " + toCheck[3]);
            int checkId = Integer.parseInt(toCheck[0]);
            int endToCheck = Integer.parseInt(toCheck[3]);
            try {
                Conducteur driver = Conducteur.getDriver(null, checkId);
                Vector<Jour> existings = BddTransport.getInstance().getJourNew(checkId, toCheck[1], toCheck[2], 1, false);
                Vector<LienJourConducteur> existingDays = LienJourConducteur.loadList(0, checkId, ConversionTime.stringToDateDb(toCheck[1]), ConversionTime.stringToDateDb(toCheck[2]));
                TimsLogger.debug("#IAC.checkContent# " + driver.getLibelle() + " => dernier telechargement " + driver.getDernierTelechargement() + ", " + existings.size() + "jours existants dans la base ");
                Date lastDl = ConversionTime.stringToDateDb(driver.getDernierTelechargement(), true);
                Date lastActivity = ConversionTime.stringToDateDb(String.valueOf(toCheck[2]) + " " + ConversionTime.heureIntToString(endToCheck, ":") + ":00", true);
                if (lastDl.before(lastActivity)) {
                    TimsLogger.debug(String.valueOf(driver.getNom()) + " " + driver.getPrenom() + " not downloaded");
                    this.currentImport.getWarnings().add(new DriverDownloadWarning(0, 0, driver.getCleConducteur(), lastDl, lastActivity));
                }
                for (Jour existingActivity : existings) {
                    for (Jour curDay : this.driverDays) {
                        if (curDay.getDriverId() != existingActivity.getDriverId() || !curDay.getDate().equals(existingActivity.getDate())) continue;
                        TimsLogger.debug("Compare ");
                        curDay.affiche();
                        existingActivity.affiche();
                        int overruning = Fonctions.findOverrunActivities(existingActivity.getActivity(), curDay.getActivity());
                        if (overruning == 0) continue;
                        TimsLogger.debug("Bug a boo act/act for " + existingActivity.getDriverId() + " on " + curDay.getDate() + " (" + overruning + ")");
                        this.currentImport.getAnomalies().add(new DriverDayAnomaly(0, 0, existingActivity.getDriverId(), ConversionTime.stringToDateDb(curDay.getDate()), overruning, existingActivity.getActivity(), curDay.getActivity(), ProcessType.MERGE));
                    }
                    for (LienJourConducteur miss : this.driverMissings) {
                        if (miss.getType() != 2 || miss.getCleConducteur() != existingActivity.getDriverId() || !ConversionTime.dateToStringDb(miss.getDateJour()).equals(existingActivity.getDate())) continue;
                        TimsLogger.debug("Bug a boo act/miss for " + miss.getCleConducteur() + " on " + miss.getDateJour());
                        this.currentImport.getAnomalies().add(new DriverDayAnomaly(0, 0, existingActivity.getDriverId(), miss.getDateJour(), 0, existingActivity.getActivity(), miss.getCleJourType(), ProcessType.MERGE));
                    }
                }
                for (LienJourConducteur day : existingDays) {
                    if (day.getType() != 2) continue;
                    for (Jour curDay : this.driverDays) {
                        if (curDay.getDriverId() != day.getCleConducteur() || !curDay.getDate().equals(ConversionTime.dateToStringDb(day.getDateJour()))) continue;
                        TimsLogger.debug("Bug a boo miss/act on for " + day.getCleConducteur() + " on " + curDay.getDate());
                        this.currentImport.getAnomalies().add(new DriverDayAnomaly(0, 0, curDay.getDriverId(), day.getDateJour(), 0, day.getCleJourType(), curDay.getActivity(), ProcessType.MERGE));
                    }
                    for (LienJourConducteur miss : this.driverMissings) {
                        if (miss.getType() != 2 || !miss.getDateJour().equals(day.getDateJour()) || miss.getCleConducteur() != day.getCleConducteur()) continue;
                        TimsLogger.debug("Bug a boo miss/miss for " + day.getCleConducteur() + " on " + miss.getDateJour());
                        this.currentImport.getAnomalies().add(new DriverDayAnomaly(0, 0, day.getCleConducteur(), miss.getDateJour(), 0, day.getCleJourType(), miss.getCleJourType(), ProcessType.MERGE));
                    }
                }
            }
            catch (DriverNotFoundException ex) {
                TimsLogger.debug("#IAC.checkContent# no driver found " + checkId);
            }
            catch (Exception ex) {
                TimsLogger.debug("#Uncatched error#");
                ex.printStackTrace();
            }
        }
        return 1;
    }

    public int checkFileStructure() {
        CsvReading csvParser = new CsvReading(this.file.getAbsolutePath());
        while (csvParser.nextLine()) {
            String[] line = csvParser.getLine();
            this.content.add(line);
            if (line.length < 5 || line.length > 7) {
                TimsLogger.error("#ImportActivityController.checkFileStructure# bad line content length");
                return 0;
            }
            if (!this.checkDateValue(line[1]) || !this.checkDateValue(line[3])) {
                TimsLogger.error("#ImportActivityController.checkFileStructure# bad date format");
                return 0;
            }
            if (!this.checkHourValue(line[2]) || !this.checkHourValue(line[4])) {
                TimsLogger.error("#ImportActivityController.checkFileStructure# bad hour format");
                return 0;
            }
            if (line.length <= 6 || line[6].matches("^\\p{Digit}+$")) continue;
            TimsLogger.error("#ImportActivityController.checkFileStructure# bad kilometer format");
            return 0;
        }
        return 1;
    }

    private boolean checkHourValue(String string) {
        return true;
    }

    private boolean checkDateValue(String string) {
        return true;
    }

    public boolean save() {
        LienJourConducteur tmp;
        boolean shouldInsert;
        int counter;
        block18: {
            this.pg.setVisible(true);
            this.pg.setMaximum(this.driverDays.size() + this.driverPeriod.size());
            TimsLogger.debug("#ImportActivityController.save()# start saving");
            Transport.bdd.startTransaction();
            int random = (int)(Math.random() * 1000.0);
            String dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
            while (new File(dayFn).exists()) {
                random = (int)(Math.random() * 1000.0);
                dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
            }
            FileWriter fluxDay = new FileWriter(dayFn);
            counter = 0;
            for (Jour toSave : this.driverDays) {
                this.pg.setValues(++counter, "enregistrement de " + Conducteur.getDriverLibelle(toSave.getDriverId()));
                TimsLogger.debug(String.valueOf(toSave.getActivity().size()) + " initial activities on " + toSave.getDate() + " " + Conducteur.getDriverLibelle(toSave.getDriverId()));
                shouldInsert = true;
                for (DriverDayAnomaly ano : this.currentImport.getAnomalies()) {
                    if (ano.getDriverId() != toSave.getDriverId() || !ConversionTime.stringToDateDb(toSave.getDate()).equals(ano.getAnomalyDay())) continue;
                    if (ano.getProcess().equals((Object)ProcessType.MERGE)) {
                        TimsLogger.debug("#IAC.save# had to merge " + toSave.getDate() + " " + Conducteur.getDriverLibelle(ano.getDriverId()));
                        Vector<ActiviteConducteur> toReplace = Fonctions.mergeForImport(ano);
                        if (toReplace != null) {
                            toSave.setActivity(toReplace);
                            toSave.updateTime();
                        }
                    }
                    if (ano.getProcess().equals((Object)ProcessType.IGNORE)) {
                        shouldInsert = false;
                        break;
                    }
                    if (ano.getInitialDayType() == 0) break;
                    TimsLogger.debug("#IAC.save# must delete missing on " + toSave.getDate() + " for " + Conducteur.getDriverLibelle(ano.getDriverId()));
                    tmp = new LienJourConducteur();
                    if (!tmp.load(toSave.getDriverId(), new Timestamp(ConversionTime.stringToDateDb(toSave.getDate()).getTime()))) break;
                    tmp.delete();
                    break;
                }
                if (!shouldInsert) continue;
                Transport.bdd.delJour(toSave.getDriverId(), toSave.getDate());
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                fluxDay.write(toSave.getSQLInsert());
                fluxDay.write("\n");
            }
            TimsLogger.debug("#IAC.save# activities saved");
            fluxDay.close();
            if (Transport.bdd.loadDay(dayFn)) break block18;
            TimsLogger.error("#IAC.save# Error saving day");
            Transport.bdd.rollback();
            return false;
        }
        try {
            for (LienJourConducteur missing : this.driverMissings) {
                shouldInsert = true;
                for (DriverDayAnomaly ano : this.currentImport.getAnomalies()) {
                    if (ano.getDriverId() != missing.getCleConducteur() || !missing.getDateJour().equals(ano.getAnomalyDay())) continue;
                    if (ano.getProcess().equals((Object)ProcessType.MERGE)) {
                        TimsLogger.debug("#IAC.save# merge missing");
                        break;
                    }
                    if (ano.getProcess().equals((Object)ProcessType.IGNORE)) {
                        TimsLogger.debug("#IAC.save# ignore missing");
                        shouldInsert = false;
                        break;
                    }
                    TimsLogger.debug("#IAC.save# replace missing");
                    if (ano.getInitial() != null) {
                        Transport.bdd.delJour(missing.getCleConducteur(), ConversionTime.dateToStringDb(missing.getDateJour()));
                        break;
                    }
                    tmp = new LienJourConducteur();
                    if (!tmp.load(missing.getCleConducteur(), new Timestamp(missing.getDateJour().getTime()))) break;
                    tmp.delete();
                    break;
                }
                if (!shouldInsert) continue;
                missing.insert();
            }
            for (VehicleUsed used : this.vehicleUsed) {
                used.insert("driver_vehicle_used");
            }
            for (String[] toCalculate : this.driverPeriod) {
                try {
                    Conducteur current = Conducteur.getDriver(null, Integer.parseInt(toCalculate[0]));
                    this.pg.setValues(++counter, "calcul de " + current.getLibelle());
                    Fonctions.reloadService(current.getCleConducteur(), toCalculate[1], toCalculate[2]);
                    Fonctions.offenceCalculation(current, ConversionTime.stringToDateDb(toCalculate[1]), ConversionTime.stringToDateDb(toCalculate[2]), false);
                    Date lastDl = ConversionTime.stringToDateDb(current.getDernierTelechargement(), true);
                    Date lastActivity = ConversionTime.stringToDateDb(String.valueOf(toCalculate[2]) + " " + ConversionTime.heureIntToString(toCalculate[3], ":") + ":00", true);
                    if (!lastDl.before(lastActivity)) continue;
                    String toSet = String.valueOf(ConversionTime.addDay(toCalculate[2], "yyyy-MM-dd", 1)) + " 00:00:00";
                    TimsLogger.error("#ImportActivityController.save# update last change for " + current.getLibelle() + " (was " + current.getDernierChangement() + ", now " + toSet + ")");
                    current.compareAndUpdateLastImport(toSet);
                }
                catch (Exception ex) {
                    TimsLogger.error("#ImportActivityController.save# unknown driver " + toCalculate[0]);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            TimsLogger.error("#ImportActivityController.save# unknown error");
            Transport.bdd.rollback();
            ex.printStackTrace();
            return false;
        }
        this.currentImport.setState(ImportActivity.Status.INTEGRATED);
        this.currentImport.setIntegrationDate(new Date());
        this.currentImport.insert();
        Transport.bdd.commit();
        this.pg.setVisible(false);
        return true;
    }
}

