/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.core;

import fr.pgh.data.bdd.Societe;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.watcher.DirectoryWatcher;
import transpo.system.util.watcher.FileListener;

public class ServerCore {
    private static SimpleHTTPServer server = null;
    private static ArrayList<DirectoryWatcher> watchers = new ArrayList();

    public static void main(String[] args) {
        ServerCore.start(args);
    }

    public static void start(String[] args) {
        TimsLogger.info("#ServerCore# Launching TIMS-SERVER");
        Transport.getArgs(args, "api=1");
        Transport.init();
        new ServerCore();
    }

    public static void stop() {
        TimsLogger.info("#ServerCore# Shutdown TIMS-SERVER");
        server.stop();
        for (DirectoryWatcher dw : watchers) {
            dw.stop();
        }
    }

    public ServerCore() {
        this.launchWatchers();
        this.launchWSServer();
        this.launchRemoteDownloader();
    }

    private void launchRemoteDownloader() {
    }

    private void launchWatchers() {
        TimsLogger.info("#ServerCore# (BEGIN) directory watchers");
        Vector<Societe> tmp = Societe.loadList(null);
        for (Societe current : tmp) {
            if (current.getFtpDirectory() == null || current.getFtpDirectory().equals("")) continue;
            String[] stringArray = current.getFtpDirectory().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                TimsLogger.info("#ServerUI#creating watcher for " + current.getNomSociete() + " on " + dir);
                File root = new File(dir);
                File[] fileArray = root.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File child = fileArray[n4];
                    if (child.isDirectory()) {
                        DirectoryWatcher dw = new DirectoryWatcher(current, child.getAbsolutePath(), 5, false);
                        dw.addListener(new FileListener(current));
                        dw.start();
                        watchers.add(dw);
                    }
                    ++n4;
                }
                DirectoryWatcher dw = new DirectoryWatcher(current, dir, 5, false);
                dw.addListener(new FileListener(current));
                dw.start();
                watchers.add(dw);
                ++n2;
            }
        }
        TimsLogger.info("#ServerCore# (DONE) directory watchers");
    }

    private void launchWSServer() {
        TimsLogger.info("#ServerCore# (BEGIN) launchWSServer");
        try {
            ConfigurationContext context = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)"ws\\WEB-INF\\", (String)"ws\\WEB-INF\\conf\\axis2.xml");
            int serverPort = Integer.parseInt(System.getProperty("SERVER_PORT", "8080"));
            server = new SimpleHTTPServer(context, serverPort);
            server.start();
        }
        catch (Exception ex) {
            TimsLogger.error("Unable to launch TIMS WS... " + ex.getMessage());
            ex.printStackTrace();
        }
        TimsLogger.info("#ServerCore# (DONE) launchWSServer");
    }
}

