/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.exp;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.PayPeriod;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.exp.PayPeriodCloser;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogExportError;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;

public class ActivityToCcmx
extends PayPeriodCloser {
    public static final String SUFFIX = "xxxyy.txt";
    public static final String HEUXXXYY = "HEU";
    public static final String ABSXXXYY = "ABS";
    public static final String ELVXXXYY = "ELV";
    private PrintWriter heuxxxyy = null;
    private PrintWriter absxxxyy = null;
    private PrintWriter elvxxxyy = null;
    private DecimalFormat df = null;
    private String transferResult = null;
    double heuCheckSum = 0.0;
    int heuTotalLines = 0;
    double absCheckSum = 0.0;
    int absTotalLines = 0;
    double elvCheckSum = 0.0;
    int elvTotalLines = 0;
    public static String companyCode = System.getProperty("company_code", "BAT");

    public ActivityToCcmx(Vector<Agence> agencies, PayPeriod payPeriodToExport) {
        TimsLogger.debug("#ActivityToCcmx# Export " + agencies.size() + " agencies on " + payPeriodToExport.getName());
        this.agencies = agencies;
        this.toClose = payPeriodToExport;
    }

    @Override
    public void run() {
        this.init();
        for (Agence agency : this.notYetClosed) {
            this.globalErrors.putAll(this.checkingDataProcess(agency));
        }
        if (this.globalErrors.size() != 0) {
            TimsLogger.debug("#ActivityToCcmx.run# Errors : " + this.globalErrors);
            DialogExportError tmp = new DialogExportError(MainFrameTransport.getInstance());
            tmp.setDatas(this.globalErrors);
            tmp.setVisible(true);
            this.status = 0;
            return;
        }
        int x = 0;
        x = this.exportProcess(this.agencies);
        if (x == 1) {
            for (Agence agency : this.notYetClosed) {
                this.toClose.close(agency.getCleAgence());
            }
            this.status = 1;
        } else {
            this.status = x;
        }
        new File(HEUXXXYY).delete();
        new File(ABSXXXYY).delete();
        new File(ELVXXXYY).delete();
    }

    /*
     * Unable to fully structure code
     */
    public HashMap<Conducteur, ArrayList<Date>> checkingDataProcess(Agence agency) {
        toReturn = new HashMap<Conducteur, ArrayList<Date>>();
        this.pg.getBar().setToolTipText(LanguageTranslator.getString("generics.checking", new String[]{agency.getDescription()}));
        drivers = Conducteur.loadList(new Integer[]{agency.getCleAgence()});
        tmpS = Service.getService(agency.getCleAgence(), 0, this.toClose.getBegin(), this.toClose.getEnd());
        tmpL = LienJourConducteur.loadList(agency.getCleAgence(), 0, this.toClose.getBegin(), this.toClose.getEnd());
        currentDriver = null;
        this.pg.getBar().setMaximum(drivers.size());
        this.pg.getBar().setMinimum(0);
        x = 0;
        while (x < drivers.size()) {
            currentDriver = drivers.get(x);
            check = true;
            if (currentDriver.getMatricule() == null || currentDriver.getMatricule().equals("")) {
                check = false;
            }
            this.pg.getBar().setString(String.valueOf(agency.getDescription()) + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
            this.pg.getBar().setValue(this.pg.getBar().getValue() + 1);
            errorList = new ArrayList<Date>();
            tmpC = null;
            if (currentDriver.getCalendarId() != 0) {
                tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.toClose.getBegin(), this.toClose.getEnd());
            }
            serviceLeft = true;
            ljcLeft = true;
            day = this.toClose.getBegin();
            while (day.compareTo(this.toClose.getEnd()) <= 0) {
                block15: {
                    dayFound = false;
                    if (serviceLeft && tmpS.size() != 0) {
                        if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                            serviceLeft = false;
                        } else if (day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                            dayFound = true;
                            tmpS.remove(0);
                            if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                tmpS.remove(0);
                            }
                        }
                    }
                    if (!ljcLeft || tmpL.size() == 0) break block15;
                    if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl44
                    ljcLeft = false;
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        dayFound = true;
                        tmpL.remove(0);
lbl44:
                        // 2 sources

                        ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                    }
                }
                if (tmpC != null) {
                    y = 0;
                    while (y < tmpC.size()) {
                        if (day.equals(tmpC.get(y).getDate())) {
                            toAdd = new LienJourConducteur();
                            toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                            dayFound = true;
                            tmpC.remove(y);
                            break;
                        }
                        ++y;
                    }
                }
                if (!dayFound && check && !ConversionTime.isWE(day)) {
                    errorList.add(day);
                }
                day = ConversionTime.addDay(day, 1);
            }
            if (errorList.size() != 0) {
                toReturn.put(currentDriver, errorList);
            }
            ++x;
        }
        this.pg.dispose();
        TimsLogger.debug("#ATCCMX.CheckingDataProcess# return " + toReturn);
        return toReturn;
    }

    public int exportProcess(Vector<Agence> agenciesToExport) {
        ProgressBar pg = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("generics.export"));
        pg.setVisible(true);
        pg.getBar().setToolTipText(LanguageTranslator.getString("generics.initialization"));
        try {
            String regionCode = agenciesToExport.get(0).getRegionId() == 0 ? "UNK" : Region.find(Region.loadList(0), agenciesToExport.get(0).getRegionId()).getCode();
            String dynSuffix = SUFFIX.replace("xxx", companyCode).replace("yy", regionCode);
            this.heuxxxyy = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(Transport.savePath) + HEUXXXYY + dynSuffix, false)));
            this.absxxxyy = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(Transport.savePath) + ABSXXXYY + dynSuffix, false)));
            this.elvxxxyy = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(Transport.savePath) + ELVXXXYY + dynSuffix, false)));
            this.df = new DecimalFormat("##.00");
            for (Agence agency : agenciesToExport) {
                Vector<Conducteur> list = Conducteur.loadList(agency.getCleAgence());
                pg.getBar().setMaximum(list.size());
                pg.getBar().setMinimum(0);
                for (Conducteur driver : list) {
                    if (driver.getMatricule() == null || driver.getMatricule().equals("")) continue;
                    pg.getBar().setString(String.valueOf(driver.getNom()) + " " + driver.getPrenom());
                    pg.getBar().setValue(pg.getBar().getValue() + 1);
                    driver.affiche();
                    this.exportActivities(driver, this.toClose);
                    this.exportDays(driver, this.toClose);
                    this.exportExpenses(driver, this.toClose);
                }
            }
            String sHeuTotalLines = String.valueOf(this.heuTotalLines);
            String sHeuCheckSum = this.df.format(this.heuCheckSum);
            while (sHeuTotalLines.length() < 6) {
                sHeuTotalLines = "0" + sHeuTotalLines;
            }
            while (sHeuCheckSum.length() < 21) {
                sHeuCheckSum = "0" + sHeuCheckSum;
            }
            this.heuxxxyy.write("09" + sHeuTotalLines + sHeuCheckSum.replace(",", ""));
            String sAbsTotalLines = String.valueOf(this.absTotalLines);
            String sAbsCheckSum = this.df.format(this.absCheckSum);
            while (sAbsTotalLines.length() < 6) {
                sAbsTotalLines = "0" + sAbsTotalLines;
            }
            while (sAbsCheckSum.length() < 21) {
                sAbsCheckSum = "0" + sAbsCheckSum;
            }
            this.absxxxyy.write("09" + sAbsTotalLines + sAbsCheckSum.replace(",", ""));
            String sElvTotalLines = String.valueOf(this.elvTotalLines);
            String sElvCheckSum = this.df.format(this.elvCheckSum);
            while (sElvTotalLines.length() < 6) {
                sElvTotalLines = "0" + sElvTotalLines;
            }
            while (sElvCheckSum.length() < 21) {
                sElvCheckSum = "0" + sElvCheckSum;
            }
            this.elvxxxyy.write("09" + sElvTotalLines + sElvCheckSum.replace(",", ""));
            this.heuxxxyy.close();
            this.absxxxyy.close();
            this.elvxxxyy.close();
            pg.getBar().setString(LanguageTranslator.getString("ftp.transfer"));
            String transfer = Fonctions.FTPTransfer(new File(HEUXXXYY + dynSuffix), new File(ABSXXXYY + dynSuffix), new File(ELVXXXYY + dynSuffix));
            if (transfer == null || !transfer.equals("")) {
                this.transferResult = transfer;
                pg.dispose();
                return 32;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            pg.dispose();
            return 16;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            pg.dispose();
            return 16;
        }
        pg.dispose();
        return 1;
    }

    public void exportActivities(Conducteur driver, PayPeriod payPeriod) throws Exception {
        Vector<ActiviteConducteur> activities = BddTransport.getInstance().getActivite(driver.getCleConducteur(), payPeriod.getBegin(), payPeriod.getEnd(), -1, 0);
        ActiviteConducteur begin = null;
        int rest = 0;
        int sequenceCpt = 1;
        for (ActiviteConducteur activity : activities) {
            TypeActivite activityType = TypeActivite.getActivityType(activity.getCleType());
            if (activityType.getPaidPercentage() != 0) {
                rest = 0;
                if (begin != null) continue;
                begin = activity;
            }
            if (activityType.getPaidPercentage() != 0) continue;
            if (begin != null) {
                String beginTime = this.df.format((double)begin.getHeureDebut() / 60.0);
                String endTime = this.df.format((double)activity.getHeureDebut() / 60.0);
                int time = activity.getHeureDebut() - begin.getHeureDebut();
                String totalTime = this.df.format((double)(time += ConversionTime.getNbJourBetween(begin.getDateJour(), activity.getDateJour(), "yyyy-MM-dd") * 1440) / 60.0);
                String week = ConversionTime.dateStringToFormat(begin.getDateJour(), "yyyy-MM-dd", "w");
                String dayOfWeek = String.valueOf(ConversionTime.getDayOfWeek(begin.getDateJour(), "yyyy-MM-dd", true));
                String daySequence = String.valueOf(sequenceCpt);
                ++sequenceCpt;
                while (beginTime.length() < 6) {
                    beginTime = "0" + beginTime;
                }
                while (endTime.length() < 6) {
                    endTime = "0" + endTime;
                }
                while (totalTime.length() < 6) {
                    totalTime = "0" + totalTime;
                }
                while (week.length() < 2) {
                    week = "0" + week;
                }
                while (dayOfWeek.length() < 2) {
                    dayOfWeek = "0" + dayOfWeek;
                }
                while (daySequence.length() < 2) {
                    daySequence = "0" + daySequence;
                }
                this.heuxxxyy.write("06" + companyCode + driver.getMatricule() + ConversionTime.dateStringToFormat(begin.getDateJour(), "yyyy-MM-dd", "yyyyMMdd") + daySequence + "08" + payPeriod.getName() + "000" + beginTime.replace(",", "") + endTime.replace(",", "") + totalTime.replace(",", "") + week + dayOfWeek + "  " + "  " + "              \r\n");
                this.heuCheckSum += (double)time / 60.0;
                ++this.heuTotalLines;
                begin = null;
            }
            if ((rest += activity.getDuree()) < 420) continue;
            rest = 0;
            sequenceCpt = 1;
        }
    }

    public void exportDays(Conducteur driver, PayPeriod payPeriod) throws Exception {
        Vector<LienJourConducteur> days = LienJourConducteur.loadList(0, driver.getCleConducteur(), payPeriod.getBegin(), payPeriod.getEnd());
        int sequenceCpt = 1;
        int defaultDayLength = 0;
        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
            try {
                TypeContrat driverContract = TypeContrat.getTypeContrat(driver.getCleTypeContrat());
                defaultDayLength = driverContract.getDailyValue();
            }
            catch (Exception ex) {
                TimsLogger.warn("pas de contrat trouv\u00e9 pour " + driver.getNom());
                ex.printStackTrace();
            }
        }
        for (LienJourConducteur day : days) {
            String typeAbs;
            day.affiche();
            JourType jourType = JourType.getDayType(day.getCleJourType());
            String beginTime = this.df.format((double)day.getHeureDebut() / 60.0);
            String endTime = this.df.format((double)day.getHeureFin() / 60.0);
            String totalTime = this.df.format((double)day.getDuree(defaultDayLength) / 60.0);
            String week = ConversionTime.dateToString(day.getDateJour(), "w");
            String dayOfWeek = String.valueOf(ConversionTime.getDayOfWeek(day.getDateJour(), true));
            String absSequence = String.valueOf(sequenceCpt);
            String codeAbs = jourType.getCode();
            String string = typeAbs = day.getType() == 2 ? "J" : "D";
            if (day.getType() == 0) {
                typeAbs = "H";
            }
            ++sequenceCpt;
            while (beginTime.length() < 6) {
                beginTime = "0" + beginTime;
            }
            while (endTime.length() < 6) {
                endTime = "0" + endTime;
            }
            while (totalTime.length() < 6) {
                totalTime = "0" + totalTime;
            }
            while (week.length() < 2) {
                week = "0" + week;
            }
            while (dayOfWeek.length() < 2) {
                dayOfWeek = "0" + dayOfWeek;
            }
            while (absSequence.length() < 2) {
                absSequence = "0" + absSequence;
            }
            while (codeAbs.length() < 3) {
                codeAbs = "0" + codeAbs;
            }
            this.absxxxyy.write("06" + companyCode + driver.getMatricule() + ConversionTime.dateToString(day.getDateJour(), "yyyyMMdd") + absSequence + "08" + payPeriod.getName() + codeAbs + typeAbs + beginTime.replace(",", "") + endTime.replace(",", "") + totalTime.replace(",", "") + week + dayOfWeek + "              \r\n");
            this.absCheckSum += (double)day.getDuree(defaultDayLength) / 60.0;
            ++this.absTotalLines;
        }
        Vector<GlobalCalendarDay> tmpC = null;
        if (driver.getCalendarId() != 0) {
            tmpC = GlobalCalendarDay.loadList(driver.getCalendarId(), this.toClose.getBegin(), this.toClose.getEnd());
        }
        if (tmpC != null) {
            for (GlobalCalendarDay day : tmpC) {
                try {
                    JourType jourType = JourType.getDayType(day.getDayTypeId());
                    String beginTime = "0.00";
                    String endTime = "0.00";
                    String totalTime = this.df.format((double)jourType.getService() / 60.0);
                    String week = ConversionTime.dateToString(day.getDate(), "w");
                    String dayOfWeek = String.valueOf(ConversionTime.getDayOfWeek(day.getDate(), true));
                    String absSequence = String.valueOf(sequenceCpt);
                    String codeAbs = jourType.getCode();
                    ++sequenceCpt;
                    while (beginTime.length() < 6) {
                        beginTime = "0" + beginTime;
                    }
                    while (endTime.length() < 6) {
                        endTime = "0" + endTime;
                    }
                    while (totalTime.length() < 6) {
                        totalTime = "0" + totalTime;
                    }
                    while (week.length() < 2) {
                        week = "0" + week;
                    }
                    while (dayOfWeek.length() < 2) {
                        dayOfWeek = "0" + dayOfWeek;
                    }
                    while (absSequence.length() < 2) {
                        absSequence = "0" + absSequence;
                    }
                    while (codeAbs.length() < 3) {
                        codeAbs = "0" + codeAbs;
                    }
                    this.absxxxyy.write("06" + companyCode + driver.getMatricule() + ConversionTime.dateToString(day.getDate(), "yyyyMMdd") + absSequence + "08" + " " + payPeriod.getName() + codeAbs + "J" + beginTime.replace(",", "") + endTime.replace(",", "") + totalTime.replace(",", "") + week + dayOfWeek + "              \r\n");
                    this.absCheckSum += (double)jourType.getService() / 60.0;
                    ++this.absTotalLines;
                }
                catch (DayTypeNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void exportExpenses(Conducteur driver, PayPeriod payPeriod) throws Exception {
        Vector<DriverExpenses> driverExpenses = DriverExpenses.loadList(0, driver.getCleConducteur(), payPeriod.getBegin(), payPeriod.getEnd());
        int sequenceCpt = 1;
        for (DriverExpenses driverExpense : driverExpenses) {
            ExpensesType exp = ExpensesType.getExpenses(driverExpense.getExpensesId());
            driverExpense.affiche();
            String base = this.df.format(driverExpense.getBase());
            String rate = this.df.format(driverExpense.getRate());
            String amount = this.df.format(driverExpense.getAmount());
            String week = ConversionTime.dateToString(driverExpense.getDate(), "w");
            String dayOfWeek = String.valueOf(ConversionTime.getDayOfWeek(driverExpense.getDate(), true));
            String codeExp = exp.getCode();
            String elvSequence = String.valueOf(sequenceCpt);
            ++sequenceCpt;
            while (elvSequence.length() < 2) {
                elvSequence = "0" + elvSequence;
            }
            while (base.length() < 11) {
                base = "0" + base;
            }
            while (rate.length() < 11) {
                rate = "0" + rate;
            }
            while (amount.length() < 11) {
                amount = "0" + amount;
            }
            while (week.length() < 2) {
                week = "0" + week;
            }
            while (dayOfWeek.length() < 2) {
                dayOfWeek = "0" + dayOfWeek;
            }
            while (codeExp.length() < 4) {
                codeExp = "0" + codeExp;
            }
            this.elvxxxyy.write("06" + companyCode + driver.getMatricule() + ConversionTime.dateToString(driverExpense.getDate(), "yyyyMMdd") + codeExp + elvSequence + "08" + payPeriod.getName() + base.replace(",", "") + rate.replace(",", "") + amount.replace(",", "") + week + dayOfWeek + "              \r\n");
            this.elvCheckSum += (double)driverExpense.getAmount();
            ++this.elvTotalLines;
        }
    }
}

