/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Garage;
import fr.pgh.data.bdd.ImportField;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.DataReader;
import transpo.system.imp.util.ExcelReader;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class AccidentImport
extends AbstractAutomaticWarning {
    private DataReader reader = null;
    private final String MODULE = "ACCIDENT";
    HashMap<String, String> field = null;
    ArrayList<String> trn_responsability = new ArrayList();
    ArrayList<String> trn_type = new ArrayList();
    ArrayList<String> trn_open = new ArrayList();
    private int IDX_AGENCY_NAME = -1;
    private int IDX_AGENCY_CODE = -1;
    private int IDX_IMMATRICULATION = -1;
    private int IDX_VEHICLE_ID = -1;
    private int IDX_VEHICLE_CODE = -1;
    private int IDX_DRIVER_CODE = -1;
    private int IDX_DRIVER_ID = -1;
    private int IDX_DRIVER_FIRST_NAME = -1;
    private int IDX_DRIVER_LAST_NAME = -1;
    private int IDX_NUMBER = -1;
    private int IDX_INSURANCE_NUMBER = -1;
    private int IDX_DATE = -1;
    private int IDX_PLACE = -1;
    private int IDX_DESCRIPTION = -1;
    private int IDX_RESPONSABILITY = -1;
    private int IDX_TYPE = -1;
    private int IDX_STEAL = -1;
    private int IDX_BIG_DAMAGES = -1;
    private int IDX_TOWING = -1;
    private int IDX_OPENED = -1;
    private int IDX_IN_TRAFFIC = -1;
    private int IDX_INSURANCE_TYPE = -1;
    private int IDX_INSURANCE_CODE = -1;
    private int IDX_CONVENTION_TYPE = -1;
    private int IDX_GARAGE_ID = -1;
    private int IDX_GARAGE_CODE = -1;
    private int IDX_GARAGE_NAME = -1;
    private int IDX_GRARAGE_ENTRY = -1;
    private int IDX_GRARAGE_OUT = -1;
    private int IDX_RC_COST = -1;
    private int IDX_RC_EXCESS = -1;
    private int IDX_INSURANCE_RECOURSE = -1;
    private int IDX_COMPANY_RECOURSE = -1;
    private int IDX_DAMAGE_EXCESS = -1;
    private int IDX_VAT = -1;
    private int IDX_DILAPIDATION = -1;
    private int IDX_SELF_INSURANCE = -1;
    private int IDX_EXPERT_COST = -1;
    private int IDX_FIXING_COST = -1;
    private int IDX_COMPANY_FIXING_COST = -1;
    private int IDX_LOCATION_DEBT = -1;
    private int IDX_COMPANY_LOCATION_DEBT = -1;
    private int IDX_GUARDING = -1;
    private int IDX_TOTAL_COST = -1;
    private int IDX_TOTAL_INSURANCE = -1;

    @Override
    public void execute() {
        int ignored;
        int agencyCreated;
        int updated;
        int created;
        block27: {
            TimsLogger.debug("#AccidentImport.process# Enter module");
            this.field = ImportField.loadHashMap("ACCIDENT");
            this.loadTranscription();
            if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
                TimsLogger.warn("#AccidentImport.process# Missing parameters for AccidentImport (ACCIDENT), can't continue");
                return;
            }
            String unknow = LanguageTranslator.getString("generics.unknown");
            created = 0;
            updated = 0;
            boolean unchanged = false;
            agencyCreated = 0;
            boolean typeCreated = false;
            boolean affectationCreated = false;
            boolean acCreated = false;
            boolean bodyCreated = false;
            boolean modelCreated = false;
            ignored = 0;
            BddTransport.getInstance().startTransaction();
            try {
                String file = this.field.get("FILENAME");
                String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
                String ext = file.substring(file.indexOf(".") + 1);
                if (ext.equals("xls")) {
                    this.reader = new ExcelReader(file, dateFormat);
                } else if (ext.equals("csv")) {
                    this.reader = new CsvReader(file, dateFormat);
                }
                this.initColmun();
                while (this.reader.next()) {
                    String fDriverLastName;
                    String fImmatriculation;
                    String agencyName = this.IDX_AGENCY_NAME == -1 ? null : this.reader.get(this.IDX_AGENCY_NAME).trim();
                    String agencyCode = this.IDX_AGENCY_CODE == -1 ? null : this.reader.get(this.IDX_AGENCY_CODE).trim();
                    String string = fImmatriculation = this.IDX_IMMATRICULATION == -1 ? null : this.reader.get(this.IDX_IMMATRICULATION).trim();
                    if (fImmatriculation != null) {
                        while (fImmatriculation.startsWith("0")) {
                            fImmatriculation = fImmatriculation.substring(1);
                        }
                    }
                    String fCode = this.IDX_VEHICLE_CODE == -1 ? null : this.reader.get(this.IDX_VEHICLE_CODE).trim();
                    int fVehicleId = this.IDX_VEHICLE_ID == -1 ? -1 : this.reader.getInt(this.IDX_VEHICLE_ID);
                    String fDriverCode = this.IDX_DRIVER_CODE == -1 ? null : this.reader.get(this.IDX_DRIVER_CODE).trim();
                    String fDriverFirstName = this.IDX_DRIVER_FIRST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_FIRST_NAME).trim();
                    String string2 = fDriverLastName = this.IDX_DRIVER_LAST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_LAST_NAME).trim();
                    if (this.IDX_DRIVER_FIRST_NAME == this.IDX_DRIVER_LAST_NAME && fDriverFirstName != null && !fDriverFirstName.equals("")) {
                        String[] names = fDriverFirstName.split(" ");
                        fDriverLastName = names[0];
                        fDriverFirstName = fDriverFirstName.substring(fDriverLastName.length());
                        TimsLogger.debug("fDriverFirstName " + fDriverFirstName + " fDriverLastName" + fDriverLastName);
                    }
                    int fDriverId = this.IDX_DRIVER_ID == -1 ? -1 : this.reader.getInt(this.IDX_DRIVER_ID);
                    String fNumber = this.IDX_NUMBER == -1 ? null : this.reader.get(this.IDX_NUMBER);
                    String iNumber = this.IDX_INSURANCE_NUMBER == -1 ? null : this.reader.get(this.IDX_INSURANCE_NUMBER);
                    Date date = this.IDX_DATE == -1 ? null : this.reader.getDate(this.IDX_DATE);
                    String fPlace = this.IDX_PLACE == -1 ? unknow : this.reader.get(this.IDX_PLACE);
                    String fDescription = this.IDX_DESCRIPTION == -1 ? unknow : this.reader.get(this.IDX_DESCRIPTION);
                    String fResponsability = this.IDX_RESPONSABILITY == -1 ? null : this.reader.get(this.IDX_RESPONSABILITY);
                    boolean fSteal = this.IDX_STEAL == -1 ? false : this.reader.get(this.IDX_STEAL).equals("1");
                    boolean fBigDamages = this.IDX_BIG_DAMAGES == -1 ? false : this.reader.get(this.IDX_BIG_DAMAGES).equals("1");
                    boolean fTowing = this.IDX_TOWING == -1 ? false : this.reader.get(this.IDX_TOWING).equals("1");
                    String fOpened = this.IDX_OPENED == -1 ? null : this.reader.get(this.IDX_OPENED);
                    String fType = this.IDX_TYPE == -1 ? null : this.reader.get(this.IDX_TYPE);
                    boolean fInTraffic = this.IDX_IN_TRAFFIC == -1 ? false : this.reader.get(this.IDX_IN_TRAFFIC).equals("1");
                    String fInsuranceType = this.IDX_INSURANCE_TYPE == -1 ? null : this.reader.get(this.IDX_INSURANCE_TYPE);
                    String fInsuranceCode = this.IDX_INSURANCE_CODE == -1 ? null : this.reader.get(this.IDX_INSURANCE_CODE);
                    String fConventionType = this.IDX_CONVENTION_TYPE == -1 ? null : this.reader.get(this.IDX_CONVENTION_TYPE);
                    int fGarageId = this.IDX_GARAGE_ID == -1 ? -1 : this.reader.getInt(this.IDX_GARAGE_ID);
                    String fGarageCode = this.IDX_GARAGE_CODE == -1 ? null : this.reader.get(this.IDX_GARAGE_CODE);
                    String fGarageName = this.IDX_GARAGE_NAME == -1 ? null : this.reader.get(this.IDX_GARAGE_NAME);
                    Date fGarageEntry = this.IDX_GRARAGE_ENTRY == -1 ? null : this.reader.getDate(this.IDX_GRARAGE_ENTRY);
                    Date fGarageOut = this.IDX_GRARAGE_OUT == -1 ? null : this.reader.getDate(this.IDX_GRARAGE_OUT);
                    float fRCCost = this.IDX_RC_COST == -1 ? 0.0f : this.reader.getFloat(this.IDX_RC_COST);
                    float fRCExcess = this.IDX_RC_EXCESS == -1 ? 0.0f : this.reader.getFloat(this.IDX_RC_EXCESS);
                    float fInsuranceRecourse = this.IDX_INSURANCE_RECOURSE == -1 ? 0.0f : this.reader.getFloat(this.IDX_INSURANCE_RECOURSE);
                    float fCompanyRecourse = this.IDX_COMPANY_RECOURSE == -1 ? 0.0f : this.reader.getFloat(this.IDX_COMPANY_RECOURSE);
                    float fDamageExcess = this.IDX_DAMAGE_EXCESS == -1 ? 0.0f : this.reader.getFloat(this.IDX_DAMAGE_EXCESS);
                    float fVAT = this.IDX_VAT == -1 ? 0.0f : this.reader.getFloat(this.IDX_VAT);
                    float fDilapidation = this.IDX_DILAPIDATION == -1 ? 0.0f : this.reader.getFloat(this.IDX_DILAPIDATION);
                    float fSelfInsurance = this.IDX_SELF_INSURANCE == -1 ? 0.0f : this.reader.getFloat(this.IDX_SELF_INSURANCE);
                    float fExpertCost = this.IDX_EXPERT_COST == -1 ? 0.0f : this.reader.getFloat(this.IDX_EXPERT_COST);
                    float fFixingCost = this.IDX_FIXING_COST == -1 ? 0.0f : this.reader.getFloat(this.IDX_FIXING_COST);
                    float fCompanyFixingCost = this.IDX_COMPANY_FIXING_COST == -1 ? 0.0f : this.reader.getFloat(this.IDX_COMPANY_FIXING_COST);
                    float fLocationDebt = this.IDX_LOCATION_DEBT == -1 ? 0.0f : this.reader.getFloat(this.IDX_LOCATION_DEBT);
                    float fCompanyLocationDebt = this.IDX_COMPANY_LOCATION_DEBT == -1 ? 0.0f : this.reader.getFloat(this.IDX_COMPANY_LOCATION_DEBT);
                    float fGuarding = this.IDX_GUARDING == -1 ? 0.0f : this.reader.getFloat(this.IDX_GUARDING);
                    float fTotalCost = this.IDX_TOTAL_COST == -1 ? 0.0f : this.reader.getFloat(this.IDX_TOTAL_COST);
                    float fTotalInsurance = this.IDX_TOTAL_INSURANCE == -1 ? 0.0f : this.reader.getFloat(this.IDX_TOTAL_INSURANCE);
                    TimsLogger.debug("Line : agencyName=" + agencyName + ", agencyCode=" + agencyCode + ", fImmatriculation=" + fImmatriculation + ", fCode=" + fCode + ", fDriverCode=" + fDriverCode + ", fDriverFirstName=" + fDriverFirstName + ", fDriverLastName=" + fDriverLastName + ", fNumber=" + fNumber + ", date=" + date + ", fPlace=" + fPlace + ", fDescription=" + fDescription + ", fResponsability=" + fResponsability + ", fSteal=" + fSteal + ", fBigDamages=" + fBigDamages + ", fTowing=" + fTowing + ", fOpened=" + fOpened + ", fType=" + fType + ", fGarageCode=" + fGarageCode + ", fGarageName=" + fGarageName);
                    Accident accident = new Accident();
                    Vehicule vehicle = new Vehicule();
                    Agence agency = new Agence();
                    Conducteur driver = new Conducteur();
                    Garage garage = new Garage();
                    if (!agency.loadByNameOrCode(agencyName, agencyCode)) {
                        agency.setDescription(agencyName == null ? agencyCode : agencyName);
                        agency.setCleInterneAgence(agencyCode);
                        agency.insert();
                        agency.loadByNameOrCode(agencyName, agencyCode);
                        ++agencyCreated;
                    }
                    if (!(fVehicleId != -1 && vehicle.loadById(fVehicleId) || fImmatriculation != null && vehicle.loadByImmat(fImmatriculation, true) || fCode != null && vehicle.loadByCode(fCode))) {
                        if ("0".equals(this.field.get("FORCE_VEHICLE_CREATION"))) {
                            ++ignored;
                            continue;
                        }
                        vehicle.setAgencyId(agency.getCleAgence());
                        vehicle.setRegistrationNumber(fImmatriculation);
                        vehicle.setIdentificationNumber(fCode);
                        if (vehicle.insert()) {
                            ++created;
                        } else {
                            TimsLogger.warn("#AccidentImport.process# Erreur cr\u00e9ation v\u00e9hicule");
                            ++ignored;
                        }
                    }
                    if (!(fDriverCode != null && driver.loadByCode(fDriverCode) || fDriverId != -1 && driver.loadById(fDriverId) || fDriverLastName != null && fDriverFirstName != null && driver.loadByName(fDriverLastName, fDriverFirstName))) {
                        if ("0".equals(this.field.get("FORCE_DRIVER_CREATION"))) {
                            ++ignored;
                            continue;
                        }
                        driver.setCleAgence(agency.getCleAgence());
                        driver.setMatricule(fCode);
                        driver.setPrenom(fDriverFirstName);
                        driver.setNom(fDriverLastName);
                        if (driver.insert()) {
                            ++created;
                        } else {
                            TimsLogger.warn("#AccidentImport.process# Erreur cr\u00e9ation conducteur");
                            ++ignored;
                        }
                    }
                    if (fGarageCode != null && garage.loadByCode(fGarageCode) && fGarageId != -1 && garage.loadById(fGarageId)) {
                        if (!"1".equals(this.field.get("FORCE_GARAGE_CREATION")) || fGarageCode == null && fGarageName == null) {
                            ++ignored;
                            continue;
                        }
                        garage.setCode(fGarageCode);
                        garage.setName(fGarageName);
                        if (garage.insert()) {
                            ++created;
                        } else {
                            TimsLogger.warn("#AccidentImport.process# Erreur cr\u00e9ation garage");
                            ++ignored;
                        }
                    }
                    if (fPlace == null || fPlace.equals("")) {
                        fPlace = unknow;
                    }
                    if (fDescription == null || fDescription.equals("")) {
                        fDescription = unknow;
                    }
                    TimsLogger.debug("Accident " + fNumber + ". Description " + fDescription + " Vehicle " + vehicle.getRegistrationNumber() + ", driver " + driver.getNom() + ". Global Cost : " + fRCCost);
                    accident.compareAndUpdate(fNumber, iNumber, agency.getCleAgence(), driver.getCleConducteur(), vehicle.getCleVehicule(), date, fPlace, this.typeId(fType), false, fSteal, fDescription, fBigDamages, this.responsabilityId(fResponsability), garage.getId(), fGarageEntry, fGarageOut, fTowing, fRCCost, fRCExcess, fInsuranceRecourse, fCompanyRecourse, fDamageExcess, fVAT, fDilapidation, fSelfInsurance, fExpertCost, fFixingCost, fCompanyFixingCost, fLocationDebt, fCompanyLocationDebt, fGuarding, fTotalCost, fTotalInsurance, this.openId(fOpened) == 1, fInTraffic, fInsuranceType, fInsuranceCode, fConventionType, null);
                }
                if (Transport.debug >= 1) {
                    BddTransport.getInstance().rollback();
                } else {
                    BddTransport.getInstance().commit();
                }
            }
            catch (Exception ex) {
                TimsLogger.error("Erreur syst\u00e8me");
                ex.printStackTrace();
                if (Transport.debug != 0) break block27;
                System.exit(1);
            }
        }
        TimsLogger.info("\r\n#Acciedent Import # Final result : " + agencyCreated + " agences cr\u00e9es. " + created + " v\u00e9hicules cr\u00e9es, " + updated + " mis \u00e0 jour (changement ou non), " + ignored + " ignor\u00e9s, ");
    }

    private void initColmun() {
        this.IDX_AGENCY_NAME = Integer.parseInt(this.field.get("IDX_AGENCY_NAME").toString());
        this.IDX_AGENCY_CODE = Integer.parseInt(this.field.get("IDX_AGENCY_CODE").toString());
        this.IDX_IMMATRICULATION = Integer.parseInt(this.field.get("IDX_IMMATRICULATION").toString());
        this.IDX_VEHICLE_ID = Integer.parseInt(this.field.get("IDX_VEHICLE_ID").toString());
        this.IDX_VEHICLE_CODE = Integer.parseInt(this.field.get("IDX_VEHICLE_CODE").toString());
        this.IDX_DRIVER_ID = Integer.parseInt(this.field.get("IDX_DRIVER_ID").toString());
        this.IDX_DRIVER_CODE = Integer.parseInt(this.field.get("IDX_DRIVER_CODE").toString());
        this.IDX_DRIVER_FIRST_NAME = Integer.parseInt(this.field.get("IDX_DRIVER_FIRST_NAME").toString());
        this.IDX_DRIVER_LAST_NAME = Integer.parseInt(this.field.get("IDX_DRIVER_LAST_NAME").toString());
        this.IDX_NUMBER = Integer.parseInt(this.field.get("IDX_NUMBER").toString());
        this.IDX_DATE = Integer.parseInt(this.field.get("IDX_DATE").toString());
        this.IDX_PLACE = Integer.parseInt(this.field.get("IDX_PLACE").toString());
        this.IDX_DESCRIPTION = Integer.parseInt(this.field.get("IDX_DESCRIPTION").toString());
        this.IDX_RESPONSABILITY = Integer.parseInt(this.field.get("IDX_RESPONSABILITY").toString());
        this.IDX_TYPE = Integer.parseInt(this.field.get("IDX_TYPE").toString());
        this.IDX_STEAL = Integer.parseInt(this.field.get("IDX_STEAL").toString());
        this.IDX_BIG_DAMAGES = Integer.parseInt(this.field.get("IDX_BIG_DAMAGES").toString());
        this.IDX_TOWING = Integer.parseInt(this.field.get("IDX_TOWING").toString());
        this.IDX_OPENED = Integer.parseInt(this.field.get("IDX_OPENED").toString());
        this.IDX_GARAGE_ID = Integer.parseInt(this.field.get("IDX_GARAGE_ID").toString());
        this.IDX_GARAGE_CODE = Integer.parseInt(this.field.get("IDX_GARAGE_CODE").toString());
        this.IDX_GARAGE_NAME = Integer.parseInt(this.field.get("IDX_GARAGE_NAME").toString());
        this.IDX_GRARAGE_ENTRY = Integer.parseInt(this.field.get("IDX_GARAGE_ENTRY").toString());
        this.IDX_GRARAGE_OUT = Integer.parseInt(this.field.get("IDX_GARAGE_OUT").toString());
        this.IDX_RC_COST = Integer.parseInt(this.field.get("IDX_RC_COST").toString());
        this.IDX_RC_EXCESS = Integer.parseInt(this.field.get("IDX_RC_EXCESS").toString());
        this.IDX_INSURANCE_RECOURSE = Integer.parseInt(this.field.get("IDX_INSURANCE_RECOURSE").toString());
        this.IDX_COMPANY_RECOURSE = Integer.parseInt(this.field.get("IDX_COMPANY_RECOURSE").toString());
        this.IDX_DAMAGE_EXCESS = Integer.parseInt(this.field.get("IDX_DAMAGE_EXCESS").toString());
        this.IDX_VAT = Integer.parseInt(this.field.get("IDX_VAT").toString());
        this.IDX_DILAPIDATION = Integer.parseInt(this.field.get("IDX_DILAPIDATION").toString());
        this.IDX_SELF_INSURANCE = Integer.parseInt(this.field.get("IDX_SELF_INSURANCE").toString());
        this.IDX_EXPERT_COST = Integer.parseInt(this.field.get("IDX_EXPERT_COST").toString());
        this.IDX_FIXING_COST = Integer.parseInt(this.field.get("IDX_FIXING_COST").toString());
        this.IDX_COMPANY_FIXING_COST = Integer.parseInt(this.field.get("IDX_COMPANY_FIXING_COST").toString());
        this.IDX_LOCATION_DEBT = Integer.parseInt(this.field.get("IDX_LOCATION_DEBT").toString());
        this.IDX_COMPANY_LOCATION_DEBT = Integer.parseInt(this.field.get("IDX_COMPANY_LOCATION_DEBT").toString());
        this.IDX_GUARDING = Integer.parseInt(this.field.get("IDX_GUARDING").toString());
        this.IDX_IN_TRAFFIC = Integer.parseInt(this.field.get("IDX_IN_TRAFFIC").toString());
        this.IDX_INSURANCE_TYPE = Integer.parseInt(this.field.get("IDX_INSURANCE_TYPE").toString());
        this.IDX_INSURANCE_CODE = Integer.parseInt(this.field.get("IDX_INSURANCE_CODE").toString());
        this.IDX_CONVENTION_TYPE = Integer.parseInt(this.field.get("IDX_CONVENTION_TYPE").toString());
        this.IDX_TOTAL_COST = Integer.parseInt(this.field.get("IDX_TOTAL_COST").toString());
        this.IDX_TOTAL_INSURANCE = Integer.parseInt(this.field.get("IDX_TOTAL_INSURANCE").toString());
    }

    private void loadTranscription() {
        int x = 0;
        String value = "";
        while ((value = this.field.get("TRN_RESPONSABILITY_" + x)) != null) {
            this.trn_responsability.add(value);
            ++x;
        }
        x = 0;
        while ((value = this.field.get("TRN_TYPE_" + x)) != null) {
            this.trn_type.add(value);
            ++x;
        }
        x = 0;
        while ((value = this.field.get("TRN_OPEN_" + x)) != null) {
            this.trn_open.add(value);
            ++x;
        }
        x = 0;
    }

    private int responsabilityId(String resp) {
        if (resp == null) {
            return -1;
        }
        if (this.trn_responsability.size() != 0) {
            for (String tmp : this.trn_responsability) {
                if (!tmp.startsWith(resp)) continue;
                return Integer.parseInt(tmp.split(";")[1]);
            }
            return -1;
        }
        int x = 0;
        String[] stringArray = Accident.RESPONSABILITY_WORDING;
        int n = Accident.RESPONSABILITY_WORDING.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            if (tmp.equals(resp)) {
                return x;
            }
            ++x;
            ++n2;
        }
        return -1;
    }

    private int typeId(String type) {
        if (type == null) {
            return -1;
        }
        if (this.trn_type.size() != 0) {
            for (String tmp : this.trn_type) {
                if (!tmp.startsWith(type)) continue;
                return Integer.parseInt(tmp.split(";")[1]);
            }
            return -1;
        }
        int x = 0;
        String[] stringArray = Accident.TYPE_WORDING;
        int n = Accident.TYPE_WORDING.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            if (tmp.equals(type)) {
                return x;
            }
            ++x;
            ++n2;
        }
        return -1;
    }

    private int openId(String status) {
        if (status == null) {
            return 0;
        }
        if (this.trn_open.size() != 0) {
            for (String tmp : this.trn_open) {
                if (!tmp.startsWith(status)) continue;
                return Integer.parseInt(tmp.split(";")[1]);
            }
            return 0;
        }
        return Integer.parseInt(status);
    }
}

