/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.ImportField;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.imp.AbstractAutomaticImport;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.ExcelReader;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ConsumptionImport
extends AbstractAutomaticImport {
    private final String MODULE = "CONSUMPTION";
    HashMap<String, String> field = null;
    ArrayList<String> trn_responsability = new ArrayList();
    ArrayList<String> trn_type = new ArrayList();
    ArrayList<String> trn_open = new ArrayList();
    private int IDX_AGENCY_NAME = -1;
    private int IDX_AGENCY_CODE = -1;
    private int IDX_IMMATRICULATION = -1;
    private int IDX_VEHICLE_ID = -1;
    private int IDX_VEHICLE_CODE = -1;
    private int IDX_DRIVER_CODE = -1;
    private int IDX_DRIVER_ID = -1;
    private int IDX_DRIVER_FIRST_NAME = -1;
    private int IDX_DRIVER_LAST_NAME = -1;
    private int IDX_DATE = -1;
    private int IDX_CONSUMPTION = -1;
    private int IDX_LITERS = -1;
    private int IDX_LENGTH = -1;
    private int IDX_KM = -1;
    private int IDX_STOP_LENGTH = -1;
    private int IDX_STOP_LENGTH_STRENGTH = -1;
    private int IDX_STOP_LENGTH_IN_TRAFFIC = -1;
    private int IDX_LENGTH_BRAKE = -1;
    private int IDX_REG_DELTA = -1;
    private int IDX_CO2 = -1;
    private int IDX_TRAVEL_NOTATION = -1;

    @Override
    public void execute() {
        int ignored;
        int agencyCreated;
        int created;
        block24: {
            TimsLogger.debug("#ConsumptionImport.process# Enter module");
            this.field = ImportField.loadHashMap("CONSUMPTION");
            if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
                TimsLogger.warn("#ConsumptionImport.process# Missing parameters for CONSUMPTION, can't continue");
                return;
            }
            String unknow = LanguageTranslator.getString("generics.unknown");
            created = 0;
            boolean updated = false;
            boolean unchanged = false;
            agencyCreated = 0;
            boolean typeCreated = false;
            boolean affectationCreated = false;
            boolean acCreated = false;
            boolean bodyCreated = false;
            boolean modelCreated = false;
            ignored = 0;
            BddTransport.getInstance().startTransaction();
            try {
                String file = this.field.get("FILENAME");
                TimsLogger.debug("#ConsumptionImport.process# Loading " + file + " for module " + "CONSUMPTION");
                String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
                String ext = file.substring(file.indexOf(".") + 1);
                if (!new File(file).exists()) {
                    TimsLogger.error(String.valueOf(file) + " does not exists");
                    return;
                }
                if (ext.equals("xls")) {
                    TimsLogger.debug("#ConsumptionImport.process# using excel reader");
                    this.reader = new ExcelReader(file, dateFormat);
                } else if (ext.equals("csv")) {
                    TimsLogger.debug("#ConsumptionImport.process# using csv reader");
                    this.reader = new CsvReader(file, dateFormat);
                }
                this.initColmun();
                if (this.fileContainsTitle) {
                    this.reader.next();
                }
                while (this.reader.next()) {
                    int fStopLengthInTraffic;
                    String fDriverLastName;
                    String fImmatriculation;
                    String agencyName = this.IDX_AGENCY_NAME == -1 ? null : this.reader.get(this.IDX_AGENCY_NAME).trim();
                    String agencyCode = this.IDX_AGENCY_CODE == -1 ? null : this.reader.get(this.IDX_AGENCY_CODE).trim();
                    String string = fImmatriculation = this.IDX_IMMATRICULATION == -1 ? null : this.reader.get(this.IDX_IMMATRICULATION).trim();
                    if (fImmatriculation != null) {
                        while (fImmatriculation.startsWith("0")) {
                            fImmatriculation = fImmatriculation.substring(1);
                        }
                    }
                    String fCode = this.IDX_VEHICLE_CODE == -1 ? null : this.reader.get(this.IDX_VEHICLE_CODE).trim();
                    int fVehicleId = this.IDX_VEHICLE_ID == -1 ? -1 : this.reader.getInt(this.IDX_VEHICLE_ID);
                    String fDriverCode = this.IDX_DRIVER_CODE == -1 ? null : this.reader.get(this.IDX_DRIVER_CODE).trim();
                    String fDriverFirstName = this.IDX_DRIVER_FIRST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_FIRST_NAME).trim();
                    String string2 = fDriverLastName = this.IDX_DRIVER_LAST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_LAST_NAME).trim();
                    if (this.IDX_DRIVER_FIRST_NAME == this.IDX_DRIVER_LAST_NAME && fDriverFirstName != null && !fDriverFirstName.equals("")) {
                        String[] names = fDriverFirstName.split(" ");
                        fDriverLastName = names[0];
                        fDriverFirstName = fDriverFirstName.substring(fDriverLastName.length());
                        TimsLogger.debug("fDriverFirstName " + fDriverFirstName + " fDriverLastName" + fDriverLastName);
                    }
                    int fDriverId = this.IDX_DRIVER_ID == -1 ? -1 : this.reader.getInt(this.IDX_DRIVER_ID);
                    Date fDate = this.IDX_DATE == -1 ? null : this.reader.getDate(this.IDX_DATE);
                    float fConsumption = this.IDX_CONSUMPTION == -1 ? 0.0f : this.reader.getFloat(this.IDX_CONSUMPTION);
                    float fLiters = this.IDX_LITERS == -1 ? 0.0f : this.reader.getFloat(this.IDX_LITERS);
                    float fKm = this.IDX_KM == -1 ? 0.0f : this.reader.getFloat(this.IDX_KM);
                    float fLengthBrake = this.IDX_LENGTH_BRAKE == -1 ? 0.0f : this.reader.getFloat(this.IDX_LENGTH_BRAKE);
                    int fCO2 = this.IDX_CO2 == -1 ? 0 : this.reader.getInt(this.IDX_CO2);
                    int fRegDelta = this.IDX_REG_DELTA == -1 ? 0 : this.reader.getInt(this.IDX_REG_DELTA);
                    int fTravelNotation = this.IDX_TRAVEL_NOTATION == -1 ? 0 : this.reader.getInt(this.IDX_TRAVEL_NOTATION);
                    int fLength = this.IDX_LENGTH == -1 ? 0 : this.reader.getInt(this.IDX_LENGTH);
                    int fStopLength = this.IDX_STOP_LENGTH == -1 ? 0 : this.reader.getInt(this.IDX_STOP_LENGTH);
                    int fStopLengthStrength = this.IDX_STOP_LENGTH_STRENGTH == -1 ? 0 : this.reader.getInt(this.IDX_STOP_LENGTH_STRENGTH);
                    int n = fStopLengthInTraffic = this.IDX_STOP_LENGTH_IN_TRAFFIC == -1 ? 0 : this.reader.getInt(this.IDX_STOP_LENGTH_IN_TRAFFIC);
                    if (this.timeResolution == 2) {
                        fLength /= 60;
                        fStopLength /= 60;
                        fStopLengthStrength /= 60;
                        fStopLengthInTraffic /= 60;
                    }
                    TimsLogger.debug("Line : agencyName=" + agencyName + ", agencyCode=" + agencyCode + ", fImmatriculation=" + fImmatriculation + ", fCode=" + fCode + ", fDriverCode=" + fDriverCode + ", fDriverFirstName=" + fDriverFirstName + ", fDriverLastName=" + fDriverLastName);
                    Vehicule vehicle = new Vehicule();
                    Agence agency = new Agence();
                    Conducteur driver = new Conducteur();
                    if (!(agencyName == null && agencyCode == null || agency.loadByNameOrCode(agencyName, agencyCode))) {
                        agency.setDescription(agencyName == null ? agencyCode : agencyName);
                        agency.setCleInterneAgence(agencyCode);
                        agency.insert();
                        agency.loadByNameOrCode(agencyName, agencyCode);
                        ++agencyCreated;
                    }
                    if (!(fVehicleId != -1 && vehicle.loadById(fVehicleId) || fImmatriculation != null && vehicle.loadByImmat(fImmatriculation, true) || fCode != null && vehicle.loadByCode(fCode))) {
                        if ("0".equals(this.field.get("FORCE_VEHICLE_CREATION"))) {
                            ++ignored;
                            continue;
                        }
                        vehicle.setAgencyId(agency.getCleAgence());
                        vehicle.setRegistrationNumber(fImmatriculation);
                        vehicle.setIdentificationNumber(fCode);
                        if (vehicle.insert()) {
                            ++created;
                        } else {
                            TimsLogger.warn("#ConsumptionImport.process# Erreur cr\u00e9ation v\u00e9hicule");
                            ++ignored;
                        }
                    }
                    if (!(fDriverCode != null && driver.loadByCode(fDriverCode) || fDriverId != -1 && driver.loadById(fDriverId) || fDriverLastName != null && fDriverFirstName != null && driver.loadByName(fDriverLastName, fDriverFirstName))) {
                        if ("0".equals(this.field.get("FORCE_DRIVER_CREATION"))) {
                            ++ignored;
                            continue;
                        }
                        driver.setCleAgence(agency.getCleAgence());
                        driver.setMatricule(fCode);
                        driver.setPrenom(fDriverFirstName);
                        driver.setNom(fDriverLastName);
                        if (driver.insert()) {
                            ++created;
                        } else {
                            TimsLogger.warn("#ConsumptionImport.process# Erreur cr\u00e9ation conducteur");
                            ++ignored;
                        }
                    }
                    TimsLogger.debug("#ConsumptionImport.process# Saving " + agency.getCleAgence() + ", " + driver.getCleConducteur() + ", " + vehicle.getCleVehicule() + ", " + fDate + ", " + fConsumption + ", " + fLiters + ", " + fLength + ", " + fKm);
                    FuelConsumption tmp = new FuelConsumption();
                    tmp.loadByDriverAndDate(driver.getCleConducteur(), fDate);
                    tmp.compareAndUpdate(agency.getCleAgence(), driver.getCleConducteur(), vehicle.getCleVehicule(), fDate, fConsumption, fLiters, fLength, fKm, 0, fStopLength, fStopLengthStrength, fStopLengthInTraffic, fLengthBrake, fRegDelta, fCO2, fTravelNotation);
                }
                if (Transport.debug >= 1) {
                    TimsLogger.debug("#ConsumtpionImport# Rollback...");
                    BddTransport.getInstance().commit();
                } else {
                    BddTransport.getInstance().commit();
                }
            }
            catch (Exception ex) {
                TimsLogger.error("Erreur syst\u00e8me");
                ex.printStackTrace();
                if (Transport.debug != 0) break block24;
                System.exit(1);
            }
        }
        TimsLogger.info("\r\n#Consumption Import # Final result : " + agencyCreated + " agences cr\u00e9es. " + created + " v\u00e9hicules cr\u00e9es, " + ignored + " ignor\u00e9s, ");
    }

    private void initColmun() {
        this.fileContainsTitle = this.field.get("TITLE") != null && this.field.get("TITLE").toString().equals("1");
        this.timeResolution = Integer.parseInt(this.field.get("TIME_RESOLUTION").toString());
        this.IDX_AGENCY_NAME = Integer.parseInt(this.field.get("IDX_AGENCY_NAME").toString());
        this.IDX_AGENCY_CODE = Integer.parseInt(this.field.get("IDX_AGENCY_CODE").toString());
        this.IDX_IMMATRICULATION = Integer.parseInt(this.field.get("IDX_IMMATRICULATION").toString());
        this.IDX_VEHICLE_ID = Integer.parseInt(this.field.get("IDX_VEHICLE_ID").toString());
        this.IDX_VEHICLE_CODE = Integer.parseInt(this.field.get("IDX_VEHICLE_CODE").toString());
        this.IDX_DRIVER_ID = Integer.parseInt(this.field.get("IDX_DRIVER_ID").toString());
        this.IDX_DRIVER_CODE = Integer.parseInt(this.field.get("IDX_DRIVER_CODE").toString());
        this.IDX_DRIVER_FIRST_NAME = Integer.parseInt(this.field.get("IDX_DRIVER_FIRST_NAME").toString());
        this.IDX_DRIVER_LAST_NAME = Integer.parseInt(this.field.get("IDX_DRIVER_LAST_NAME").toString());
        this.IDX_DATE = Integer.parseInt(this.field.get("IDX_DATE").toString());
        this.IDX_CONSUMPTION = Integer.parseInt(this.field.get("IDX_CONSUMPTION").toString());
        this.IDX_LITERS = Integer.parseInt(this.field.get("IDX_LITERS").toString());
        this.IDX_LENGTH = Integer.parseInt(this.field.get("IDX_LENGTH").toString());
        this.IDX_KM = Integer.parseInt(this.field.get("IDX_KM").toString());
        this.IDX_STOP_LENGTH = Integer.parseInt(this.field.get("IDX_STOP_LENGTH").toString());
        this.IDX_STOP_LENGTH_STRENGTH = Integer.parseInt(this.field.get("IDX_STOP_LENGTH_STRENGTH").toString());
        this.IDX_STOP_LENGTH_IN_TRAFFIC = Integer.parseInt(this.field.get("IDX_STOP_LENGTH_IN_TRAFFIC").toString());
        this.IDX_LENGTH_BRAKE = Integer.parseInt(this.field.get("IDX_LENGTH_BRAKE").toString());
        this.IDX_REG_DELTA = Integer.parseInt(this.field.get("IDX_REG_DELTA").toString());
        this.IDX_CO2 = Integer.parseInt(this.field.get("IDX_CO2").toString());
        this.IDX_TRAVEL_NOTATION = Integer.parseInt(this.field.get("IDX_TRAVEL_NOTATION").toString());
    }
}

