/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.Comment;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Conflit;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.Offense;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.VehicleUsed;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.views.conducteur.DialogCreationConducteur;
import transpo.system.util.Fonctions;

public class DriverImport {
    public static int DAY = 105;
    public static int UPDATED_DAY = 112;
    public static int HISTORISED_ACTIVITY = 128;
    private File[] sourcePath = null;
    private byte[] fileBuffer = null;

    public DriverImport(File[] path) {
        this.sourcePath = path;
    }

    public boolean run() {
        TimsLogger.debug("nb de fichier " + this.sourcePath.length);
        if (this.sourcePath == null) {
            return false;
        }
        int x = 0;
        while (x < this.sourcePath.length) {
            String fileName = this.sourcePath[x].getName();
            String firstName = fileName.substring(0, fileName.indexOf("  "));
            String lastName = fileName.substring(fileName.indexOf("  "), fileName.lastIndexOf("  "));
            String version = fileName.substring(fileName.lastIndexOf("  "));
            TimsLogger.debug("import de " + lastName + " " + firstName);
            this.loadDriver(this.sourcePath[x]);
            ++x;
        }
        return true;
    }

    private boolean loadDriver(File toRead) {
        this.readFile(toRead);
        Conducteur driver = this.readDriver();
        if (driver == null) {
            TimsLogger.warn("Erreur de lecture de conducteur");
            return false;
        }
        Vector<Jour> dayList = this.readDay(DAY);
        Vector<Jour> updatedDayList = this.readDay(UPDATED_DAY);
        Vector<Service> serviceList = this.readServices();
        Vector<ActiviteConducteur> AConflictList = this.readActivity(114);
        Vector<ActiviteConducteur> BConflictList = this.readActivity(115);
        Vector<Conflit> conflitList = this.readConflict();
        Vector<CardDownload> cdList = this.readCardDownload();
        Vector<VehicleUsed> vuList = this.readVehicles();
        Vector<Comment> commentList = this.readComment();
        Vector<DriverExpenses> deList = this.readDriverExpenses();
        Vector<Offense> offenseList = this.readOffense();
        DialogCreationConducteur creation = new DialogCreationConducteur((Frame)MainFrameTransport.getInstance(), driver);
        creation.setVisible(true);
        if (creation.enregistrement) {
            driver.loadByName(driver.getNom(), driver.getPrenom());
        }
        int cle = driver.getCleConducteur();
        for (Jour jour : dayList) {
            jour.setDriverId(cle);
            jour.insert();
        }
        for (Jour jour : updatedDayList) {
            jour.setDriverId(cle);
            jour.insert();
        }
        for (Service service : serviceList) {
            service.setDriverId(cle);
            service.insert();
        }
        for (ActiviteConducteur activiteConducteur : AConflictList) {
            activiteConducteur.setCleConducteur(cle);
            activiteConducteur.insert();
        }
        for (ActiviteConducteur activiteConducteur : BConflictList) {
            activiteConducteur.setCleConducteur(cle);
            activiteConducteur.insert();
        }
        for (Conflit conflit : conflitList) {
            conflit.setCleConducteur(cle);
            conflit.insert();
        }
        for (CardDownload cardDownload : cdList) {
            cardDownload.insert();
        }
        for (VehicleUsed vehicleUsed : vuList) {
            vehicleUsed.setCleConducteur(cle);
            vehicleUsed.insert("driver_vehicle_used");
        }
        for (Comment comment : commentList) {
            comment.setDriverId(cle);
            comment.insert();
        }
        for (DriverExpenses driverExpenses : deList) {
            driverExpenses.setDriverId(cle);
            driverExpenses.insert();
        }
        for (Offense offense : offenseList) {
            offense.setDriverId(cle);
            offense.insert();
        }
        return true;
    }

    private Conducteur readDriver() {
        Conducteur tmp = new Conducteur();
        int offset = this.getOffset(101);
        if (offset == -1) {
            TimsLogger.warn("Error offset driver unknown");
            return null;
        }
        tmp.read(this.fileBuffer, offset);
        return tmp;
    }

    /*
     * Unable to fully structure code
     */
    private Vector<ActiviteConducteur> readActivity(int idOffset) {
        table = "";
        if (idOffset == 114) {
            table = "t_activite_conflit_base";
        }
        if (idOffset == 115) {
            table = "t_activite_conflit_analyse";
        }
        returnList = new Vector<ActiviteConducteur>();
        offset = this.getOffset(idOffset);
        if (offset != -1) ** GOTO lbl17
        TimsLogger.warn("no data for EF Activity " + table);
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new ActiviteConducteur(table);
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl17:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == idOffset)
        }
lbl18:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readActivity#size of " + table + " = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    private Vector<Jour> readDay(int idOffset) {
        returnList = new Vector<Jour>();
        offset = this.getOffset(idOffset);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF Day " + idOffset);
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new Jour();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == idOffset)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readDay#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<CardDownload> readCardDownload() {
        returnList = new Vector<CardDownload>();
        offset = this.getOffset(116);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for CardDownload");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new CardDownload();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 116)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readCardDownload#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Comment> readComment() {
        returnList = new Vector<Comment>();
        offset = this.getOffset(117);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF Comment");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new Comment();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 117)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readComment#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<DriverExpenses> readDriverExpenses() {
        returnList = new Vector<DriverExpenses>();
        offset = this.getOffset(DriverExpenses.OFFSET);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF DriverExpenses");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new DriverExpenses();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == DriverExpenses.OFFSET)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readDriverExpenses#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Service> readServices() {
        returnList = new Vector<Service>();
        offset = this.getOffset(Service.OFFSET);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for Service");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new Service();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == Service.OFFSET)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readDriverExpenses#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Conflit> readConflict() {
        returnList = new Vector<Conflit>();
        offset = this.getOffset(129);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF Conflit");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new Conflit();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 129)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readConflict#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<VehicleUsed> readVehicles() {
        returnList = new Vector<VehicleUsed>();
        offset = this.getOffset(129);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF VehicleUsed");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new VehicleUsed();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 52)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readVehicles#size = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Offense> readOffense() {
        returnList = new Vector<Offense>();
        offset = this.getOffset(129);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF Offense");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new Offense();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == Offense.OFFSET)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#ImportConducteur.readOffense#size = " + returnList.size());
        return returnList;
    }

    public int getOffset(int idOffset) {
        int offset = 0;
        while (offset < this.fileBuffer.length) {
            if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == idOffset) {
                return offset;
            }
            int lengthSize = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
            int lengthOffset = Fonctions.bytesToInt(this.fileBuffer, ++offset, lengthSize);
            offset += lengthSize + lengthOffset;
        }
        return -1;
    }

    public byte[] getObjectByte(int offset) {
        int lengthSize = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
        int activityLength = Fonctions.bytesToInt(this.fileBuffer, ++offset, lengthSize);
        ++offset;
        byte[] one = new byte[activityLength];
        int x = 0;
        while (x < activityLength) {
            one[x] = this.fileBuffer[offset];
            ++x;
            ++offset;
        }
        return one;
    }

    public void readFile(File toRead) {
        BufferedInputStream fs = null;
        try {
            FileInputStream channel = new FileInputStream(toRead);
            fs = new BufferedInputStream(channel);
            int taille = fs.available();
            this.fileBuffer = new byte[taille];
            fs.read(this.fileBuffer, 0, taille);
            channel.close();
            fs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static File[] getFile(String title, String btnMsg, boolean repOnly, String defaultRep) {
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            String def = "";
            if (defaultRep != null && defaultRep != "") {
                def = prefs.node("DIRECTORY").get(defaultRep, System.getProperty("user.home"));
            }
            JFileChooser choix = new JFileChooser(def);
            if (repOnly) {
                choix.setFileSelectionMode(1);
            }
            choix.setMultiSelectionEnabled(true);
            choix.setDialogTitle(title);
            choix.setApproveButtonText(btnMsg);
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                if (defaultRep != null && defaultRep != "") {
                    prefs.node("DIRECTORY").put(defaultRep, choix.getCurrentDirectory().getAbsolutePath());
                }
                return choix.getSelectedFiles();
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.system.util.Fonctions.getFile(  )  : " + ex);
            return null;
        }
        return null;
    }
}

