/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.EmployeeType;
import fr.pgh.data.bdd.ImportField;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.DataReader;
import transpo.system.imp.util.ExcelReader;

public class DriverSheetImport
extends AbstractAutomaticWarning {
    private DataReader reader = null;
    private final String MODULE = "DRIVER_SHEET";
    HashMap<String, String> field = null;
    private int IDX_MATRICULE = -1;
    private int IDX_NOM = -1;
    private int IDX_PRENOM = -1;
    private int IDX_AGENCY = -1;
    private int IDX_AGENCY_CODE = -1;
    private int IDX_TYPE_PERSONNEL = -1;
    private int IDX_ADRESSE1 = -1;
    private int IDX_ADRESSE2 = -1;
    private int IDX_BIRTH = -1;
    private int IDX_SOCIAL_NUMBER = -1;
    private int IDX_CITY = -1;
    private int IDX_CP = -1;
    private int IDX_ENTRY = -1;
    private int IDX_DATE_SORTIE = -1;

    @Override
    public void execute() {
        this.field = ImportField.loadHashMap("DRIVER_SHEET");
        if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
            TimsLogger.warn("#DriverSheetImport.process# Missing parameters for DriverSheetImport (DRIVER_SHEET), can't continue");
            return;
        }
        int created = 0;
        int updated = 0;
        boolean unchanged = false;
        int agencyCreated = 0;
        int typeCreated = 0;
        boolean affectationCreated = false;
        boolean acCreated = false;
        boolean bodyCreated = false;
        boolean modelCreated = false;
        int ignored = 0;
        BddTransport.getInstance().startTransaction();
        try {
            String file = this.field.get("FILENAME");
            String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
            String ext = file.substring(file.indexOf(".") + 1);
            if (ext.startsWith("xls")) {
                this.reader = new ExcelReader(file, dateFormat);
            } else if (ext.equals("csv")) {
                this.reader = new CsvReader(file, dateFormat);
            }
            this.initColmun();
            while (this.reader.next()) {
                boolean hasChanged;
                if (this.field.get("COLUMN_NAME") != null) {
                    TimsLogger.debug("on saute le nom des colonnes.");
                    this.field.put("COLUMN_NAME", null);
                    continue;
                }
                String matricule = this.IDX_MATRICULE == -1 ? null : this.reader.get(this.IDX_MATRICULE);
                String nom = this.IDX_NOM == -1 ? null : this.reader.get(this.IDX_NOM);
                String prenom = this.IDX_PRENOM == -1 ? null : this.reader.get(this.IDX_PRENOM);
                String adresse = String.valueOf(this.IDX_ADRESSE1 == -1 ? "" : this.reader.get(this.IDX_ADRESSE1)) + (this.IDX_ADRESSE2 == -1 ? "" : (this.reader.get(this.IDX_ADRESSE2).equals("") ? "" : "\n" + this.reader.get(this.IDX_ADRESSE2)));
                String cp = this.IDX_CP == -1 ? null : this.reader.get(this.IDX_CP);
                String city = this.IDX_CITY == -1 ? null : this.reader.get(this.IDX_CITY);
                Date dEntree = this.IDX_ENTRY == -1 ? null : this.reader.getDate(this.IDX_ENTRY);
                String dateEntree = ConversionTime.dateToString(dEntree, "yyyy-MM-dd", null);
                Date dSortie = this.IDX_DATE_SORTIE == -1 ? null : this.reader.getDate(this.IDX_DATE_SORTIE);
                String dateSortie = ConversionTime.dateToString(dSortie, "yyyy-MM-dd", null);
                String agencyCode = this.IDX_AGENCY_CODE == -1 ? null : this.reader.get(this.IDX_AGENCY_CODE);
                String socialNumber = this.IDX_SOCIAL_NUMBER == -1 ? null : this.reader.get(this.IDX_SOCIAL_NUMBER);
                Date dBirthdate = this.IDX_BIRTH == -1 ? null : this.reader.getDate(this.IDX_BIRTH);
                String birthDate = ConversionTime.dateToString(dBirthdate, "yyyy-MM-dd", null);
                String agency = this.IDX_AGENCY == -1 ? null : this.reader.get(this.IDX_AGENCY);
                String type = this.IDX_TYPE_PERSONNEL == -1 ? null : this.reader.get(this.IDX_TYPE_PERSONNEL);
                Conducteur currentConducteur = new Conducteur();
                EmployeeType currentType = new EmployeeType();
                Agence currentAgence = new Agence();
                if (!currentAgence.loadByNameOrCode(agency, agencyCode)) {
                    TimsLogger.debug("cr\u00e9ation  " + agency + " " + agencyCode);
                    currentAgence.setDescription(agency);
                    currentAgence.setCleInterneAgence(agencyCode);
                    currentAgence.insert();
                    currentAgence.loadByNameOrCode(agency, agencyCode);
                    ++agencyCreated;
                }
                if (type != null && !currentType.loadByName(type)) {
                    currentType.setName(type);
                    currentType.insert();
                    currentType.loadByName(type);
                    ++typeCreated;
                }
                if (!currentConducteur.loadByCode(matricule) && !currentConducteur.loadByName(nom, prenom)) {
                    if (dateSortie != null && !dateSortie.equals("1970-01-01") && !ConversionTime.stringToDate(dateSortie, "yyyy-MM-dd").after(new Date())) continue;
                    TimsLogger.debug("cr\u00e9ation  " + nom + " " + prenom);
                    currentConducteur.setAdresse(adresse);
                    currentConducteur.setMatricule(matricule);
                    currentConducteur.setNom(nom);
                    currentConducteur.setPrenom(prenom);
                    currentConducteur.setCleAgence(currentAgence.getCleAgence());
                    currentConducteur.setCleTypePersonnel(currentType.getId());
                    currentConducteur.setCodePostal(cp);
                    currentConducteur.setDateEntree(dateEntree);
                    currentConducteur.setDateSortie(dateSortie);
                    currentConducteur.setVille(city);
                    currentConducteur.insert();
                    continue;
                }
                if (currentConducteur.getCleAgence() != currentAgence.getCleAgence()) {
                    TimsLogger.debug("Archivage de " + currentConducteur.getNom() + " " + currentConducteur.getPrenom() + " (Changement agence)");
                    currentConducteur.setArchive(1);
                    currentConducteur.setDateSortie(ConversionTime.dateToString(new Date(), "yyyy-MM-dd"));
                    currentConducteur.update();
                    currentConducteur.setCleAgence(currentAgence.getCleAgence());
                    currentConducteur.setDateSortie(dateSortie);
                    if (dateSortie != null) {
                        currentConducteur.setArchive(ConversionTime.stringToDate(dateSortie, "yyyy-MM-dd").before(new Date()) ? 1 : 0);
                    }
                    currentConducteur.insert();
                }
                if (!(hasChanged = currentConducteur.compareAndUpdate(nom, prenom, matricule, currentConducteur.getNumeroImport(), currentConducteur.getNumeroCarte(), currentConducteur.getMemberState(), currentConducteur.getReplacement(), currentConducteur.getRenewal(), currentConducteur.getIoCounter(), birthDate, currentConducteur.getLieuNaissance(), currentConducteur.getCleAgence(), currentConducteur.getCleTypeContrat(), currentConducteur.getCalendarId(), currentType.getId(), currentConducteur.getCleTypeConducteur(), adresse, cp, city, currentConducteur.getTel1(), currentConducteur.getTel2(), currentConducteur.getTel3(), currentConducteur.getEmail(), dateEntree, dateSortie, currentConducteur.getDateVisite(), currentConducteur.getDateDebutValiditeCarte(), currentConducteur.getDateFinValiditeCarte(), socialNumber, currentConducteur.getTaux(), currentConducteur.isNightWorker(), currentConducteur.getFimoFco(), currentConducteur.getQuaCardNumber(), currentConducteur.getKey(), currentConducteur.getNightDay(), currentConducteur.getNumeroPermis(), currentConducteur.getDateVisitePermis(), currentConducteur.getBDelivery(), currentConducteur.getCDelivery(), currentConducteur.getCEDelivery(), currentConducteur.getDDelivery(), currentConducteur.getDEDelivery(), currentConducteur.getAdr(), currentConducteur.getCaces(), currentConducteur.getExternalId(), currentConducteur.getAnalyticCodeId(), currentConducteur.isRenewalPending(), currentConducteur.getPayPeriodType(), currentConducteur.isExpensesAllowance()))) continue;
                ++updated;
            }
            if (Transport.debug >= 1) {
                BddTransport.getInstance().commit();
            } else {
                BddTransport.getInstance().commit();
            }
        }
        catch (Exception ex) {
            TimsLogger.error("Erreur syst\u00e8me");
            ex.printStackTrace();
            System.exit(1);
        }
        TimsLogger.info("\r\n# DriverSheetImport # Final result : " + agencyCreated + " agences cr\u00e9es. " + created + " conducteurs cr\u00e9es, " + updated + " mis \u00e0 jour (changement ou non), " + ignored + " ignor\u00e9s, ");
    }

    private void initColmun() {
        this.IDX_MATRICULE = this.field.get("IDX_MATRICULE") != null ? Integer.parseInt(this.field.get("IDX_MATRICULE").toString()) : -1;
        this.IDX_NOM = this.field.get("IDX_NOM") != null ? Integer.parseInt(this.field.get("IDX_NOM").toString()) : -1;
        this.IDX_PRENOM = this.field.get("IDX_PRENOM") != null ? Integer.parseInt(this.field.get("IDX_PRENOM").toString()) : -1;
        this.IDX_AGENCY = this.field.get("IDX_AGENCY") != null ? Integer.parseInt(this.field.get("IDX_AGENCY").toString()) : -1;
        this.IDX_AGENCY_CODE = this.field.get("IDX_AGENCY_CODE") != null ? Integer.parseInt(this.field.get("IDX_AGENCY_CODE").toString()) : -1;
        this.IDX_TYPE_PERSONNEL = this.field.get("IDX_TYPE_PERSONNEL") != null ? Integer.parseInt(this.field.get("IDX_TYPE_PERSONNEL").toString()) : -1;
        this.IDX_ADRESSE1 = this.field.get("IDX_ADRESSE1") != null ? Integer.parseInt(this.field.get("IDX_ADRESSE1").toString()) : -1;
        this.IDX_ADRESSE2 = this.field.get("IDX_ADRESSE2") != null ? Integer.parseInt(this.field.get("IDX_ADRESSE2").toString()) : -1;
        this.IDX_CITY = this.field.get("IDX_CITY") != null ? Integer.parseInt(this.field.get("IDX_CITY").toString()) : -1;
        this.IDX_CP = this.field.get("IDX_CP") != null ? Integer.parseInt(this.field.get("IDX_CP").toString()) : -1;
        this.IDX_ENTRY = this.field.get("IDX_ENTRY") != null ? Integer.parseInt(this.field.get("IDX_ENTRY").toString()) : -1;
        this.IDX_DATE_SORTIE = this.field.get("IDX_DATE_SORTIE") != null ? Integer.parseInt(this.field.get("IDX_DATE_SORTIE").toString()) : -1;
        this.IDX_BIRTH = this.field.get("IDX_BIRTH") != null ? Integer.parseInt(this.field.get("IDX_BIRTH").toString()) : -1;
        this.IDX_SOCIAL_NUMBER = this.field.get("IDX_SOCIAL_NUMBER") != null ? Integer.parseInt(this.field.get("IDX_SOCIAL_NUMBER").toString()) : -1;
    }
}

