/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.EmployeeObligation;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.imp.AbstractAutomaticImport;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.ExcelReader;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class EmployeeObligationImport
extends AbstractAutomaticImport {
    private final String MODULE = "EMPLOYEE_OBLIGATION";
    HashMap<String, String> field = null;
    HashMap<String, Integer> typeObl = new HashMap();
    private int IDX_DRIVER_CODE = -1;
    private int IDX_DRIVER_ID = -1;
    private int IDX_DRIVER_FIRST_NAME = -1;
    private int IDX_DRIVER_LAST_NAME = -1;
    private int IDX_DATE = -1;
    private int IDX_EXPIRATION = -1;
    private int IDX_LENGTH = -1;
    private int IDX_LIBELLE = -1;
    private int IDX_PLACE = -1;
    private int IDX_COMMENT = -1;
    private int IDX_COST = -1;
    private int IDX_STATE = -1;

    public EmployeeObligationImport() {
        this.typeObl.put("R390 - GRUE AUXILAIRE", 1);
        this.typeObl.put("ADR -  COLIS|", 2);
        this.typeObl.put("ADR -  CITERNE|", 3);
        this.typeObl.put("ADR - Intervenant chapitre 1.3", 4);
        this.typeObl.put("ATEX", 5);
        this.typeObl.put("comp\u00e9tence amiante", 6);
        this.typeObl.put("ELEC BOHOHOV BT Ex\u00e9cutant |", 7);
        this.typeObl.put("habilitation H0v B0 BE manoeuvre", 8);
        this.typeObl.put("MECANIQUE  M0|", 9);
        this.typeObl.put("MECANIQUE  M1|", 10);
        this.typeObl.put("MECANIQUE  M2|", 11);
        this.typeObl.put("perf et recyc tuteurs", 12);
        this.typeObl.put("PR1 - Pr\u00e9vention risques Niveau 1 - CEA", 13);
        this.typeObl.put("PR1 - Pr\u00e9vention risques Niveau 1 -CNPE", 14);
        this.typeObl.put("CACES R 372M - ENGIN CHANTIER|", 15);
        this.typeObl.put("R372 Eng chantier 2 pelle hyd", 16);
        this.typeObl.put("R372 Eng chantier 3 chenille", 17);
        this.typeObl.put("R372 Eng chantier 4 tracto pelle", 18);
        this.typeObl.put("R372 Eng chantier 5 tp", 19);
        this.typeObl.put("R372 Eng chantier 7 compact", 20);
        this.typeObl.put("R372 Eng chantier 8 transport", 21);
        this.typeObl.put("R372 Eng chantier 9 manuscopic", 22);
        this.typeObl.put("R372 Eng chantier 10 chargement", 23);
        this.typeObl.put("R372 Eng chantier spec nacelle", 24);
        this.typeObl.put("CACES R383 - GRUE MOBILE|", 25);
        this.typeObl.put("CACES R386 - NACELLE|", 26);
        this.typeObl.put("R386 Nacelle 1B porteur", 27);
        this.typeObl.put("R386 Nacelle 3A ciseaux", 28);
        this.typeObl.put("R386 Nacelle 3B automoteur", 29);
        this.typeObl.put("CACES R389 --------- CARISTE|", 30);
        this.typeObl.put("R389 Chariot elev 2 tracteur", 31);
        this.typeObl.put("R389 Chariot elev 3 inf 6t", 32);
        this.typeObl.put("R389 Chariot elev 4 sup 6t", 33);
        this.typeObl.put("R389 Chariot elev 5 m\u00e2t retract", 34);
        this.typeObl.put("R389 Chariot elev 6 hors prod", 35);
        this.typeObl.put("CACES R390 - GRUE AUXILIAIRE|", 36);
        this.typeObl.put("R390 Grue auxiliaire sans radio", 37);
        this.typeObl.put("PONTIER / ELINGUEUR R423", 38);
        this.typeObl.put("recyclage moniteurs FCO", 39);
        this.typeObl.put("CHIMIE N1|", 40);
        this.typeObl.put("CHIMIE N2|", 41);
        this.typeObl.put("Radioprotection 1 (op\u00e9rateur)", 42);
        this.typeObl.put("Radioprotection 2 (chef d'\u00e9quipe)", 43);
        this.typeObl.put("PORT HARNAIS / TRAVAIL HAUT", 44);
        this.typeObl.put("VOITURE PILOTE - FIP/FCP|", 45);
        this.typeObl.put("NUCLEAIRE HN1 M0|", 46);
        this.typeObl.put("NUCLEAIRE HN2 M0|", 47);
        this.typeObl.put("NUCLEAIRE HN3|", 48);
    }

    @Override
    public void execute() {
        block18: {
            TimsLogger.debug("#EmployeeObligationImport.process# Enter module");
            this.field = this.load();
            if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
                TimsLogger.warn("#EmployeeObligationImport.process# Missing parameters for EMPLOYEE_OBLIGATION, can't continue");
                return;
            }
            String unknow = LanguageTranslator.getString("generics.unknown");
            int created = 0;
            boolean updated = false;
            boolean unchanged = false;
            boolean typeCreated = false;
            boolean affectationCreated = false;
            boolean acCreated = false;
            boolean bodyCreated = false;
            boolean modelCreated = false;
            int ignored = 0;
            BddTransport.getInstance().startTransaction();
            try {
                String file = this.field.get("FILENAME");
                TimsLogger.debug("#EmployeeObligationImport.process# Loading " + file + " for module " + "EMPLOYEE_OBLIGATION");
                String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
                String ext = file.substring(file.indexOf(".") + 1);
                if (ext.equals("xls")) {
                    TimsLogger.debug("#EmployeeObligationImport.process# using excel reader");
                    this.reader = new ExcelReader(file, dateFormat);
                } else if (ext.equals("csv")) {
                    TimsLogger.debug("#EmployeeObligationImport.process# using csv reader");
                    this.reader = new CsvReader(file, dateFormat);
                }
                this.initColmun();
                if (this.fileContainsTitle) {
                    this.reader.next();
                }
                while (this.reader.next()) {
                    String fDriverLastName;
                    String fDriverCode = this.IDX_DRIVER_CODE == -1 ? null : this.reader.get(this.IDX_DRIVER_CODE).trim();
                    String fDriverFirstName = this.IDX_DRIVER_FIRST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_FIRST_NAME).trim();
                    String string = fDriverLastName = this.IDX_DRIVER_LAST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_LAST_NAME).trim();
                    if (this.IDX_DRIVER_FIRST_NAME == this.IDX_DRIVER_LAST_NAME && fDriverFirstName != null && !fDriverFirstName.equals("")) {
                        String[] names = fDriverFirstName.split(" ");
                        fDriverLastName = names[0];
                        fDriverFirstName = fDriverFirstName.substring(fDriverLastName.length());
                        TimsLogger.debug("fDriverFirstName " + fDriverFirstName + " fDriverLastName" + fDriverLastName);
                    }
                    int fDriverId = this.IDX_DRIVER_ID == -1 ? -1 : this.reader.getInt(this.IDX_DRIVER_ID);
                    Date fDate = this.IDX_DATE == -1 ? null : this.reader.getDate(this.IDX_DATE);
                    Date fExpiration = this.IDX_EXPIRATION == -1 ? null : this.reader.getDate(this.IDX_EXPIRATION);
                    int fLength = this.IDX_LENGTH == -1 ? 0 : this.reader.getInt(this.IDX_LENGTH);
                    String fLibelle = this.IDX_LIBELLE == -1 ? "" : this.reader.get(this.IDX_LIBELLE);
                    String fPlace = this.IDX_PLACE == -1 ? "" : this.reader.get(this.IDX_PLACE);
                    String fComment = this.IDX_PLACE == -1 ? "" : this.reader.get(this.IDX_COMMENT);
                    float fCost = this.IDX_COST == -1 ? 0.0f : this.reader.getFloat(this.IDX_COST);
                    int fState = this.IDX_STATE == -1 ? 0 : this.reader.getInt(this.IDX_STATE);
                    int typeId = this.typeObl.get(fLibelle) == null ? 0 : this.typeObl.get(fLibelle);
                    TimsLogger.debug("Line : Obligation=" + fLibelle + ", fDate=" + fDate + ", fExpiration=" + fExpiration + ", fPlace=" + fPlace + ", fLength=" + fLength + ", fDriverCode=" + fDriverCode + ", fDriverFirstName=" + fDriverFirstName + ", fDriverLastName=" + fDriverLastName);
                    if (typeId == 0) {
                        TimsLogger.debug(String.valueOf(fLibelle) + " unknown");
                        ++ignored;
                        continue;
                    }
                    Conducteur driver = new Conducteur();
                    if (!(fDriverCode != null && driver.loadByCode(fDriverCode) || fDriverId != -1 && driver.loadById(fDriverId) || fDriverLastName != null && fDriverFirstName != null && driver.loadByName(fDriverLastName, fDriverFirstName))) {
                        if ("0".equals(this.field.get("FORCE_DRIVER_CREATION"))) {
                            ++ignored;
                            continue;
                        }
                        if (fDriverCode != null) {
                            driver.setMatricule(fDriverCode);
                        }
                        if (fDriverLastName != null) {
                            driver.setPrenom(fDriverFirstName);
                            driver.setNom(fDriverLastName);
                        }
                        if (driver.insert()) {
                            ++created;
                        } else {
                            TimsLogger.warn("#EmployeeObligationImport.process# Erreur cr\u00e9ation conducteur");
                            ++ignored;
                        }
                    }
                    TimsLogger.debug("#EmployeeObligationImport.process# Saving " + driver.getCleConducteur() + ", " + fLibelle + ", " + fDate + ", " + fExpiration + ", " + fCost + ", " + fLength + ", " + fPlace);
                    EmployeeObligation tmp = new EmployeeObligation(0, typeId, driver.getCleConducteur(), fDate, fExpiration, fLength, fPlace, fComment, fCost, 0, null);
                    tmp.insert();
                }
                if (Transport.debug >= 1) {
                    TimsLogger.debug("#ConsumtpionImport# Rollback...");
                    BddTransport.getInstance().commit();
                } else {
                    BddTransport.getInstance().commit();
                }
            }
            catch (Exception ex) {
                TimsLogger.error("Erreur syst\u00e8me");
                ex.printStackTrace();
                if (Transport.debug != 0) break block18;
                System.exit(1);
            }
        }
        TimsLogger.info("\r\n#Employee Obligation Import # Final result : ");
    }

    private HashMap<String, String> load() {
        HashMap<String, String> f = new HashMap<String, String>();
        f.put("FILENAME", "obl.csv");
        f.put("DATE_FORMAT", "yyyy-MM-dd HH:mm:ss.S");
        f.put("IDX_DRIVER_FIRST_NAME", "7");
        f.put("IDX_DRIVER_LAST_NAME", "8");
        f.put("IDX_DATE", "1");
        f.put("IDX_EXPIRATION", "2");
        f.put("IDX_LIBELLE", "3");
        f.put("IDX_PLACE", "4");
        f.put("IDX_COMMENT", "5");
        return f;
    }

    private void initColmun() {
        this.fileContainsTitle = this.field.get("TITLE") != null && this.field.get("TITLE").toString().equals("1");
        this.IDX_DRIVER_ID = this.field.get("IDX_DRIVER_ID") == null ? -1 : Integer.parseInt(this.field.get("IDX_DRIVER_ID").toString());
        this.IDX_DRIVER_CODE = this.field.get("IDX_DRIVER_CODE") == null ? -1 : Integer.parseInt(this.field.get("IDX_DRIVER_CODE").toString());
        this.IDX_DRIVER_FIRST_NAME = this.field.get("IDX_DRIVER_FIRST_NAME") == null ? -1 : Integer.parseInt(this.field.get("IDX_DRIVER_FIRST_NAME").toString());
        this.IDX_DRIVER_LAST_NAME = this.field.get("IDX_DRIVER_LAST_NAME") == null ? -1 : Integer.parseInt(this.field.get("IDX_DRIVER_LAST_NAME").toString());
        this.IDX_DATE = this.field.get("IDX_DATE") == null ? -1 : Integer.parseInt(this.field.get("IDX_DATE").toString());
        this.IDX_EXPIRATION = this.field.get("IDX_EXPIRATION") == null ? -1 : Integer.parseInt(this.field.get("IDX_EXPIRATION").toString());
        this.IDX_LENGTH = this.field.get("IDX_LENGTH") == null ? -1 : Integer.parseInt(this.field.get("IDX_LENGTH").toString());
        this.IDX_LIBELLE = this.field.get("IDX_LIBELLE") == null ? -1 : Integer.parseInt(this.field.get("IDX_LIBELLE").toString());
        this.IDX_PLACE = this.field.get("IDX_PLACE") == null ? -1 : Integer.parseInt(this.field.get("IDX_PLACE").toString());
        this.IDX_COMMENT = this.field.get("IDX_COMMENT") == null ? -1 : Integer.parseInt(this.field.get("IDX_COMMENT").toString());
        this.IDX_COST = this.field.get("IDX_COST") == null ? -1 : Integer.parseInt(this.field.get("IDX_COST").toString());
        this.IDX_STATE = this.field.get("IDX_STATE") == null ? -1 : Integer.parseInt(this.field.get("IDX_STATE").toString());
    }
}

