/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.ImportField;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.Vehicule;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.DataReader;
import transpo.system.imp.util.ExcelReader;
import transpo.system.util.Fonctions;

public class RoundAffectationImport
extends AbstractAutomaticWarning {
    private DataReader reader = null;
    private final String MODULE = "ROUND_AFFECTATION";
    HashMap<String, String> field = null;
    private int IDX_ROUND_ID = -1;
    private int IDX_DRIVER_ID = -1;
    private int IDX_DRIVER_FIRST_NAME = -1;
    private int IDX_DRIVER_LAST_NAME = -1;
    private int IDX_VEHICLE_ID = -1;
    private int IDX_IMMATRICULATION = -1;
    private int IDX_DATE = -1;
    private int IDX_SERVICE_POINT = -1;
    private int IDX_CLIENT_COUNT = -1;
    private int IDX_DELIVERY_PARCEL = -1;
    private int IDX_PICKING_PARCEL = -1;
    private int IDX_DONE = -1;
    private int IDX_BEGIN_TIME = -1;
    private int IDX_LOAD_TIME = -1;
    private int IDX_TOTAL_CUT_TIME = -1;
    private int IDX_DELIVERY_TIME = -1;
    private int IDX_RETURN_TIME = -1;
    private int IDX_UNLOAD_TIME = -1;
    private int IDX_TOTAL_TIME = -1;
    private int IDX_STOP_SERVICE_POINT = -1;
    private int IDX_DELIVERED_PARCEL = -1;
    private int IDX_UNDELIVERED_PARCEL = -1;
    private int IDX_PICKED_PARCEL = -1;
    private int IDX_CLIENT_DELIVERED = -1;
    private int IDX_KM = -1;
    private int CREATE = 0;

    @Override
    public void execute() {
        this.field = ImportField.loadHashMap("ROUND_AFFECTATION");
        if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
            TimsLogger.warn("#RoundAffectationImport.process# Missing parameters for RoundTypeImport (ROUND_AFFECTATION), can't continue");
            return;
        }
        int created = 0;
        boolean updated = false;
        boolean unchanged = false;
        int ignored = 0;
        BddTransport.getInstance().startTransaction();
        try {
            String file = this.field.get("FILENAME");
            String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
            String ext = file.substring(file.indexOf(".") + 1);
            if (ext.equals("xls")) {
                this.reader = new ExcelReader(file, dateFormat);
            } else if (ext.equals("csv")) {
                this.reader = new CsvReader(file, dateFormat);
            }
            this.initColmun();
            while (this.reader.next()) {
                String fDriverLastName;
                TimsLogger.debug("date " + this.reader.get(this.IDX_DATE));
                String error = "";
                String fRoundId = this.IDX_ROUND_ID == -1 ? null : this.reader.get(this.IDX_ROUND_ID);
                String fDriverId = this.IDX_DRIVER_ID == -1 ? null : this.reader.get(this.IDX_DRIVER_ID);
                String fDriverFirstName = this.IDX_DRIVER_FIRST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_FIRST_NAME).trim();
                String string = fDriverLastName = this.IDX_DRIVER_LAST_NAME == -1 ? null : this.reader.get(this.IDX_DRIVER_LAST_NAME).trim();
                if (this.IDX_DRIVER_FIRST_NAME == this.IDX_DRIVER_LAST_NAME && fDriverFirstName == null && !fDriverFirstName.equals("")) {
                    String[] names = fDriverFirstName.split(" ");
                    fDriverFirstName = names[names.length - 1];
                    fDriverLastName = fDriverLastName.substring(0, fDriverLastName.length() - fDriverFirstName.length() - 1);
                }
                String fVehicleId = this.IDX_VEHICLE_ID == -1 ? null : this.reader.get(this.IDX_VEHICLE_ID);
                String fImmatriculation = this.IDX_IMMATRICULATION == -1 ? null : this.reader.get(this.IDX_IMMATRICULATION).trim();
                Date fDate = this.IDX_DATE == -1 ? null : this.reader.getDate(this.IDX_DATE);
                int fServicePoint = this.IDX_SERVICE_POINT == -1 ? 0 : this.reader.getInt(this.IDX_SERVICE_POINT);
                int fClientCount = this.IDX_CLIENT_COUNT == -1 ? 0 : this.reader.getInt(this.IDX_CLIENT_COUNT);
                int fDeliveryParcel = this.IDX_DELIVERY_PARCEL == -1 ? 0 : this.reader.getInt(this.IDX_DELIVERY_PARCEL);
                int fPickingParcel = this.IDX_PICKING_PARCEL == -1 ? 0 : this.reader.getInt(this.IDX_PICKING_PARCEL);
                boolean fDone = (this.IDX_DONE == -1 ? 0 : this.reader.getInt(this.IDX_DONE)) == 1;
                int fBeginTime = this.IDX_BEGIN_TIME == -1 ? 0 : this.reader.getInt(this.IDX_BEGIN_TIME);
                int fLoadTime = this.IDX_LOAD_TIME == -1 ? 0 : this.reader.getInt(this.IDX_LOAD_TIME);
                int fTotalCutTime = this.IDX_TOTAL_CUT_TIME == -1 ? 0 : this.reader.getInt(this.IDX_TOTAL_CUT_TIME);
                int fDeliveryTime = this.IDX_DELIVERY_TIME == -1 ? 0 : this.reader.getInt(this.IDX_DELIVERY_TIME);
                int fReturnTime = this.IDX_RETURN_TIME == -1 ? 0 : this.reader.getInt(this.IDX_RETURN_TIME);
                int fUnloadTime = this.IDX_UNLOAD_TIME == -1 ? 0 : this.reader.getInt(this.IDX_UNLOAD_TIME);
                int fTotalTime = this.IDX_TOTAL_TIME == -1 ? 0 : this.reader.getInt(this.IDX_TOTAL_TIME);
                int fStopServicePoint = this.IDX_STOP_SERVICE_POINT == -1 ? 0 : this.reader.getInt(this.IDX_STOP_SERVICE_POINT);
                int fDeliveredParcel = this.IDX_DELIVERED_PARCEL == -1 ? 0 : this.reader.getInt(this.IDX_DELIVERED_PARCEL);
                int fUndeliveredParcel = this.IDX_UNDELIVERED_PARCEL == -1 ? 0 : this.reader.getInt(this.IDX_UNDELIVERED_PARCEL);
                int fPickedParcel = this.IDX_PICKED_PARCEL == -1 ? 0 : this.reader.getInt(this.IDX_PICKED_PARCEL);
                int fClientDelivered = this.IDX_CLIENT_DELIVERED == -1 ? 0 : this.reader.getInt(this.IDX_CLIENT_DELIVERED);
                int fKm = this.IDX_KM == -1 ? 0 : this.reader.getInt(this.IDX_KM);
                Conducteur driver = new Conducteur();
                Vehicule vehicle = new Vehicule();
                RoundType round = new RoundType();
                if (!(fRoundId == null || fRoundId.equals("0") || round.loadByCode(fRoundId) || Fonctions.isInt(fRoundId) && round.loadById(Integer.parseInt(fRoundId)))) {
                    round.setCode(fRoundId);
                    round.setDescription(fRoundId);
                    if (round.insert()) {
                        TimsLogger.debug("Round " + fRoundId + " created");
                        ++created;
                        round.loadByCode(fRoundId);
                    } else {
                        error = String.valueOf(error) + ": round type " + fRoundId + " creation error ";
                    }
                }
                if (!(fDriverId != null && driver.loadByCode(fDriverId) || Fonctions.isInt(fDriverId) && driver.loadById(Integer.parseInt(fDriverId)) || fDriverLastName != null && fDriverFirstName != null && driver.loadByName(fDriverLastName, fDriverFirstName))) {
                    if (this.CREATE == 1) {
                        driver.setMatricule(fDriverId);
                        driver.setPrenom(fDriverFirstName);
                        driver.setNom(fDriverLastName);
                        if (driver.insert()) {
                            TimsLogger.debug("driver " + fDriverLastName + " " + fDriverFirstName + " created");
                            driver.loadByName(fDriverLastName, fDriverFirstName);
                            ++created;
                        } else {
                            error = String.valueOf(error) + ": driver " + fDriverId + " creation error ";
                        }
                    } else {
                        error = String.valueOf(error) + ": driver " + fDriverId + " not found ";
                    }
                }
                if (!(fVehicleId != null && vehicle.loadByCode(fVehicleId) || vehicle.loadByImmat(fImmatriculation, false) || Fonctions.isInt(fVehicleId) && vehicle.loadById(Integer.parseInt(fVehicleId)))) {
                    if (this.CREATE == 1) {
                        vehicle.setRegistrationNumber(fImmatriculation);
                        vehicle.setIdentificationNumber(fVehicleId);
                        if (vehicle.insert()) {
                            TimsLogger.debug("vehicle " + fDriverLastName + " created");
                            vehicle.loadByImmat(fImmatriculation, false);
                            ++created;
                        } else {
                            error = String.valueOf(error) + ": vehicle " + fVehicleId + " creation error ";
                        }
                    } else {
                        error = String.valueOf(error) + ": vehicle " + fVehicleId + " not found ";
                    }
                }
                RoundAffectation ra = new RoundAffectation();
                if (!error.equals("")) {
                    TimsLogger.warn("#RoundAffectationImport.process# warning on line " + this.reader.getLine() + " " + error);
                    ++ignored;
                    continue;
                }
                ++created;
                ra.compareAndUpdate(round.getId(), driver.getCleConducteur(), vehicle.getCleVehicule(), fDate, fServicePoint, fClientCount, fDeliveryParcel, fPickingParcel, fDone, fBeginTime, fLoadTime, fTotalCutTime, fDeliveryTime, fReturnTime, fUnloadTime, fTotalTime, fStopServicePoint, fDeliveredParcel, fUndeliveredParcel, fPickedParcel, fClientDelivered, fKm, null, null);
            }
            if (Transport.debug >= 1) {
                BddTransport.getInstance().commit();
            } else {
                BddTransport.getInstance().commit();
            }
        }
        catch (Exception ex) {
            TimsLogger.error("Erreur syst\u00e8me");
            ex.printStackTrace();
            System.exit(1);
        }
        TimsLogger.info("\r\n#RoundTypeImport # Final result : " + created + " tourn\u00e9es cr\u00e9es ou MAJ " + ignored + " ignor\u00e9s.");
    }

    private void initColmun() {
        this.IDX_ROUND_ID = Integer.parseInt(this.field.get("IDX_ROUND_ID").toString());
        this.IDX_DRIVER_ID = Integer.parseInt(this.field.get("IDX_DRIVER_ID").toString());
        this.IDX_DRIVER_FIRST_NAME = Integer.parseInt(this.field.get("IDX_DRIVER_FIRST_NAME").toString());
        this.IDX_DRIVER_LAST_NAME = Integer.parseInt(this.field.get("IDX_DRIVER_LAST_NAME").toString());
        this.IDX_VEHICLE_ID = Integer.parseInt(this.field.get("IDX_VEHICLE_ID").toString());
        this.IDX_IMMATRICULATION = Integer.parseInt(this.field.get("IDX_IMMATRICULATION").toString());
        this.IDX_DATE = Integer.parseInt(this.field.get("IDX_DATE").toString());
        this.IDX_SERVICE_POINT = Integer.parseInt(this.field.get("IDX_SERVICE_POINT").toString());
        this.IDX_CLIENT_COUNT = Integer.parseInt(this.field.get("IDX_CLIENT_COUNT").toString());
        this.IDX_DELIVERY_PARCEL = Integer.parseInt(this.field.get("IDX_DELIVERY_PARCEL").toString());
        this.IDX_PICKING_PARCEL = Integer.parseInt(this.field.get("IDX_PICKING_PARCEL").toString());
        this.IDX_DONE = Integer.parseInt(this.field.get("IDX_DONE").toString());
        this.IDX_BEGIN_TIME = Integer.parseInt(this.field.get("IDX_BEGIN_TIME").toString());
        this.IDX_LOAD_TIME = Integer.parseInt(this.field.get("IDX_LOAD_TIME").toString());
        this.IDX_TOTAL_CUT_TIME = Integer.parseInt(this.field.get("IDX_TOTAL_CUT_TIME").toString());
        this.IDX_DELIVERY_TIME = Integer.parseInt(this.field.get("IDX_DELIVERY_TIME").toString());
        this.IDX_RETURN_TIME = Integer.parseInt(this.field.get("IDX_RETURN_TIME").toString());
        this.IDX_UNLOAD_TIME = Integer.parseInt(this.field.get("IDX_UNLOAD_TIME").toString());
        this.IDX_TOTAL_TIME = Integer.parseInt(this.field.get("IDX_TOTAL_TIME").toString());
        this.IDX_STOP_SERVICE_POINT = Integer.parseInt(this.field.get("IDX_STOP_SERVICE_POINT").toString());
        this.IDX_DELIVERED_PARCEL = Integer.parseInt(this.field.get("IDX_DELIVERED_PARCEL").toString());
        this.IDX_UNDELIVERED_PARCEL = Integer.parseInt(this.field.get("IDX_UNDELIVERED_PARCEL").toString());
        this.IDX_PICKED_PARCEL = Integer.parseInt(this.field.get("IDX_PICKED_PARCEL").toString());
        this.IDX_CLIENT_DELIVERED = Integer.parseInt(this.field.get("IDX_CLIENT_DELIVERED").toString());
        this.IDX_KM = Integer.parseInt(this.field.get("IDX_KM").toString());
        this.CREATE = Integer.parseInt(this.field.get("CREATE").toString());
        TimsLogger.debug("IDX_ROUND_ID " + this.IDX_ROUND_ID);
        TimsLogger.debug("IDX_DRIVER_ID " + this.IDX_DRIVER_ID);
        TimsLogger.debug("IDX_DRIVER_FIRST_NAME " + this.IDX_DRIVER_FIRST_NAME);
        TimsLogger.debug("IDX_DRIVER_LAST_NAME " + this.IDX_DRIVER_LAST_NAME);
        TimsLogger.debug("IDX_VEHICLE_ID " + this.IDX_VEHICLE_ID);
        TimsLogger.debug("IDX_IMMATRICULATION " + this.IDX_IMMATRICULATION);
        TimsLogger.debug("IDX_DATE " + this.IDX_DATE);
        TimsLogger.debug("IDX_SERVICE_POINT " + this.IDX_SERVICE_POINT);
        TimsLogger.debug("IDX_CLIENT_COUNT " + this.IDX_CLIENT_COUNT);
        TimsLogger.debug("IDX_DELIVERY_PARCEL " + this.IDX_DELIVERY_PARCEL);
        TimsLogger.debug("IDX_PICKING_PARCEL " + this.IDX_PICKING_PARCEL);
        TimsLogger.debug("IDX_DONE " + this.IDX_DONE);
        TimsLogger.debug("IDX_BEGIN_TIME " + this.IDX_BEGIN_TIME);
        TimsLogger.debug("IDX_LOAD_TIME " + this.IDX_LOAD_TIME);
        TimsLogger.debug("IDX_TOTAL_CUT_TIME " + this.IDX_TOTAL_CUT_TIME);
        TimsLogger.debug("IDX_DELIVERY_TIME " + this.IDX_DELIVERY_TIME);
        TimsLogger.debug("IDX_RETURN_TIME " + this.IDX_RETURN_TIME);
        TimsLogger.debug("IDX_UNLOAD_TIME " + this.IDX_UNLOAD_TIME);
        TimsLogger.debug("IDX_TOTAL_TIME " + this.IDX_TOTAL_TIME);
        TimsLogger.debug("IDX_STOP_SERVICE_POINT " + this.IDX_STOP_SERVICE_POINT);
        TimsLogger.debug("IDX_DELIVERED_PARCEL " + this.IDX_DELIVERED_PARCEL);
        TimsLogger.debug("IDX_UNDELIVERED_PARCEL " + this.IDX_UNDELIVERED_PARCEL);
        TimsLogger.debug("IDX_PICKED_PARCEL " + this.IDX_PICKED_PARCEL);
        TimsLogger.debug("IDX_CLIENT_DELIVERED " + this.IDX_CLIENT_DELIVERED);
        TimsLogger.debug("IDX_KM " + this.IDX_KM);
        TimsLogger.debug("CREATE " + this.CREATE);
    }
}

