/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ImportField;
import fr.pgh.data.bdd.RoundType;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.DataReader;
import transpo.system.imp.util.ExcelReader;

public class RoundTypeImport
extends AbstractAutomaticWarning {
    private DataReader reader = null;
    private final String MODULE = "ROUND_TYPE";
    HashMap<String, String> field = null;
    private int IDX_CODE = -1;
    private int IDX_DESCRIPTION = -1;
    private int IDX_MAX_SERVICE_POINT = -1;
    private int IDX_MAX_PARCEL = -1;
    private int IDX_BEGIN_TIME = -1;
    private int IDX_LOAD_TIME = -1;
    private int IDX_TOTAL_CUT_TIME = -1;
    private int IDX_RETURN_TIME = -1;
    private int IDX_UNLOAD_TIME = -1;
    private int IDX_TOTAL_TIME = -1;
    private int IDX_AVG_DELIVERY_TIME = -1;
    private int IDX_KM = -1;

    @Override
    public void execute() {
        this.field = ImportField.loadHashMap("ROUND_TYPE");
        if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
            TimsLogger.warn("#RoundTypeImport.process# Missing parameters for RoundTypeImport (ROUND_TYPE), can't continue");
            return;
        }
        int created = 0;
        int updated = 0;
        boolean unchanged = false;
        int ignored = 0;
        BddTransport.getInstance().startTransaction();
        try {
            String file = this.field.get("FILENAME");
            String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
            String ext = file.substring(file.indexOf(".") + 1);
            if (ext.equals("xls")) {
                this.reader = new ExcelReader(file, dateFormat);
            } else if (ext.equals("csv")) {
                this.reader = new CsvReader(file, dateFormat);
            }
            this.initColmun();
            while (this.reader.next()) {
                String fCode = this.IDX_CODE == -1 ? null : this.reader.get(this.IDX_CODE);
                String fDescription = this.IDX_DESCRIPTION == -1 ? null : this.reader.get(this.IDX_DESCRIPTION);
                int fBeginTime = this.IDX_BEGIN_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_BEGIN_TIME));
                int fLoadTime = this.IDX_LOAD_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_LOAD_TIME));
                int fTotalCutTime = this.IDX_TOTAL_CUT_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_TOTAL_CUT_TIME));
                int fReturnTime = this.IDX_RETURN_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_RETURN_TIME));
                int fUnloadTime = this.IDX_UNLOAD_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_UNLOAD_TIME));
                int fTotalTime = this.IDX_TOTAL_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_TOTAL_TIME));
                int fAvgDeliveryTime = this.IDX_AVG_DELIVERY_TIME == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_AVG_DELIVERY_TIME));
                int fMaxServicePoint = this.IDX_MAX_SERVICE_POINT == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_MAX_SERVICE_POINT));
                int fMaxParcel = this.IDX_MAX_PARCEL == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_MAX_PARCEL));
                int fKm = this.IDX_KM == -1 ? null : Integer.valueOf(this.reader.getInt(this.IDX_KM));
                RoundType round = new RoundType();
                if (fCode == null || fCode.equals("")) {
                    TimsLogger.warn("#RoundTypeImport.process# line ignored (no code)");
                    ++ignored;
                } else if (!round.loadByCode(fCode)) {
                    ++created;
                } else {
                    ++updated;
                }
                boolean bl = round.compareAndUpdate(fCode, fDescription, fBeginTime, fLoadTime, fTotalCutTime, fReturnTime, fUnloadTime, fTotalTime, fMaxServicePoint, fMaxParcel, fAvgDeliveryTime, fKm, false);
            }
            if (Transport.debug >= 1) {
                BddTransport.getInstance().rollback();
            } else {
                BddTransport.getInstance().commit();
            }
        }
        catch (Exception ex) {
            TimsLogger.error("Erreur syst\u00e8me");
            ex.printStackTrace();
            System.exit(1);
        }
        TimsLogger.info("\r\n#RoundTypeImport# Final result : " + created + " tourn\u00e9es cr\u00e9es, " + updated + " mis \u00e0 jour (changement ou non), " + ignored + " ignor\u00e9s.");
    }

    private void initColmun() {
        this.IDX_CODE = Integer.parseInt(this.field.get("IDX_CODE").toString());
        this.IDX_DESCRIPTION = Integer.parseInt(this.field.get("IDX_DESCRIPTION").toString());
        this.IDX_MAX_SERVICE_POINT = Integer.parseInt(this.field.get("IDX_MAX_SERVICE_POINT").toString());
        this.IDX_MAX_PARCEL = Integer.parseInt(this.field.get("IDX_MAX_PARCEL").toString());
        this.IDX_BEGIN_TIME = Integer.parseInt(this.field.get("IDX_BEGIN_TIME").toString());
        this.IDX_LOAD_TIME = Integer.parseInt(this.field.get("IDX_LOAD_TIME").toString());
        this.IDX_TOTAL_CUT_TIME = Integer.parseInt(this.field.get("IDX_TOTAL_CUT_TIME").toString());
        this.IDX_RETURN_TIME = Integer.parseInt(this.field.get("IDX_RETURN_TIME").toString());
        this.IDX_UNLOAD_TIME = Integer.parseInt(this.field.get("IDX_UNLOAD_TIME").toString());
        this.IDX_TOTAL_TIME = Integer.parseInt(this.field.get("IDX_TOTAL_TIME").toString());
        this.IDX_AVG_DELIVERY_TIME = Integer.parseInt(this.field.get("IDX_AVG_DELIVERY_TIME").toString());
        this.IDX_KM = Integer.parseInt(this.field.get("IDX_KM").toString());
    }
}

